/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Unit;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MethodParameter {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Executable executable;
    private final int parameterIndex;
    @Nullable
    private volatile Parameter parameter;
    private int nestingLevel;
    @Nullable
    Map<Integer, Integer> typeIndexesPerLevel;
    @Nullable
    private volatile Class<?> containingClass;
    @Nullable
    private volatile Class<?> parameterType;
    @Nullable
    private volatile Type genericParameterType;
    @Nullable
    private volatile Annotation[] parameterAnnotations;
    @Nullable
    private volatile ParameterNameDiscoverer parameterNameDiscoverer;
    @Nullable
    private volatile String parameterName;
    @Nullable
    private volatile MethodParameter nestedMethodParameter;

    public MethodParameter(Method method, int n) {
        this(method, n, 1);
    }

    public MethodParameter(Method method, int n, int n2) {
        Assert.notNull((Object)method, "Method must not be null");
        this.executable = method;
        this.parameterIndex = MethodParameter.validateIndex(method, n);
        this.nestingLevel = n2;
    }

    public MethodParameter(Constructor<?> constructor, int n) {
        this(constructor, n, 1);
    }

    public MethodParameter(Constructor<?> constructor, int n, int n2) {
        Assert.notNull(constructor, "Constructor must not be null");
        this.executable = constructor;
        this.parameterIndex = MethodParameter.validateIndex(constructor, n);
        this.nestingLevel = n2;
    }

    MethodParameter(Executable executable, int n, @Nullable Class<?> clazz) {
        Assert.notNull((Object)executable, "Executable must not be null");
        this.executable = executable;
        this.parameterIndex = MethodParameter.validateIndex(executable, n);
        this.nestingLevel = 1;
        this.containingClass = clazz;
    }

    public MethodParameter(MethodParameter methodParameter) {
        Assert.notNull((Object)methodParameter, "Original must not be null");
        this.executable = methodParameter.executable;
        this.parameterIndex = methodParameter.parameterIndex;
        this.parameter = methodParameter.parameter;
        this.nestingLevel = methodParameter.nestingLevel;
        this.typeIndexesPerLevel = methodParameter.typeIndexesPerLevel;
        this.containingClass = methodParameter.containingClass;
        this.parameterType = methodParameter.parameterType;
        this.genericParameterType = methodParameter.genericParameterType;
        this.parameterAnnotations = methodParameter.parameterAnnotations;
        this.parameterNameDiscoverer = methodParameter.parameterNameDiscoverer;
        this.parameterName = methodParameter.parameterName;
    }

    @Nullable
    public Method getMethod() {
        return this.executable instanceof Method ? (Method)this.executable : null;
    }

    @Nullable
    public Constructor<?> getConstructor() {
        return this.executable instanceof Constructor ? (Constructor)this.executable : null;
    }

    public Class<?> getDeclaringClass() {
        return this.executable.getDeclaringClass();
    }

    public Member getMember() {
        return this.executable;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.executable;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public Parameter getParameter() {
        if (this.parameterIndex < 0) {
            throw new IllegalStateException("Cannot retrieve Parameter descriptor for method return type");
        }
        Parameter parameter = this.parameter;
        if (parameter == null) {
            this.parameter = parameter = this.getExecutable().getParameters()[this.parameterIndex];
        }
        return parameter;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    @Deprecated
    public void increaseNestingLevel() {
        ++this.nestingLevel;
    }

    @Deprecated
    public void decreaseNestingLevel() {
        this.getTypeIndexesPerLevel().remove(this.nestingLevel);
        --this.nestingLevel;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public MethodParameter withTypeIndex(int n) {
        return this.nested(this.nestingLevel, n);
    }

    @Deprecated
    public void setTypeIndexForCurrentLevel(int n) {
        this.getTypeIndexesPerLevel().put(this.nestingLevel, n);
    }

    @Nullable
    public Integer getTypeIndexForCurrentLevel() {
        return this.getTypeIndexForLevel(this.nestingLevel);
    }

    @Nullable
    public Integer getTypeIndexForLevel(int n) {
        return this.getTypeIndexesPerLevel().get(n);
    }

    private Map<Integer, Integer> getTypeIndexesPerLevel() {
        if (this.typeIndexesPerLevel == null) {
            this.typeIndexesPerLevel = new HashMap<Integer, Integer>(4);
        }
        return this.typeIndexesPerLevel;
    }

    public MethodParameter nested() {
        return this.nested(null);
    }

    public MethodParameter nested(@Nullable Integer n) {
        MethodParameter methodParameter = this.nestedMethodParameter;
        if (methodParameter != null && n == null) {
            return methodParameter;
        }
        methodParameter = this.nested(this.nestingLevel + 1, n);
        if (n == null) {
            this.nestedMethodParameter = methodParameter;
        }
        return methodParameter;
    }

    private MethodParameter nested(int n, @Nullable Integer n2) {
        MethodParameter methodParameter = this.clone();
        methodParameter.nestingLevel = n;
        if (this.typeIndexesPerLevel != null) {
            methodParameter.typeIndexesPerLevel = new HashMap<Integer, Integer>(this.typeIndexesPerLevel);
        }
        if (n2 != null) {
            methodParameter.getTypeIndexesPerLevel().put(methodParameter.nestingLevel, n2);
        }
        methodParameter.parameterType = null;
        methodParameter.genericParameterType = null;
        return methodParameter;
    }

    public boolean isOptional() {
        return this.getParameterType() == Optional.class || this.hasNullableAnnotation() || KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(this.getContainingClass()) && KotlinDelegate.isOptional(this);
    }

    private boolean hasNullableAnnotation() {
        for (Annotation annotation : this.getParameterAnnotations()) {
            if (!"Nullable".equals(annotation.annotationType().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    public MethodParameter nestedIfOptional() {
        return this.getParameterType() == Optional.class ? this.nested() : this;
    }

    public MethodParameter withContainingClass(@Nullable Class<?> clazz) {
        MethodParameter methodParameter = this.clone();
        methodParameter.containingClass = clazz;
        methodParameter.parameterType = null;
        return methodParameter;
    }

    @Deprecated
    void setContainingClass(Class<?> clazz) {
        this.containingClass = clazz;
        this.parameterType = null;
    }

    public Class<?> getContainingClass() {
        Class<?> clazz = this.containingClass;
        return clazz != null ? clazz : this.getDeclaringClass();
    }

    @Deprecated
    void setParameterType(@Nullable Class<?> clazz) {
        this.parameterType = clazz;
    }

    public Class<?> getParameterType() {
        Class<?> clazz = this.parameterType;
        if (clazz != null) {
            return clazz;
        }
        if (this.getContainingClass() != this.getDeclaringClass()) {
            clazz = ResolvableType.forMethodParameter(this, null, 1).resolve();
        }
        if (clazz == null) {
            clazz = this.computeParameterType();
        }
        this.parameterType = clazz;
        return clazz;
    }

    public Type getGenericParameterType() {
        Class<Void> clazz = this.genericParameterType;
        if (clazz == null) {
            if (this.parameterIndex < 0) {
                Method method = this.getMethod();
                clazz = method != null ? (KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(this.getContainingClass()) ? KotlinDelegate.getGenericReturnType(method) : method.getGenericReturnType()) : Void.TYPE;
            } else {
                Type[] typeArray = this.executable.getGenericParameterTypes();
                int n = this.parameterIndex;
                if (this.executable instanceof Constructor && ClassUtils.isInnerClass(this.executable.getDeclaringClass()) && typeArray.length == this.executable.getParameterCount() - 1) {
                    n = this.parameterIndex - 1;
                }
                clazz = n >= 0 && n < typeArray.length ? typeArray[n] : this.computeParameterType();
            }
            this.genericParameterType = clazz;
        }
        return clazz;
    }

    private Class<?> computeParameterType() {
        if (this.parameterIndex < 0) {
            Method method = this.getMethod();
            if (method == null) {
                return Void.TYPE;
            }
            if (KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(this.getContainingClass())) {
                return KotlinDelegate.getReturnType(method);
            }
            return method.getReturnType();
        }
        return this.executable.getParameterTypes()[this.parameterIndex];
    }

    public Class<?> getNestedParameterType() {
        if (this.nestingLevel > 1) {
            Type type;
            Type type2 = this.getGenericParameterType();
            for (int i = 2; i <= this.nestingLevel; ++i) {
                if (!(type2 instanceof ParameterizedType)) continue;
                Type[] typeArray = ((ParameterizedType)type2).getActualTypeArguments();
                Integer n = this.getTypeIndexForLevel(i);
                type2 = typeArray[n != null ? n : typeArray.length - 1];
            }
            if (type2 instanceof Class) {
                return (Class)type2;
            }
            if (type2 instanceof ParameterizedType && (type = ((ParameterizedType)type2).getRawType()) instanceof Class) {
                return (Class)type;
            }
            return Object.class;
        }
        return this.getParameterType();
    }

    public Type getNestedGenericParameterType() {
        if (this.nestingLevel > 1) {
            Type type = this.getGenericParameterType();
            for (int i = 2; i <= this.nestingLevel; ++i) {
                if (!(type instanceof ParameterizedType)) continue;
                Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                Integer n = this.getTypeIndexForLevel(i);
                type = typeArray[n != null ? n : typeArray.length - 1];
            }
            return type;
        }
        return this.getGenericParameterType();
    }

    public Annotation[] getMethodAnnotations() {
        return this.adaptAnnotationArray(this.getAnnotatedElement().getAnnotations());
    }

    @Nullable
    public <A extends Annotation> A getMethodAnnotation(Class<A> clazz) {
        A a = this.getAnnotatedElement().getAnnotation(clazz);
        return a != null ? (A)this.adaptAnnotation(a) : null;
    }

    public <A extends Annotation> boolean hasMethodAnnotation(Class<A> clazz) {
        return this.getAnnotatedElement().isAnnotationPresent(clazz);
    }

    public Annotation[] getParameterAnnotations() {
        Annotation[] annotationArray = this.parameterAnnotations;
        if (annotationArray == null) {
            Annotation[][] annotationArray2 = this.executable.getParameterAnnotations();
            int n = this.parameterIndex;
            if (this.executable instanceof Constructor && ClassUtils.isInnerClass(this.executable.getDeclaringClass()) && annotationArray2.length == this.executable.getParameterCount() - 1) {
                n = this.parameterIndex - 1;
            }
            annotationArray = n >= 0 && n < annotationArray2.length ? this.adaptAnnotationArray(annotationArray2[n]) : EMPTY_ANNOTATION_ARRAY;
            this.parameterAnnotations = annotationArray;
        }
        return annotationArray;
    }

    public boolean hasParameterAnnotations() {
        return this.getParameterAnnotations().length != 0;
    }

    @Nullable
    public <A extends Annotation> A getParameterAnnotation(Class<A> clazz) {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = this.getParameterAnnotations()) {
            if (!clazz.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    public <A extends Annotation> boolean hasParameterAnnotation(Class<A> clazz) {
        return this.getParameterAnnotation(clazz) != null;
    }

    public void initParameterNameDiscovery(@Nullable ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    @Nullable
    public String getParameterName() {
        if (this.parameterIndex < 0) {
            return null;
        }
        ParameterNameDiscoverer parameterNameDiscoverer = this.parameterNameDiscoverer;
        if (parameterNameDiscoverer != null) {
            String[] stringArray = null;
            if (this.executable instanceof Method) {
                stringArray = parameterNameDiscoverer.getParameterNames((Method)this.executable);
            } else if (this.executable instanceof Constructor) {
                stringArray = parameterNameDiscoverer.getParameterNames((Constructor)this.executable);
            }
            if (stringArray != null) {
                this.parameterName = stringArray[this.parameterIndex];
            }
            this.parameterNameDiscoverer = null;
        }
        return this.parameterName;
    }

    protected <A extends Annotation> A adaptAnnotation(A a) {
        return a;
    }

    protected Annotation[] adaptAnnotationArray(Annotation[] annotationArray) {
        return annotationArray;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodParameter)) {
            return false;
        }
        MethodParameter methodParameter = (MethodParameter)object;
        return this.getContainingClass() == methodParameter.getContainingClass() && ObjectUtils.nullSafeEquals(this.typeIndexesPerLevel, methodParameter.typeIndexesPerLevel) && this.nestingLevel == methodParameter.nestingLevel && this.parameterIndex == methodParameter.parameterIndex && this.executable.equals(methodParameter.executable);
    }

    public int hashCode() {
        return 31 * this.executable.hashCode() + this.parameterIndex;
    }

    public String toString() {
        Method method = this.getMethod();
        return (method != null ? "method '" + method.getName() + "'" : "constructor") + " parameter " + this.parameterIndex;
    }

    public MethodParameter clone() {
        return new MethodParameter(this);
    }

    @Deprecated
    public static MethodParameter forMethodOrConstructor(Object object, int n) {
        if (!(object instanceof Executable)) {
            throw new IllegalArgumentException("Given object [" + object + "] is neither a Method nor a Constructor");
        }
        return MethodParameter.forExecutable((Executable)object, n);
    }

    public static MethodParameter forExecutable(Executable executable, int n) {
        if (executable instanceof Method) {
            return new MethodParameter((Method)executable, n);
        }
        if (executable instanceof Constructor) {
            return new MethodParameter((Constructor)executable, n);
        }
        throw new IllegalArgumentException("Not a Method/Constructor: " + executable);
    }

    public static MethodParameter forParameter(Parameter parameter) {
        return MethodParameter.forExecutable(parameter.getDeclaringExecutable(), MethodParameter.findParameterIndex(parameter));
    }

    protected static int findParameterIndex(Parameter parameter) {
        int n;
        Executable executable = parameter.getDeclaringExecutable();
        Parameter[] parameterArray = executable.getParameters();
        for (n = 0; n < parameterArray.length; ++n) {
            if (parameter != parameterArray[n]) continue;
            return n;
        }
        for (n = 0; n < parameterArray.length; ++n) {
            if (!parameter.equals(parameterArray[n])) continue;
            return n;
        }
        throw new IllegalArgumentException("Given parameter [" + parameter + "] does not match any parameter in the declaring executable");
    }

    private static int validateIndex(Executable executable, int n) {
        int n2 = executable.getParameterCount();
        Assert.isTrue(n >= -1 && n < n2, () -> "Parameter index needs to be between -1 and " + (n2 - 1));
        return n;
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static boolean isOptional(MethodParameter methodParameter) {
            Predicate<KParameter> predicate;
            KFunction kFunction;
            Method method = methodParameter.getMethod();
            int n = methodParameter.getParameterIndex();
            if (method != null && n == -1) {
                KFunction kFunction2 = ReflectJvmMapping.getKotlinFunction((Method)method);
                return kFunction2 != null && kFunction2.getReturnType().isMarkedNullable();
            }
            if (method != null) {
                if (methodParameter.getParameterType().getName().equals("kotlin.coroutines.Continuation")) {
                    return true;
                }
                kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
                predicate = kParameter -> KParameter.Kind.VALUE.equals((Object)kParameter.getKind());
            } else {
                Constructor<?> constructor = methodParameter.getConstructor();
                Assert.state(constructor != null, "Neither method nor constructor found");
                kFunction = ReflectJvmMapping.getKotlinFunction(constructor);
                predicate = kParameter -> KParameter.Kind.VALUE.equals((Object)kParameter.getKind()) || KParameter.Kind.INSTANCE.equals((Object)kParameter.getKind());
            }
            if (kFunction != null) {
                int n2 = 0;
                for (KParameter kParameter2 : kFunction.getParameters()) {
                    if (!predicate.test(kParameter2) || n != n2++) continue;
                    return kParameter2.getType().isMarkedNullable() || kParameter2.isOptional();
                }
            }
            return false;
        }

        private static Type getGenericReturnType(Method method) {
            try {
                KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
                if (kFunction != null && kFunction.isSuspend()) {
                    return ReflectJvmMapping.getJavaType((KType)kFunction.getReturnType());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return method.getGenericReturnType();
        }

        private static Class<?> getReturnType(Method method) {
            try {
                KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
                if (kFunction != null && kFunction.isSuspend()) {
                    Class<Void> clazz = ReflectJvmMapping.getJavaType((KType)kFunction.getReturnType());
                    if (clazz == Unit.class) {
                        clazz = Void.TYPE;
                    }
                    return ResolvableType.forType(clazz).resolve(method.getReturnType());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return method.getReturnType();
        }
    }
}

