/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class MethodIntrospector {
    private MethodIntrospector() {
    }

    public static <T> Map<Method, T> selectMethods(Class<?> clazz, MetadataLookup<T> metadataLookup) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Class clazz2 = null;
        if (!Proxy.isProxyClass(clazz)) {
            clazz2 = ClassUtils.getUserClass(clazz);
            linkedHashSet.add(clazz2);
        }
        linkedHashSet.addAll(ClassUtils.getAllInterfacesForClassAsSet(clazz));
        for (Class clazz3 : linkedHashSet) {
            Class clazz4 = clazz2 != null ? clazz2 : clazz3;
            ReflectionUtils.doWithMethods(clazz3, method -> {
                Method method2;
                Method method3 = ClassUtils.getMostSpecificMethod(method, clazz4);
                Object t2 = metadataLookup.inspect(method3);
                if (t2 != null && ((method2 = BridgeMethodResolver.findBridgedMethod(method3)) == method3 || metadataLookup.inspect(method2) == null)) {
                    linkedHashMap.put(method3, t2);
                }
            }, ReflectionUtils.USER_DECLARED_METHODS);
        }
        return linkedHashMap;
    }

    public static Set<Method> selectMethods(Class<?> clazz, ReflectionUtils.MethodFilter methodFilter) {
        return MethodIntrospector.selectMethods(clazz, (Method method) -> methodFilter.matches(method) ? Boolean.TRUE : null).keySet();
    }

    public static Method selectInvocableMethod(Method method, Class<?> clazz) {
        if (method.getDeclaringClass().isAssignableFrom(clazz)) {
            return method;
        }
        try {
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                try {
                    return clazz2.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(String.format("Need to invoke method '%s' declared on target class '%s', but not found in any interface(s) of the exposed proxy type. Either pull the method up to an interface or switch to CGLIB proxies by enforcing proxy-target-class mode in your configuration.", method.getName(), method.getDeclaringClass().getSimpleName()));
        }
    }

    @FunctionalInterface
    public static interface MetadataLookup<T> {
        @Nullable
        public T inspect(Method var1);
    }
}

