/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public final class MethodClassKey
implements Comparable<MethodClassKey> {
    private final Method method;
    @Nullable
    private final Class<?> targetClass;

    public MethodClassKey(Method method, @Nullable Class<?> clazz) {
        this.method = method;
        this.targetClass = clazz;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodClassKey)) {
            return false;
        }
        MethodClassKey methodClassKey = (MethodClassKey)object;
        return this.method.equals(methodClassKey.method) && ObjectUtils.nullSafeEquals(this.targetClass, methodClassKey.targetClass);
    }

    public int hashCode() {
        return this.method.hashCode() + (this.targetClass != null ? this.targetClass.hashCode() * 29 : 0);
    }

    public String toString() {
        return this.method + (this.targetClass != null ? " on " + this.targetClass : "");
    }

    @Override
    public int compareTo(MethodClassKey methodClassKey) {
        int n = this.method.getName().compareTo(methodClassKey.method.getName());
        if (n == 0 && (n = this.method.toString().compareTo(methodClassKey.method.toString())) == 0 && this.targetClass != null && methodClassKey.targetClass != null) {
            n = this.targetClass.getName().compareTo(methodClassKey.targetClass.getName());
        }
        return n;
    }
}

