/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public final class GenericTypeResolver {
    private static final Map<Class<?>, Map<TypeVariable, Type>> typeVariableCache = new ConcurrentReferenceHashMap();

    private GenericTypeResolver() {
    }

    @Deprecated
    public static Class<?> resolveParameterType(MethodParameter methodParameter, Class<?> clazz) {
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        Assert.notNull(clazz, "Class must not be null");
        methodParameter.setContainingClass(clazz);
        return methodParameter.getParameterType();
    }

    public static Class<?> resolveReturnType(Method method, Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return ResolvableType.forMethodReturnType(method, clazz).resolve(method.getReturnType());
    }

    @Nullable
    public static Class<?> resolveReturnTypeArgument(Method method, Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        ResolvableType resolvableType = ResolvableType.forMethodReturnType(method).as(clazz);
        if (!resolvableType.hasGenerics() || resolvableType.getType() instanceof WildcardType) {
            return null;
        }
        return GenericTypeResolver.getSingleGeneric(resolvableType);
    }

    @Nullable
    public static Class<?> resolveTypeArgument(Class<?> clazz, Class<?> clazz2) {
        ResolvableType resolvableType = ResolvableType.forClass(clazz).as(clazz2);
        if (!resolvableType.hasGenerics()) {
            return null;
        }
        return GenericTypeResolver.getSingleGeneric(resolvableType);
    }

    @Nullable
    private static Class<?> getSingleGeneric(ResolvableType resolvableType) {
        Assert.isTrue(resolvableType.getGenerics().length == 1, () -> "Expected 1 type argument on generic interface [" + resolvableType + "] but found " + resolvableType.getGenerics().length);
        return resolvableType.getGeneric(new int[0]).resolve();
    }

    @Nullable
    public static Class<?>[] resolveTypeArguments(Class<?> clazz, Class<?> clazz2) {
        ResolvableType resolvableType = ResolvableType.forClass(clazz).as(clazz2);
        if (!resolvableType.hasGenerics() || resolvableType.isEntirelyUnresolvable()) {
            return null;
        }
        return resolvableType.resolveGenerics(Object.class);
    }

    public static Type resolveType(Type type, @Nullable Class<?> clazz) {
        if (clazz != null) {
            ResolvableType resolvableType;
            if (type instanceof TypeVariable) {
                Class<?> clazz2;
                ResolvableType resolvableType2 = GenericTypeResolver.resolveVariable((TypeVariable)type, ResolvableType.forClass(clazz));
                if (resolvableType2 != ResolvableType.NONE && (clazz2 = resolvableType2.resolve()) != null) {
                    return clazz2;
                }
            } else if (type instanceof ParameterizedType && (resolvableType = ResolvableType.forType(type)).hasUnresolvableGenerics()) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class[] classArray = new Class[parameterizedType.getActualTypeArguments().length];
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                ResolvableType resolvableType3 = ResolvableType.forClass(clazz);
                for (int i = 0; i < typeArray.length; ++i) {
                    Type type2 = typeArray[i];
                    if (type2 instanceof TypeVariable) {
                        ResolvableType resolvableType4 = GenericTypeResolver.resolveVariable((TypeVariable)type2, resolvableType3);
                        if (resolvableType4 != ResolvableType.NONE) {
                            classArray[i] = resolvableType4.resolve();
                            continue;
                        }
                        classArray[i] = ResolvableType.forType(type2).resolve();
                        continue;
                    }
                    classArray[i] = ResolvableType.forType(type2).resolve();
                }
                Class<?> clazz3 = resolvableType.getRawClass();
                if (clazz3 != null) {
                    return ResolvableType.forClassWithGenerics(clazz3, classArray).getType();
                }
            }
        }
        return type;
    }

    private static ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType resolvableType) {
        ResolvableType resolvableType2;
        if (resolvableType.hasGenerics() && (resolvableType2 = ResolvableType.forType(typeVariable, resolvableType)).resolve() != null) {
            return resolvableType2;
        }
        ResolvableType resolvableType3 = resolvableType.getSuperType();
        if (resolvableType3 != ResolvableType.NONE && (resolvableType2 = GenericTypeResolver.resolveVariable(typeVariable, resolvableType3)).resolve() != null) {
            return resolvableType2;
        }
        for (ResolvableType resolvableType4 : resolvableType.getInterfaces()) {
            resolvableType2 = GenericTypeResolver.resolveVariable(typeVariable, resolvableType4);
            if (resolvableType2.resolve() == null) continue;
            return resolvableType2;
        }
        return ResolvableType.NONE;
    }

    public static Class<?> resolveType(Type type, Map<TypeVariable, Type> map) {
        return ResolvableType.forType(type, new TypeVariableMapVariableResolver(map)).toClass();
    }

    public static Map<TypeVariable, Type> getTypeVariableMap(Class<?> clazz) {
        Map<TypeVariable, Type> map = typeVariableCache.get(clazz);
        if (map == null) {
            map = new HashMap<TypeVariable, Type>();
            GenericTypeResolver.buildTypeVariableMap(ResolvableType.forClass(clazz), map);
            typeVariableCache.put(clazz, Collections.unmodifiableMap(map));
        }
        return map;
    }

    private static void buildTypeVariableMap(ResolvableType resolvableType, Map<TypeVariable, Type> map) {
        if (resolvableType != ResolvableType.NONE) {
            Class<?> clazz = resolvableType.resolve();
            if (clazz != null && resolvableType.getType() instanceof ParameterizedType) {
                Object[] objectArray = clazz.getTypeParameters();
                for (int i = 0; i < objectArray.length; ++i) {
                    ResolvableType resolvableType2 = resolvableType.getGeneric(i);
                    while (resolvableType2.getType() instanceof TypeVariable) {
                        resolvableType2 = resolvableType2.resolveType();
                    }
                    if (resolvableType2 == ResolvableType.NONE) continue;
                    map.put((TypeVariable)objectArray[i], resolvableType2.getType());
                }
            }
            GenericTypeResolver.buildTypeVariableMap(resolvableType.getSuperType(), map);
            for (ResolvableType resolvableType3 : resolvableType.getInterfaces()) {
                GenericTypeResolver.buildTypeVariableMap(resolvableType3, map);
            }
            if (clazz != null && clazz.isMemberClass()) {
                GenericTypeResolver.buildTypeVariableMap(ResolvableType.forClass(clazz.getEnclosingClass()), map);
            }
        }
    }

    private static class TypeVariableMapVariableResolver
    implements ResolvableType.VariableResolver {
        private final Map<TypeVariable, Type> typeVariableMap;

        public TypeVariableMapVariableResolver(Map<TypeVariable, Type> map) {
            this.typeVariableMap = map;
        }

        @Override
        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> typeVariable) {
            Type type = this.typeVariableMap.get(typeVariable);
            return type != null ? ResolvableType.forType(type) : null;
        }

        @Override
        public Object getSource() {
            return this.typeVariableMap;
        }
    }
}

