/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.AttributeAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AttributeAccessorSupport
implements Serializable,
AttributeAccessor {
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    @Override
    public void setAttribute(String string, @Nullable Object object) {
        Assert.notNull((Object)string, "Name must not be null");
        if (object != null) {
            this.attributes.put(string, object);
        } else {
            this.removeAttribute(string);
        }
    }

    @Override
    @Nullable
    public Object getAttribute(String string) {
        Assert.notNull((Object)string, "Name must not be null");
        return this.attributes.get(string);
    }

    @Override
    @Nullable
    public Object removeAttribute(String string) {
        Assert.notNull((Object)string, "Name must not be null");
        return this.attributes.remove(string);
    }

    @Override
    public boolean hasAttribute(String string) {
        Assert.notNull((Object)string, "Name must not be null");
        return this.attributes.containsKey(string);
    }

    @Override
    public String[] attributeNames() {
        return StringUtils.toStringArray(this.attributes.keySet());
    }

    protected void copyAttributesFrom(AttributeAccessor attributeAccessor) {
        String[] stringArray;
        Assert.notNull((Object)attributeAccessor, "Source must not be null");
        for (String string : stringArray = attributeAccessor.attributeNames()) {
            this.setAttribute(string, attributeAccessor.getAttribute(string));
        }
    }

    public boolean equals(@Nullable Object object) {
        return this == object || object instanceof AttributeAccessorSupport && this.attributes.equals(((AttributeAccessorSupport)object).attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }
}

