/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.util;

import java.util.Arrays;
import java.util.List;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.KeyFactory;
import org.springframework.cglib.core.ObjectSwitchCallback;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

public abstract class StringSwitcher {
    private static final Type STRING_SWITCHER = TypeUtils.parseType("org.springframework.cglib.util.StringSwitcher");
    private static final Signature INT_VALUE = TypeUtils.parseSignature("int intValue(String)");
    private static final StringSwitcherKey KEY_FACTORY = (StringSwitcherKey)((Object)KeyFactory.create(StringSwitcherKey.class));

    public static StringSwitcher create(String[] stringArray, int[] nArray, boolean bl) {
        Generator generator = new Generator();
        generator.setStrings(stringArray);
        generator.setInts(nArray);
        generator.setFixedInput(bl);
        return generator.create();
    }

    protected StringSwitcher() {
    }

    public abstract int intValue(String var1);

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(StringSwitcher.class.getName());
        private String[] strings;
        private int[] ints;
        private boolean fixedInput;

        public Generator() {
            super(SOURCE);
        }

        public void setStrings(String[] stringArray) {
            this.strings = stringArray;
        }

        public void setInts(int[] nArray) {
            this.ints = nArray;
        }

        public void setFixedInput(boolean bl) {
            this.fixedInput = bl;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.getClass().getClassLoader();
        }

        public StringSwitcher create() {
            this.setNamePrefix(StringSwitcher.class.getName());
            Object object = KEY_FACTORY.newInstance(this.strings, this.ints, this.fixedInput);
            return (StringSwitcher)super.create(object);
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) throws Exception {
            ClassEmitter classEmitter = new ClassEmitter(classVisitor);
            classEmitter.begin_class(52, 1, this.getClassName(), STRING_SWITCHER, null, "<generated>");
            EmitUtils.null_constructor(classEmitter);
            final CodeEmitter codeEmitter = classEmitter.begin_method(1, INT_VALUE, null);
            codeEmitter.load_arg(0);
            final List<String> list = Arrays.asList(this.strings);
            int n = this.fixedInput ? 2 : 1;
            EmitUtils.string_switch(codeEmitter, this.strings, n, new ObjectSwitchCallback(){

                @Override
                public void processCase(Object object, Label label) {
                    codeEmitter.push(ints[list.indexOf(object)]);
                    codeEmitter.return_value();
                }

                @Override
                public void processDefault() {
                    codeEmitter.push(-1);
                    codeEmitter.return_value();
                }
            });
            codeEmitter.end_method();
            classEmitter.end_class();
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return (StringSwitcher)ReflectUtils.newInstance(clazz);
        }

        @Override
        protected Object nextInstance(Object object) {
            return object;
        }
    }

    static interface StringSwitcherKey {
        public Object newInstance(String[] var1, int[] var2, boolean var3);
    }
}

