/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;
import org.springframework.cglib.transform.impl.InterceptFieldFilter;

public class InterceptFieldTransformer
extends ClassEmitterTransformer {
    private static final String CALLBACK_FIELD = "$CGLIB_READ_WRITE_CALLBACK";
    private static final Type CALLBACK = TypeUtils.parseType("org.springframework.cglib.transform.impl.InterceptFieldCallback");
    private static final Type ENABLED = TypeUtils.parseType("org.springframework.cglib.transform.impl.InterceptFieldEnabled");
    private static final Signature ENABLED_SET = new Signature("setInterceptFieldCallback", Type.VOID_TYPE, new Type[]{CALLBACK});
    private static final Signature ENABLED_GET = new Signature("getInterceptFieldCallback", CALLBACK, new Type[0]);
    private InterceptFieldFilter filter;

    public InterceptFieldTransformer(InterceptFieldFilter interceptFieldFilter) {
        this.filter = interceptFieldFilter;
    }

    @Override
    public void begin_class(int n, int n2, String string, Type type, Type[] typeArray, String string2) {
        if (!TypeUtils.isInterface(n2)) {
            super.begin_class(n, n2, string, type, TypeUtils.add(typeArray, ENABLED), string2);
            super.declare_field(130, CALLBACK_FIELD, CALLBACK, null);
            CodeEmitter codeEmitter = super.begin_method(1, ENABLED_GET, null);
            codeEmitter.load_this();
            codeEmitter.getfield(CALLBACK_FIELD);
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = super.begin_method(1, ENABLED_SET, null);
            codeEmitter.load_this();
            codeEmitter.load_arg(0);
            codeEmitter.putfield(CALLBACK_FIELD);
            codeEmitter.return_value();
            codeEmitter.end_method();
        } else {
            super.begin_class(n, n2, string, type, typeArray, string2);
        }
    }

    @Override
    public void declare_field(int n, String string, Type type, Object object) {
        super.declare_field(n, string, type, object);
        if (!TypeUtils.isStatic(n)) {
            if (this.filter.acceptRead(this.getClassType(), string)) {
                this.addReadMethod(string, type);
            }
            if (this.filter.acceptWrite(this.getClassType(), string)) {
                this.addWriteMethod(string, type);
            }
        }
    }

    private void addReadMethod(String string, Type type) {
        CodeEmitter codeEmitter = super.begin_method(1, InterceptFieldTransformer.readMethodSig(string, type.getDescriptor()), null);
        codeEmitter.load_this();
        codeEmitter.getfield(string);
        codeEmitter.load_this();
        codeEmitter.invoke_interface(ENABLED, ENABLED_GET);
        Label label = codeEmitter.make_label();
        codeEmitter.ifnonnull(label);
        codeEmitter.return_value();
        codeEmitter.mark(label);
        Local local = codeEmitter.make_local(type);
        codeEmitter.store_local(local);
        codeEmitter.load_this();
        codeEmitter.invoke_interface(ENABLED, ENABLED_GET);
        codeEmitter.load_this();
        codeEmitter.push(string);
        codeEmitter.load_local(local);
        codeEmitter.invoke_interface(CALLBACK, InterceptFieldTransformer.readCallbackSig(type));
        if (!TypeUtils.isPrimitive(type)) {
            codeEmitter.checkcast(type);
        }
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    private void addWriteMethod(String string, Type type) {
        CodeEmitter codeEmitter = super.begin_method(1, InterceptFieldTransformer.writeMethodSig(string, type.getDescriptor()), null);
        codeEmitter.load_this();
        codeEmitter.dup();
        codeEmitter.invoke_interface(ENABLED, ENABLED_GET);
        Label label = codeEmitter.make_label();
        codeEmitter.ifnull(label);
        codeEmitter.load_this();
        codeEmitter.invoke_interface(ENABLED, ENABLED_GET);
        codeEmitter.load_this();
        codeEmitter.push(string);
        codeEmitter.load_this();
        codeEmitter.getfield(string);
        codeEmitter.load_arg(0);
        codeEmitter.invoke_interface(CALLBACK, InterceptFieldTransformer.writeCallbackSig(type));
        if (!TypeUtils.isPrimitive(type)) {
            codeEmitter.checkcast(type);
        }
        Label label2 = codeEmitter.make_label();
        codeEmitter.goTo(label2);
        codeEmitter.mark(label);
        codeEmitter.load_arg(0);
        codeEmitter.mark(label2);
        codeEmitter.putfield(string);
        codeEmitter.return_value();
        codeEmitter.end_method();
    }

    @Override
    public CodeEmitter begin_method(int n, Signature signature, Type[] typeArray) {
        return new CodeEmitter(super.begin_method(n, signature, typeArray)){

            @Override
            public void visitFieldInsn(int n, String string, String string2, String string3) {
                Type type = TypeUtils.fromInternalName(string);
                switch (n) {
                    case 180: {
                        if (!InterceptFieldTransformer.this.filter.acceptRead(type, string2)) break;
                        this.helper(type, InterceptFieldTransformer.readMethodSig(string2, string3));
                        return;
                    }
                    case 181: {
                        if (!InterceptFieldTransformer.this.filter.acceptWrite(type, string2)) break;
                        this.helper(type, InterceptFieldTransformer.writeMethodSig(string2, string3));
                        return;
                    }
                }
                super.visitFieldInsn(n, string, string2, string3);
            }

            private void helper(Type type, Signature signature) {
                this.invoke_virtual(type, signature);
            }
        };
    }

    private static Signature readMethodSig(String string, String string2) {
        return new Signature("$cglib_read_" + string, "()" + string2);
    }

    private static Signature writeMethodSig(String string, String string2) {
        return new Signature("$cglib_write_" + string, "(" + string2 + ")V");
    }

    private static Signature readCallbackSig(Type type) {
        Type type2 = InterceptFieldTransformer.remap(type);
        return new Signature("read" + InterceptFieldTransformer.callbackName(type2), type2, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_STRING, type2});
    }

    private static Signature writeCallbackSig(Type type) {
        Type type2 = InterceptFieldTransformer.remap(type);
        return new Signature("write" + InterceptFieldTransformer.callbackName(type2), type2, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_STRING, type2, type2});
    }

    private static Type remap(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return Constants.TYPE_OBJECT;
            }
        }
        return type;
    }

    private static String callbackName(Type type) {
        return type == Constants.TYPE_OBJECT ? "Object" : TypeUtils.upperFirst(TypeUtils.getClassName(type));
    }
}

