/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.springframework.asm.Attribute;
import org.springframework.asm.ClassReader;
import org.springframework.cglib.core.ClassNameReader;
import org.springframework.cglib.core.DebuggingClassWriter;
import org.springframework.cglib.transform.AbstractProcessTask;
import org.springframework.cglib.transform.ClassReaderGenerator;
import org.springframework.cglib.transform.ClassTransformer;
import org.springframework.cglib.transform.TransformingClassGenerator;

public abstract class AbstractTransformTask
extends AbstractProcessTask {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int CLASS_MAGIC = -889275714;
    private boolean verbose;

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    protected abstract ClassTransformer getClassTransformer(String[] var1);

    protected Attribute[] attributes() {
        return null;
    }

    @Override
    protected void processFile(File file) throws Exception {
        if (this.isClassFile(file)) {
            this.processClassFile(file);
        } else if (this.isJarFile(file)) {
            this.processJarFile(file);
        } else {
            this.log("ignoring " + file.toURI(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassFile(File file) throws Exception, FileNotFoundException, IOException, MalformedURLException {
        ClassReader classReader = AbstractTransformTask.getClassReader(file);
        String[] stringArray = ClassNameReader.getClassInfo(classReader);
        DebuggingClassWriter debuggingClassWriter = new DebuggingClassWriter(2);
        ClassTransformer classTransformer = this.getClassTransformer(stringArray);
        if (classTransformer != null) {
            if (this.verbose) {
                this.log("processing " + file.toURI());
            }
            new TransformingClassGenerator(new ClassReaderGenerator(AbstractTransformTask.getClassReader(file), this.attributes(), this.getFlags()), classTransformer).generateClass(debuggingClassWriter);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(debuggingClassWriter.toByteArray());
            }
        }
    }

    protected int getFlags() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassReader getClassReader(File file) throws Exception {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            ClassReader classReader;
            ClassReader classReader2 = classReader = new ClassReader(bufferedInputStream);
            return classReader2;
        }
    }

    protected boolean isClassFile(File file) throws IOException {
        return this.checkMagic(file, -889275714L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarFile(File file) throws Exception {
        block19: {
            if (this.verbose) {
                this.log("processing " + file.toURI());
            }
            File file2 = File.createTempFile(file.getName(), null, new File(file.getAbsoluteFile().getParent()));
            try {
                Object object;
                try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));){
                    object = new FileOutputStream(file2);
                    try {
                        ZipEntry zipEntry;
                        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object);
                        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                            Object object2;
                            byte[] byArray = this.getBytes(zipInputStream);
                            if (!zipEntry.isDirectory()) {
                                object2 = new DataInputStream(new ByteArrayInputStream(byArray));
                                if (((DataInputStream)object2).readInt() == -889275714) {
                                    byArray = this.process(byArray);
                                } else if (this.verbose) {
                                    this.log("ignoring " + zipEntry.toString());
                                }
                            }
                            object2 = new ZipEntry(zipEntry.getName());
                            ((ZipEntry)object2).setMethod(zipEntry.getMethod());
                            ((ZipEntry)object2).setComment(zipEntry.getComment());
                            ((ZipEntry)object2).setSize(byArray.length);
                            if (((ZipEntry)object2).getMethod() == 0) {
                                CRC32 cRC32 = new CRC32();
                                cRC32.update(byArray);
                                ((ZipEntry)object2).setCrc(cRC32.getValue());
                                ((ZipEntry)object2).setCompressedSize(byArray.length);
                            }
                            zipOutputStream.putNextEntry((ZipEntry)object2);
                            zipOutputStream.write(byArray);
                            zipOutputStream.closeEntry();
                            zipInputStream.closeEntry();
                        }
                        zipOutputStream.close();
                    }
                    finally {
                        ((FileOutputStream)object).close();
                    }
                }
                if (file.delete()) {
                    object = new File(file2.getAbsolutePath());
                    if (!((File)object).renameTo(file)) {
                        throw new IOException("can not rename " + file2 + " to " + file);
                    }
                    break block19;
                }
                throw new IOException("can not delete " + file);
            }
            finally {
                file2.delete();
            }
        }
    }

    private byte[] process(byte[] byArray) throws Exception {
        ClassReader classReader = new ClassReader(new ByteArrayInputStream(byArray));
        String[] stringArray = ClassNameReader.getClassInfo(classReader);
        DebuggingClassWriter debuggingClassWriter = new DebuggingClassWriter(2);
        ClassTransformer classTransformer = this.getClassTransformer(stringArray);
        if (classTransformer != null) {
            if (this.verbose) {
                this.log("processing " + stringArray[0]);
            }
            new TransformingClassGenerator(new ClassReaderGenerator(new ClassReader(new ByteArrayInputStream(byArray)), this.attributes(), this.getFlags()), classTransformer).generateClass(debuggingClassWriter);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(debuggingClassWriter.toByteArray());
            return byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private byte[] getBytes(ZipInputStream zipInputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMagic(File file, long l) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            int n = dataInputStream.readInt();
            boolean bl = l == (long)n;
            return bl;
        }
    }

    protected boolean isJarFile(File file) throws IOException {
        return this.checkMagic(file, 1347093252L);
    }
}

