/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.util.List;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.proxy.CallbackGenerator;

class DispatcherGenerator
implements CallbackGenerator {
    public static final DispatcherGenerator INSTANCE = new DispatcherGenerator(false);
    public static final DispatcherGenerator PROXY_REF_INSTANCE = new DispatcherGenerator(true);
    private static final Type DISPATCHER = TypeUtils.parseType("org.springframework.cglib.proxy.Dispatcher");
    private static final Type PROXY_REF_DISPATCHER = TypeUtils.parseType("org.springframework.cglib.proxy.ProxyRefDispatcher");
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Signature PROXY_REF_LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject(Object)");
    private boolean proxyRef;

    private DispatcherGenerator(boolean bl) {
        this.proxyRef = bl;
    }

    @Override
    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context, List list) {
        for (MethodInfo methodInfo : list) {
            if (TypeUtils.isProtected(methodInfo.getModifiers())) continue;
            CodeEmitter codeEmitter = context.beginMethod(classEmitter, methodInfo);
            context.emitCallback(codeEmitter, context.getIndex(methodInfo));
            if (this.proxyRef) {
                codeEmitter.load_this();
                codeEmitter.invoke_interface(PROXY_REF_DISPATCHER, PROXY_REF_LOAD_OBJECT);
            } else {
                codeEmitter.invoke_interface(DISPATCHER, LOAD_OBJECT);
            }
            codeEmitter.checkcast(methodInfo.getClassInfo().getType());
            codeEmitter.load_args();
            codeEmitter.invoke(methodInfo);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
    }

    @Override
    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context, List list) {
    }
}

