/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.Signature;

class BridgeMethodResolver {
    private final Map declToBridge;
    private final ClassLoader classLoader;

    public BridgeMethodResolver(Map map, ClassLoader classLoader) {
        this.declToBridge = map;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map resolveAll() {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : this.declToBridge.entrySet()) {
            Class clazz = (Class)entry.getKey();
            Set set = (Set)entry.getValue();
            try {
                InputStream inputStream2 = this.classLoader.getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
                if (inputStream2 == null) {
                    return hashMap;
                }
                try {
                    new ClassReader(inputStream2).accept(new BridgedFinder(set, hashMap), 6);
                }
                finally {
                    inputStream2.close();
                }
            }
            catch (IOException iOException) {}
        }
        return hashMap;
    }

    private static class BridgedFinder
    extends ClassVisitor {
        private Map resolved;
        private Set eligibleMethods;
        private Signature currentMethod = null;

        BridgedFinder(Set set, Map map) {
            super(Constants.ASM_API);
            this.resolved = map;
            this.eligibleMethods = set;
        }

        @Override
        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            Signature signature = new Signature(string, string2);
            if (this.eligibleMethods.remove(signature)) {
                this.currentMethod = signature;
                return new MethodVisitor(Constants.ASM_API){

                    @Override
                    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
                        if ((n == 183 || bl && n == 185) && currentMethod != null) {
                            Signature signature = new Signature(string2, string3);
                            if (!signature.equals(currentMethod)) {
                                resolved.put(currentMethod, signature);
                            }
                            currentMethod = null;
                        }
                    }
                };
            }
            return null;
        }
    }
}

