/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.asm.Attribute;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassInfo;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

public class ReflectUtils {
    private static final Map primitives;
    private static final Map transforms;
    private static final ClassLoader defaultLoader;
    private static final Method privateLookupInMethod;
    private static final Method lookupDefineClassMethod;
    private static final Method classLoaderDefineClassMethod;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final Throwable THROWABLE;
    private static final List<Method> OBJECT_METHODS;
    private static final String[] CGLIB_PACKAGES;

    private ReflectUtils() {
    }

    public static ProtectionDomain getProtectionDomain(final Class clazz) {
        if (clazz == null) {
            return null;
        }
        return (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getProtectionDomain();
            }
        });
    }

    public static Type[] getExceptionTypes(Member member) {
        if (member instanceof Method) {
            return TypeUtils.getTypes(((Method)member).getExceptionTypes());
        }
        if (member instanceof Constructor) {
            return TypeUtils.getTypes(((Constructor)member).getExceptionTypes());
        }
        throw new IllegalArgumentException("Cannot get exception types of a field");
    }

    public static Signature getSignature(Member member) {
        if (member instanceof Method) {
            return new Signature(member.getName(), Type.getMethodDescriptor((Method)member));
        }
        if (member instanceof Constructor) {
            Type[] typeArray = TypeUtils.getTypes(((Constructor)member).getParameterTypes());
            return new Signature("<init>", Type.getMethodDescriptor(Type.VOID_TYPE, typeArray));
        }
        throw new IllegalArgumentException("Cannot get signature of a field");
    }

    public static Constructor findConstructor(String string) {
        return ReflectUtils.findConstructor(string, defaultLoader);
    }

    public static Constructor findConstructor(String string, ClassLoader classLoader) {
        try {
            int n = string.indexOf(40);
            String string2 = string.substring(0, n).trim();
            return ReflectUtils.getClass(string2, classLoader).getConstructor(ReflectUtils.parseTypes(string, classLoader));
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            throw new CodeGenerationException(reflectiveOperationException);
        }
    }

    public static Method findMethod(String string) {
        return ReflectUtils.findMethod(string, defaultLoader);
    }

    public static Method findMethod(String string, ClassLoader classLoader) {
        try {
            int n = string.indexOf(40);
            int n2 = string.lastIndexOf(46, n);
            String string2 = string.substring(0, n2).trim();
            String string3 = string.substring(n2 + 1, n).trim();
            return ReflectUtils.getClass(string2, classLoader).getDeclaredMethod(string3, ReflectUtils.parseTypes(string, classLoader));
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            throw new CodeGenerationException(reflectiveOperationException);
        }
    }

    private static Class[] parseTypes(String string, ClassLoader classLoader) throws ClassNotFoundException {
        int n;
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41, n2);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = n2 + 1;
        while ((n = string.indexOf(44, n4)) >= 0) {
            arrayList.add(string.substring(n4, n).trim());
            n4 = n + 1;
        }
        if (n4 < n3) {
            arrayList.add(string.substring(n4, n3).trim());
        }
        Class[] classArray = new Class[arrayList.size()];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = ReflectUtils.getClass((String)arrayList.get(i), classLoader);
        }
        return classArray;
    }

    private static Class getClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return ReflectUtils.getClass(string, classLoader, CGLIB_PACKAGES);
    }

    private static Class getClass(String string, ClassLoader classLoader, String[] stringArray) throws ClassNotFoundException {
        String string2 = string;
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("[]", n2) + 1) > 0) {
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() - n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('[');
        }
        string = string.substring(0, string.length() - 2 * n);
        String string3 = n > 0 ? stringBuffer + "L" : "";
        String string4 = n > 0 ? ";" : "";
        try {
            return Class.forName(string3 + string + string4, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    return Class.forName(string3 + stringArray[i] + '.' + string + string4, false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    continue;
                }
            }
            if (n == 0) {
                Class clazz = (Class)primitives.get(string);
                if (clazz != null) {
                    return clazz;
                }
            } else {
                String string5 = (String)transforms.get(string);
                if (string5 != null) {
                    try {
                        return Class.forName(stringBuffer + string5, false, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        // empty catch block
                    }
                }
            }
            throw new ClassNotFoundException(string2);
        }
    }

    public static Object newInstance(Class clazz) {
        return ReflectUtils.newInstance(clazz, Constants.EMPTY_CLASS_ARRAY, null);
    }

    public static Object newInstance(Class clazz, Class[] classArray, Object[] objectArray) {
        return ReflectUtils.newInstance(ReflectUtils.getConstructor(clazz, classArray), objectArray);
    }

    public static Object newInstance(Constructor constructor, Object[] objectArray) {
        boolean bl = constructor.isAccessible();
        try {
            Object t2;
            if (!bl) {
                constructor.setAccessible(true);
            }
            Object t3 = t2 = constructor.newInstance(objectArray);
            return t3;
        }
        catch (InstantiationException instantiationException) {
            throw new CodeGenerationException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CodeGenerationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CodeGenerationException(invocationTargetException.getTargetException());
        }
        finally {
            if (!bl) {
                constructor.setAccessible(bl);
            }
        }
    }

    public static Constructor getConstructor(Class clazz, Class[] classArray) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(() -> {
                    constructor.setAccessible(true);
                    return null;
                });
            } else {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CodeGenerationException(noSuchMethodException);
        }
    }

    public static String[] getNames(Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    public static Class[] getClasses(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return classArray;
    }

    public static Method findNewInstance(Class clazz) {
        Method method = ReflectUtils.findInterfaceMethod(clazz);
        if (!method.getName().equals("newInstance")) {
            throw new IllegalArgumentException(clazz + " missing newInstance method");
        }
        return method;
    }

    public static Method[] getPropertyMethods(PropertyDescriptor[] propertyDescriptorArray, boolean bl, boolean bl2) {
        HashSet<Method> hashSet = new HashSet<Method>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (bl) {
                hashSet.add(propertyDescriptor.getReadMethod());
            }
            if (!bl2) continue;
            hashSet.add(propertyDescriptor.getWriteMethod());
        }
        hashSet.remove(null);
        return hashSet.toArray(new Method[hashSet.size()]);
    }

    public static PropertyDescriptor[] getBeanProperties(Class clazz) {
        return ReflectUtils.getPropertiesHelper(clazz, true, true);
    }

    public static PropertyDescriptor[] getBeanGetters(Class clazz) {
        return ReflectUtils.getPropertiesHelper(clazz, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class clazz) {
        return ReflectUtils.getPropertiesHelper(clazz, false, true);
    }

    private static PropertyDescriptor[] getPropertiesHelper(Class clazz, boolean bl, boolean bl2) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (bl && bl2) {
                return propertyDescriptorArray;
            }
            ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>(propertyDescriptorArray.length);
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if ((!bl || propertyDescriptor.getReadMethod() == null) && (!bl2 || propertyDescriptor.getWriteMethod() == null)) continue;
                arrayList.add(propertyDescriptor);
            }
            return arrayList.toArray(new PropertyDescriptor[arrayList.size()]);
        }
        catch (IntrospectionException introspectionException) {
            throw new CodeGenerationException(introspectionException);
        }
    }

    public static Method findDeclaredMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                return clazz2.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        throw new NoSuchMethodException(string);
    }

    public static List addAllMethods(Class clazz, List list) {
        if (clazz == Object.class) {
            list.addAll(OBJECT_METHODS);
        } else {
            list.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            ReflectUtils.addAllMethods(clazz2, list);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            ReflectUtils.addAllMethods(classArray[i], list);
        }
        return list;
    }

    public static List addAllInterfaces(Class clazz, List list) {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            list.addAll(Arrays.asList(clazz.getInterfaces()));
            ReflectUtils.addAllInterfaces(clazz2, list);
        }
        return list;
    }

    public static Method findInterfaceMethod(Class clazz) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException(clazz + " is not an interface");
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray.length != 1) {
            throw new IllegalArgumentException("expecting exactly 1 method in " + clazz);
        }
        return methodArray[0];
    }

    public static Class defineClass(String string, byte[] byArray, ClassLoader classLoader) throws Exception {
        return ReflectUtils.defineClass(string, byArray, classLoader, null, null);
    }

    public static Class defineClass(String string, byte[] byArray, ClassLoader classLoader, ProtectionDomain protectionDomain) throws Exception {
        return ReflectUtils.defineClass(string, byArray, classLoader, protectionDomain, null);
    }

    public static Class defineClass(String string, byte[] byArray, ClassLoader classLoader, ProtectionDomain protectionDomain, Class<?> clazz) throws Exception {
        Object[] objectArray;
        Class clazz2 = null;
        Throwable throwable = THROWABLE;
        if (clazz != null && clazz.getClassLoader() == classLoader && privateLookupInMethod != null && lookupDefineClassMethod != null) {
            try {
                objectArray = (Object[])privateLookupInMethod.invoke(null, clazz, MethodHandles.lookup());
                clazz2 = (Class)lookupDefineClassMethod.invoke((Object)objectArray, new Object[]{byArray});
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable2 = invocationTargetException.getTargetException();
                if (throwable2.getClass() != LinkageError.class && throwable2.getClass() != IllegalArgumentException.class) {
                    throw new CodeGenerationException(throwable2);
                }
                throwable = throwable2;
            }
            catch (Throwable throwable3) {
                throw new CodeGenerationException(throwable3);
            }
        }
        if (clazz2 == null && classLoaderDefineClassMethod != null) {
            if (protectionDomain == null) {
                protectionDomain = PROTECTION_DOMAIN;
            }
            objectArray = new Object[]{string, byArray, 0, byArray.length, protectionDomain};
            try {
                if (!classLoaderDefineClassMethod.isAccessible()) {
                    classLoaderDefineClassMethod.setAccessible(true);
                }
                clazz2 = (Class)classLoaderDefineClassMethod.invoke((Object)classLoader, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new CodeGenerationException(invocationTargetException.getTargetException());
            }
            catch (Throwable throwable4) {
                if (!throwable4.getClass().getName().endsWith("InaccessibleObjectException")) {
                    throw new CodeGenerationException(throwable4);
                }
                throwable = throwable4;
            }
        }
        if (clazz2 == null && clazz != null && clazz.getClassLoader() != classLoader && privateLookupInMethod != null && lookupDefineClassMethod != null) {
            try {
                objectArray = (MethodHandles.Lookup)privateLookupInMethod.invoke(null, clazz, MethodHandles.lookup());
                clazz2 = (Class)lookupDefineClassMethod.invoke((Object)objectArray, new Object[]{byArray});
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new CodeGenerationException(invocationTargetException.getTargetException());
            }
            catch (Throwable throwable5) {
                throw new CodeGenerationException(throwable5);
            }
        }
        if (clazz2 == null) {
            throw new CodeGenerationException(throwable);
        }
        Class.forName(string, true, classLoader);
        return clazz2;
    }

    public static int findPackageProtected(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (Modifier.isPublic(classArray[i].getModifiers())) continue;
            return i;
        }
        return 0;
    }

    public static MethodInfo getMethodInfo(final Member member, final int n) {
        final Signature signature = ReflectUtils.getSignature(member);
        return new MethodInfo(){
            private ClassInfo ci;

            @Override
            public ClassInfo getClassInfo() {
                if (this.ci == null) {
                    this.ci = ReflectUtils.getClassInfo(member.getDeclaringClass());
                }
                return this.ci;
            }

            @Override
            public int getModifiers() {
                return n;
            }

            @Override
            public Signature getSignature() {
                return signature;
            }

            @Override
            public Type[] getExceptionTypes() {
                return ReflectUtils.getExceptionTypes(member);
            }

            public Attribute getAttribute() {
                return null;
            }
        };
    }

    public static MethodInfo getMethodInfo(Member member) {
        return ReflectUtils.getMethodInfo(member, member.getModifiers());
    }

    public static ClassInfo getClassInfo(final Class clazz) {
        final Type type = Type.getType(clazz);
        final Type type2 = clazz.getSuperclass() == null ? null : Type.getType(clazz.getSuperclass());
        return new ClassInfo(){

            @Override
            public Type getType() {
                return type;
            }

            @Override
            public Type getSuperType() {
                return type2;
            }

            @Override
            public Type[] getInterfaces() {
                return TypeUtils.getTypes(clazz.getInterfaces());
            }

            @Override
            public int getModifiers() {
                return clazz.getModifiers();
            }
        };
    }

    public static Method[] findMethods(String[] stringArray, Method[] methodArray) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            hashMap.put(method.getName() + Type.getMethodDescriptor(method), method);
        }
        Method[] methodArray2 = new Method[stringArray.length / 2];
        for (int i = 0; i < methodArray2.length; ++i) {
            methodArray2[i] = (Method)hashMap.get(stringArray[i * 2] + stringArray[i * 2 + 1]);
            if (methodArray2[i] != null) continue;
        }
        return methodArray2;
    }

    static {
        ProtectionDomain protectionDomain;
        Method method;
        Method method2;
        Method method3;
        primitives = new HashMap(8);
        transforms = new HashMap(8);
        defaultLoader = ReflectUtils.class.getClassLoader();
        OBJECT_METHODS = new ArrayList<Method>();
        Throwable throwable = null;
        try {
            method3 = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return null;
                    }
                }
            });
            method2 = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return MethodHandles.Lookup.class.getMethod("defineClass", byte[].class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return null;
                    }
                }
            });
            method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                }
            });
            protectionDomain = ReflectUtils.getProtectionDomain(ReflectUtils.class);
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Method[] methodArray;
                    for (Method method : methodArray = Object.class.getDeclaredMethods()) {
                        if ("finalize".equals(method.getName()) || (method.getModifiers() & 0x18) > 0) continue;
                        OBJECT_METHODS.add(method);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable2) {
            method3 = null;
            method2 = null;
            method = null;
            protectionDomain = null;
            throwable = throwable2;
        }
        privateLookupInMethod = method3;
        lookupDefineClassMethod = method2;
        classLoaderDefineClassMethod = method;
        PROTECTION_DOMAIN = protectionDomain;
        THROWABLE = throwable;
        CGLIB_PACKAGES = new String[]{"java.lang"};
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
    }
}

