/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

public class ImmutableBean {
    private static final Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType("IllegalStateException");
    private static final Signature CSTRUCT_OBJECT = TypeUtils.parseConstructor("Object");
    private static final Class[] OBJECT_CLASSES = new Class[]{Object.class};
    private static final String FIELD_NAME = "CGLIB$RWBean";

    private ImmutableBean() {
    }

    public static Object create(Object object) {
        Generator generator = new Generator();
        generator.setBean(object);
        return generator.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(ImmutableBean.class.getName());
        private Object bean;
        private Class target;

        public Generator() {
            super(SOURCE);
        }

        public void setBean(Object object) {
            this.bean = object;
            this.target = object.getClass();
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.target.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain(this.target);
        }

        public Object create() {
            String string = this.target.getName();
            this.setNamePrefix(string);
            return super.create(string);
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) {
            MethodInfo methodInfo;
            int n;
            Type type = Type.getType(this.target);
            ClassEmitter classEmitter = new ClassEmitter(classVisitor);
            classEmitter.begin_class(52, 1, this.getClassName(), type, null, "<generated>");
            classEmitter.declare_field(18, ImmutableBean.FIELD_NAME, type, null);
            CodeEmitter codeEmitter = classEmitter.begin_method(1, CSTRUCT_OBJECT, null);
            codeEmitter.load_this();
            codeEmitter.super_invoke_constructor();
            codeEmitter.load_this();
            codeEmitter.load_arg(0);
            codeEmitter.checkcast(type);
            codeEmitter.putfield(ImmutableBean.FIELD_NAME);
            codeEmitter.return_value();
            codeEmitter.end_method();
            PropertyDescriptor[] propertyDescriptorArray = ReflectUtils.getBeanProperties(this.target);
            Method[] methodArray = ReflectUtils.getPropertyMethods(propertyDescriptorArray, true, false);
            Method[] methodArray2 = ReflectUtils.getPropertyMethods(propertyDescriptorArray, false, true);
            for (n = 0; n < methodArray.length; ++n) {
                methodInfo = ReflectUtils.getMethodInfo(methodArray[n]);
                codeEmitter = EmitUtils.begin_method(classEmitter, methodInfo, 1);
                codeEmitter.load_this();
                codeEmitter.getfield(ImmutableBean.FIELD_NAME);
                codeEmitter.invoke(methodInfo);
                codeEmitter.return_value();
                codeEmitter.end_method();
            }
            for (n = 0; n < methodArray2.length; ++n) {
                methodInfo = ReflectUtils.getMethodInfo(methodArray2[n]);
                codeEmitter = EmitUtils.begin_method(classEmitter, methodInfo, 1);
                codeEmitter.throw_exception(ILLEGAL_STATE_EXCEPTION, "Bean is immutable");
                codeEmitter.end_method();
            }
            classEmitter.end_class();
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return ReflectUtils.newInstance(clazz, OBJECT_CLASSES, new Object[]{this.bean});
        }

        @Override
        protected Object nextInstance(Object object) {
            return this.firstInstance(object.getClass());
        }
    }
}

