/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.asm;

import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Attribute;
import org.springframework.asm.FieldVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.ModuleVisitor;
import org.springframework.asm.RecordComponentVisitor;
import org.springframework.asm.TypePath;

public abstract class ClassVisitor {
    protected final int api;
    protected ClassVisitor cv;

    public ClassVisitor(int n) {
        this(n, null);
    }

    public ClassVisitor(int n, ClassVisitor classVisitor) {
        if (n != 458752 && n != 393216 && n != 327680 && n != 262144 && n != 0x1080000) {
            throw new IllegalArgumentException("Unsupported api " + n);
        }
        this.api = n;
        this.cv = classVisitor;
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        if (this.cv != null) {
            this.cv.visit(n, n2, string, string2, string3, stringArray);
        }
    }

    public void visitSource(String string, String string2) {
        if (this.cv != null) {
            this.cv.visitSource(string, string2);
        }
    }

    public ModuleVisitor visitModule(String string, int n, String string2) {
        if (this.api < 393216) {
            throw new UnsupportedOperationException("This feature requires ASM6");
        }
        if (this.cv != null) {
            return this.cv.visitModule(string, n, string2);
        }
        return null;
    }

    public void visitNestHost(String string) {
        if (this.api < 458752) {
            throw new UnsupportedOperationException("This feature requires ASM7");
        }
        if (this.cv != null) {
            this.cv.visitNestHost(string);
        }
    }

    public void visitOuterClass(String string, String string2, String string3) {
        if (this.cv != null) {
            this.cv.visitOuterClass(string, string2, string3);
        }
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (this.cv != null) {
            return this.cv.visitAnnotation(string, bl);
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException("This feature requires ASM5");
        }
        if (this.cv != null) {
            return this.cv.visitTypeAnnotation(n, typePath, string, bl);
        }
        return null;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.cv != null) {
            this.cv.visitAttribute(attribute);
        }
    }

    public void visitNestMember(String string) {
        if (this.api < 458752) {
            throw new UnsupportedOperationException("This feature requires ASM7");
        }
        if (this.cv != null) {
            this.cv.visitNestMember(string);
        }
    }

    @Deprecated
    public void visitPermittedSubtypeExperimental(String string) {
        if (this.api != 0x1080000) {
            throw new UnsupportedOperationException("This feature requires ASM8_EXPERIMENTAL");
        }
        if (this.cv != null) {
            this.cv.visitPermittedSubtypeExperimental(string);
        }
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        if (this.cv != null) {
            this.cv.visitInnerClass(string, string2, string3, n);
        }
    }

    @Deprecated
    public RecordComponentVisitor visitRecordComponentExperimental(int n, String string, String string2, String string3) {
        if (this.api < 0x1080000) {
            throw new UnsupportedOperationException("This feature requires ASM8_EXPERIMENTAL");
        }
        if (this.cv != null) {
            return this.cv.visitRecordComponentExperimental(n, string, string2, string3);
        }
        return null;
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        if (this.cv != null) {
            return this.cv.visitField(n, string, string2, string3, object);
        }
        return null;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if (this.cv != null) {
            return this.cv.visitMethod(n, string, string2, string3, stringArray);
        }
        return null;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }
}

