/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter.qual;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public enum ConversionCategory {
    GENERAL("bBhHsS", null),
    CHAR("cC", Character.class, Byte.class, Short.class, Integer.class),
    INT("doxX", Byte.class, Short.class, Integer.class, Long.class, BigInteger.class),
    FLOAT("eEfgGaA", Float.class, Double.class, BigDecimal.class),
    TIME("tT", Long.class, Calendar.class, Date.class),
    CHAR_AND_INT(null, Byte.class, Short.class, Integer.class),
    INT_AND_TIME(null, Long.class),
    NULL(null, new Class[0]),
    UNUSED(null, null);

    public final Class<?> @Nullable [] types;
    public final @Nullable String chars;
    private static final ConversionCategory[] conversionCategoriesWithChar;
    private static final ConversionCategory[] conversionCategoriesForIntersect;
    private static final ConversionCategory[] conversionCategoriesForUnion;

    private ConversionCategory(String string2, Class<?> ... classArray) {
        this.chars = string2;
        if (classArray == null) {
            this.types = classArray;
        } else {
            ArrayList arrayList = new ArrayList(classArray.length);
            for (Class<?> clazz : classArray) {
                arrayList.add(clazz);
                Class<? extends Object> clazz2 = ConversionCategory.unwrapPrimitive(clazz);
                if (clazz2 == null) continue;
                arrayList.add(clazz2);
            }
            this.types = arrayList.toArray(new Class[arrayList.size()]);
        }
    }

    private static @Nullable Class<? extends Object> unwrapPrimitive(Class<?> clazz) {
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        return null;
    }

    public static ConversionCategory fromConversionChar(char c) {
        for (ConversionCategory conversionCategory : conversionCategoriesWithChar) {
            if (!conversionCategory.chars.contains(String.valueOf(c))) continue;
            return conversionCategory;
        }
        throw new IllegalArgumentException("Bad conversion character " + c);
    }

    private static <E> Set<E> arrayToSet(E[] EArray) {
        return new HashSet<E>(Arrays.asList(EArray));
    }

    public static boolean isSubsetOf(ConversionCategory conversionCategory, ConversionCategory conversionCategory2) {
        return ConversionCategory.intersect(conversionCategory, conversionCategory2) == conversionCategory;
    }

    public static ConversionCategory intersect(ConversionCategory conversionCategory, ConversionCategory conversionCategory2) {
        if (conversionCategory == UNUSED) {
            return conversionCategory2;
        }
        if (conversionCategory2 == UNUSED) {
            return conversionCategory;
        }
        if (conversionCategory == GENERAL) {
            return conversionCategory2;
        }
        if (conversionCategory2 == GENERAL) {
            return conversionCategory;
        }
        Set<Class<Class<?>>> set = ConversionCategory.arrayToSet(conversionCategory.types);
        Set<Class<?>> set2 = ConversionCategory.arrayToSet(conversionCategory2.types);
        set.retainAll(set2);
        for (ConversionCategory conversionCategory3 : conversionCategoriesForIntersect) {
            Set<Class<?>> set3 = ConversionCategory.arrayToSet(conversionCategory3.types);
            if (!set3.equals(set)) continue;
            return conversionCategory3;
        }
        throw new RuntimeException();
    }

    public static ConversionCategory union(ConversionCategory conversionCategory, ConversionCategory conversionCategory2) {
        if (conversionCategory == UNUSED || conversionCategory2 == UNUSED) {
            return UNUSED;
        }
        if (conversionCategory == GENERAL || conversionCategory2 == GENERAL) {
            return GENERAL;
        }
        if (conversionCategory == CHAR_AND_INT && conversionCategory2 == INT_AND_TIME || conversionCategory == INT_AND_TIME && conversionCategory2 == CHAR_AND_INT) {
            return INT;
        }
        Set<Class<?>> set = ConversionCategory.arrayToSet(conversionCategory.types);
        Set<Class<?>> set2 = ConversionCategory.arrayToSet(conversionCategory2.types);
        set.addAll(set2);
        for (ConversionCategory conversionCategory3 : conversionCategoriesForUnion) {
            Set<Class<?>> set3 = ConversionCategory.arrayToSet(conversionCategory3.types);
            if (!set3.equals(set)) continue;
            return conversionCategory3;
        }
        return GENERAL;
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        if (this.types == null) {
            return true;
        }
        if (clazz == Void.TYPE) {
            return true;
        }
        for (Class<?> clazz2 : this.types) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Pure
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name());
        stringBuilder.append(" conversion category");
        if (this.types == null || this.types.length == 0) {
            return stringBuilder.toString();
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "(one of: ", ")");
        for (Class<?> clazz : this.types) {
            stringJoiner.add(clazz.getSimpleName());
        }
        stringBuilder.append(" ");
        stringBuilder.append(stringJoiner);
        return stringBuilder.toString();
    }

    static {
        conversionCategoriesWithChar = new ConversionCategory[]{GENERAL, CHAR, INT, FLOAT, TIME};
        conversionCategoriesForIntersect = new ConversionCategory[]{CHAR, INT, FLOAT, TIME, CHAR_AND_INT, INT_AND_TIME, NULL};
        conversionCategoriesForUnion = new ConversionCategory[]{NULL, CHAR_AND_INT, INT_AND_TIME, CHAR, INT, FLOAT, TIME};
    }
}

