/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.KeccakDigest;

public class SHA3Digest
extends KeccakDigest {
    private static int checkBitLength(int n) {
        switch (n) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                return n;
            }
        }
        int n2 = n;
        throw new IllegalArgumentException(new StringBuilder(52).append("'bitLength' ").append((Object)n2).append(" not supported for SHA-3").toString());
    }

    public SHA3Digest() {
        this(256);
    }

    public SHA3Digest(int n) {
        super(SHA3Digest.checkBitLength(n));
    }

    public SHA3Digest(SHA3Digest sHA3Digest) {
        super(sHA3Digest);
    }

    @Override
    public String getAlgorithmName() {
        int n = this.fixedOutputLength;
        return new StringBuilder(21).append("SHA3-").append((Object)n).toString();
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.absorbBits(2, 2);
        return super.doFinal(byArray, n);
    }

    @Override
    protected int doFinal(byte[] byArray, int n, byte by, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int n3 = by & (1 << n2) - 1 | 2 << n2;
        int n4 = n2 + 2;
        if (n4 >= 8) {
            this.absorb((byte)n3);
            n4 -= 8;
            n3 >>>= 8;
        }
        return super.doFinal(byArray, n, (byte)n3, n4);
    }
}

