/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.MinimalField;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.util.Args;
import org.apache.http.util.ByteArrayBuffer;

abstract class AbstractMultipartForm {
    private static final ByteArrayBuffer FIELD_SEP = AbstractMultipartForm.encode(MIME.DEFAULT_CHARSET, ": ");
    private static final ByteArrayBuffer CR_LF = AbstractMultipartForm.encode(MIME.DEFAULT_CHARSET, "\r\n");
    private static final ByteArrayBuffer TWO_DASHES = AbstractMultipartForm.encode(MIME.DEFAULT_CHARSET, "--");
    final Charset charset;
    final String boundary;

    private static ByteArrayBuffer encode(Charset charset, String string) {
        ByteBuffer byteBuffer = charset.encode(CharBuffer.wrap(string));
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(byteBuffer.remaining());
        byteArrayBuffer.append(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
        return byteArrayBuffer;
    }

    private static void writeBytes(ByteArrayBuffer byteArrayBuffer, OutputStream outputStream2) throws IOException {
        outputStream2.write(byteArrayBuffer.buffer(), 0, byteArrayBuffer.length());
    }

    private static void writeBytes(String string, Charset charset, OutputStream outputStream2) throws IOException {
        ByteArrayBuffer byteArrayBuffer = AbstractMultipartForm.encode(charset, string);
        AbstractMultipartForm.writeBytes(byteArrayBuffer, outputStream2);
    }

    private static void writeBytes(String string, OutputStream outputStream2) throws IOException {
        ByteArrayBuffer byteArrayBuffer = AbstractMultipartForm.encode(MIME.DEFAULT_CHARSET, string);
        AbstractMultipartForm.writeBytes(byteArrayBuffer, outputStream2);
    }

    protected static void writeField(MinimalField minimalField, OutputStream outputStream2) throws IOException {
        AbstractMultipartForm.writeBytes(minimalField.getName(), outputStream2);
        AbstractMultipartForm.writeBytes(FIELD_SEP, outputStream2);
        AbstractMultipartForm.writeBytes(minimalField.getBody(), outputStream2);
        AbstractMultipartForm.writeBytes(CR_LF, outputStream2);
    }

    protected static void writeField(MinimalField minimalField, Charset charset, OutputStream outputStream2) throws IOException {
        AbstractMultipartForm.writeBytes(minimalField.getName(), charset, outputStream2);
        AbstractMultipartForm.writeBytes(FIELD_SEP, outputStream2);
        AbstractMultipartForm.writeBytes(minimalField.getBody(), charset, outputStream2);
        AbstractMultipartForm.writeBytes(CR_LF, outputStream2);
    }

    public AbstractMultipartForm(Charset charset, String string) {
        Args.notNull(string, "Multipart boundary");
        this.charset = charset != null ? charset : MIME.DEFAULT_CHARSET;
        this.boundary = string;
    }

    public AbstractMultipartForm(String string) {
        this(null, string);
    }

    public abstract List<FormBodyPart> getBodyParts();

    void doWriteTo(OutputStream outputStream2, boolean bl) throws IOException {
        ByteArrayBuffer byteArrayBuffer = AbstractMultipartForm.encode(this.charset, this.boundary);
        for (FormBodyPart formBodyPart : this.getBodyParts()) {
            AbstractMultipartForm.writeBytes(TWO_DASHES, outputStream2);
            AbstractMultipartForm.writeBytes(byteArrayBuffer, outputStream2);
            AbstractMultipartForm.writeBytes(CR_LF, outputStream2);
            this.formatMultipartHeader(formBodyPart, outputStream2);
            AbstractMultipartForm.writeBytes(CR_LF, outputStream2);
            if (bl) {
                formBodyPart.getBody().writeTo(outputStream2);
            }
            AbstractMultipartForm.writeBytes(CR_LF, outputStream2);
        }
        AbstractMultipartForm.writeBytes(TWO_DASHES, outputStream2);
        AbstractMultipartForm.writeBytes(byteArrayBuffer, outputStream2);
        AbstractMultipartForm.writeBytes(TWO_DASHES, outputStream2);
        AbstractMultipartForm.writeBytes(CR_LF, outputStream2);
    }

    protected abstract void formatMultipartHeader(FormBodyPart var1, OutputStream var2) throws IOException;

    public void writeTo(OutputStream outputStream2) throws IOException {
        this.doWriteTo(outputStream2, true);
    }

    public long getTotalLength() {
        long l = 0L;
        for (FormBodyPart object : this.getBodyParts()) {
            ContentBody contentBody = object.getBody();
            long l2 = contentBody.getContentLength();
            if (l2 >= 0L) {
                l += l2;
                continue;
            }
            return -1L;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.doWriteTo(byteArrayOutputStream, false);
            byte[] iOException = byteArrayOutputStream.toByteArray();
            return l + (long)iOException.length;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

