/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.buffer.CircularByteBuffer;

public class CircularBufferInputStream
extends InputStream {
    protected final InputStream in;
    protected final CircularByteBuffer buffer;
    protected final int bufferSize;
    private boolean eof;

    public CircularBufferInputStream(InputStream inputStream2, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid bufferSize: " + n);
        }
        this.in = Objects.requireNonNull(inputStream2, "inputStream");
        this.buffer = new CircularByteBuffer(n);
        this.bufferSize = n;
        this.eof = false;
    }

    public CircularBufferInputStream(InputStream inputStream2) {
        this(inputStream2, 8192);
    }

    protected void fillBuffer() throws IOException {
        if (this.eof) {
            return;
        }
        int n = this.buffer.getSpace();
        byte[] byArray = IOUtils.byteArray(n);
        while (n > 0) {
            int n2 = this.in.read(byArray, 0, n);
            if (n2 == -1) {
                this.eof = true;
                return;
            }
            if (n2 <= 0) continue;
            this.buffer.add(byArray, 0, n2);
            n -= n2;
        }
    }

    protected boolean haveBytes(int n) throws IOException {
        if (this.buffer.getCurrentNumberOfBytes() < n) {
            this.fillBuffer();
        }
        return this.buffer.hasBytes();
    }

    @Override
    public int read() throws IOException {
        if (!this.haveBytes(1)) {
            return -1;
        }
        return this.buffer.read() & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        Objects.requireNonNull(byArray, "targetBuffer");
        if (n < 0) {
            throw new IllegalArgumentException("Offset must not be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        if (!this.haveBytes(n2)) {
            return -1;
        }
        int n3 = Math.min(n2, this.buffer.getCurrentNumberOfBytes());
        for (int i = 0; i < n3; ++i) {
            byArray[n + i] = this.buffer.read();
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.eof = true;
        this.buffer.clear();
    }
}

