/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class SequenceReader
extends Reader {
    private Reader reader;
    private Iterator<? extends Reader> readers;

    public SequenceReader(Iterable<? extends Reader> iterable) {
        this.readers = Objects.requireNonNull(iterable, "readers").iterator();
        this.reader = this.nextReader();
    }

    public SequenceReader(Reader ... readerArray) {
        this(Arrays.asList(readerArray));
    }

    @Override
    public void close() throws IOException {
        this.readers = null;
        this.reader = null;
    }

    private Reader nextReader() {
        return this.readers.hasNext() ? this.readers.next() : null;
    }

    @Override
    public int read() throws IOException {
        int n = -1;
        while (this.reader != null && (n = this.reader.read()) == -1) {
            this.reader = this.nextReader();
        }
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Objects.requireNonNull(cArray, "cbuf");
        if (n2 < 0 || n < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + cArray.length + ", offset=" + n + ", length=" + n2);
        }
        int n3 = 0;
        while (this.reader != null) {
            int n4 = this.reader.read(cArray, n, n2);
            if (n4 == -1) {
                this.reader = this.nextReader();
                continue;
            }
            n3 += n4;
            n += n4;
            if ((n2 -= n4) > 0) continue;
            break;
        }
        if (n3 > 0) {
            return n3;
        }
        return -1;
    }
}

