/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.StandardLineSeparator;

public class ReversedLinesFileReader
implements Closeable {
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private final int blockSize;
    private final Charset charset;
    private final SeekableByteChannel channel;
    private final long totalByteLength;
    private final long totalBlockCount;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped;

    @Deprecated
    public ReversedLinesFileReader(File file) throws IOException {
        this(file, 8192, Charset.defaultCharset());
    }

    public ReversedLinesFileReader(File file, Charset charset) throws IOException {
        this(file.toPath(), charset);
    }

    public ReversedLinesFileReader(File file, int n, Charset charset) throws IOException {
        this(file.toPath(), n, charset);
    }

    public ReversedLinesFileReader(File file, int n, String string) throws IOException {
        this(file.toPath(), n, string);
    }

    public ReversedLinesFileReader(Path path, Charset charset) throws IOException {
        this(path, 8192, charset);
    }

    public ReversedLinesFileReader(Path path, int n, Charset charset) throws IOException {
        this.blockSize = n;
        this.charset = Charsets.toCharset(charset);
        CharsetEncoder charsetEncoder = this.charset.newEncoder();
        float f = charsetEncoder.maxBytesPerChar();
        if (f == 1.0f) {
            this.byteDecrement = 1;
        } else if (this.charset == StandardCharsets.UTF_8) {
            this.byteDecrement = 1;
        } else if (this.charset == Charset.forName("Shift_JIS") || this.charset == Charset.forName("windows-31j") || this.charset == Charset.forName("x-windows-949") || this.charset == Charset.forName("gbk") || this.charset == Charset.forName("x-windows-950")) {
            this.byteDecrement = 1;
        } else if (this.charset == StandardCharsets.UTF_16BE || this.charset == StandardCharsets.UTF_16LE) {
            this.byteDecrement = 2;
        } else {
            if (this.charset == StandardCharsets.UTF_16) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + charset + " is not supported yet (feel free to submit a patch)");
        }
        this.newLineSequences = new byte[][]{StandardLineSeparator.CRLF.getBytes(this.charset), StandardLineSeparator.LF.getBytes(this.charset), StandardLineSeparator.CR.getBytes(this.charset)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
        this.channel = Files.newByteChannel(path, StandardOpenOption.READ);
        this.totalByteLength = this.channel.size();
        int n2 = (int)(this.totalByteLength % (long)n);
        if (n2 > 0) {
            this.totalBlockCount = this.totalByteLength / (long)n + 1L;
        } else {
            this.totalBlockCount = this.totalByteLength / (long)n;
            if (this.totalByteLength > 0L) {
                n2 = n;
            }
        }
        this.currentFilePart = new FilePart(this.totalBlockCount, n2, null);
    }

    public ReversedLinesFileReader(Path path, int n, String string) throws IOException {
        this(path, n, Charsets.toCharset(string));
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public String readLine() throws IOException {
        String string = this.currentFilePart.readLine();
        while (string == null) {
            this.currentFilePart = this.currentFilePart.rollOver();
            if (this.currentFilePart == null) break;
            string = this.currentFilePart.readLine();
        }
        if (EMPTY_STRING.equals(string) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            string = this.readLine();
        }
        return string;
    }

    public List<String> readLines(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("lineCount < 0");
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = this.readLine();
            if (string == null) {
                return arrayList;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public String toString(int n) throws IOException {
        List<String> list = this.readLines(n);
        Collections.reverse(list);
        return list.isEmpty() ? EMPTY_STRING : String.join((CharSequence)System.lineSeparator(), list) + System.lineSeparator();
    }

    private class FilePart {
        private final long no;
        private final byte[] data;
        private byte[] leftOver;
        private int currentLastBytePos;

        private FilePart(long l, int n, byte[] byArray) throws IOException {
            this.no = l;
            int n2 = n + (byArray != null ? byArray.length : 0);
            this.data = new byte[n2];
            long l2 = (l - 1L) * (long)ReversedLinesFileReader.this.blockSize;
            if (l > 0L) {
                ReversedLinesFileReader.this.channel.position(l2);
                int n3 = ReversedLinesFileReader.this.channel.read(ByteBuffer.wrap(this.data, 0, n));
                if (n3 != n) {
                    throw new IllegalStateException("Count of requested bytes and actually read bytes don't match");
                }
            }
            if (byArray != null) {
                System.arraycopy(byArray, 0, this.data, n, byArray.length);
            }
            this.currentLastBytePos = this.data.length - 1;
            this.leftOver = null;
        }

        private void createLeftOver() {
            int n = this.currentLastBytePos + 1;
            if (n > 0) {
                this.leftOver = IOUtils.byteArray(n);
                System.arraycopy(this.data, 0, this.leftOver, 0, n);
            } else {
                this.leftOver = null;
            }
            this.currentLastBytePos = -1;
        }

        private int getNewLineMatchByteCount(byte[] byArray, int n) {
            for (byte[] byArray2 : ReversedLinesFileReader.this.newLineSequences) {
                boolean bl = true;
                for (int i = byArray2.length - 1; i >= 0; --i) {
                    int n2 = n + i - (byArray2.length - 1);
                    bl &= n2 >= 0 && byArray[n2] == byArray2[i];
                }
                if (!bl) continue;
                return byArray2.length;
            }
            return 0;
        }

        private String readLine() {
            String string = null;
            boolean bl = this.no == 1L;
            int n = this.currentLastBytePos;
            while (n > -1) {
                if (!bl && n < ReversedLinesFileReader.this.avoidNewlineSplitBufferSize) {
                    this.createLeftOver();
                    break;
                }
                int n2 = this.getNewLineMatchByteCount(this.data, n);
                if (n2 > 0) {
                    int n3 = n + 1;
                    int n4 = this.currentLastBytePos - n3 + 1;
                    if (n4 < 0) {
                        throw new IllegalStateException("Unexpected negative line length=" + n4);
                    }
                    byte[] byArray = IOUtils.byteArray(n4);
                    System.arraycopy(this.data, n3, byArray, 0, n4);
                    string = new String(byArray, ReversedLinesFileReader.this.charset);
                    this.currentLastBytePos = n - n2;
                    break;
                }
                if ((n -= ReversedLinesFileReader.this.byteDecrement) >= 0) continue;
                this.createLeftOver();
                break;
            }
            if (bl && this.leftOver != null) {
                string = new String(this.leftOver, ReversedLinesFileReader.this.charset);
                this.leftOver = null;
            }
            return string;
        }

        private FilePart rollOver() throws IOException {
            if (this.currentLastBytePos > -1) {
                throw new IllegalStateException("Current currentLastCharPos unexpectedly positive... last readLine() should have returned something! currentLastCharPos=" + this.currentLastBytePos);
            }
            if (this.no > 1L) {
                return new FilePart(this.no - 1L, ReversedLinesFileReader.this.blockSize, this.leftOver);
            }
            if (this.leftOver != null) {
                throw new IllegalStateException("Unexpected leftover of the last block: leftOverOfThisFilePart=" + new String(this.leftOver, ReversedLinesFileReader.this.charset));
            }
            return null;
        }
    }
}

