/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.binary.StringUtils;

public final class MurmurHash3 {
    @Deprecated
    public static final long NULL_HASHCODE = 2862933555777941757L;
    public static final int DEFAULT_SEED = 104729;
    static final int LONG_BYTES = 8;
    static final int INTEGER_BYTES = 4;
    static final int SHORT_BYTES = 2;
    private static final int C1_32 = -862048943;
    private static final int C2_32 = 461845907;
    private static final int R1_32 = 15;
    private static final int R2_32 = 13;
    private static final int M_32 = 5;
    private static final int N_32 = -430675100;
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private static final int R1 = 31;
    private static final int R2 = 27;
    private static final int R3 = 33;
    private static final int M = 5;
    private static final int N1 = 1390208809;
    private static final int N2 = 944331445;

    private MurmurHash3() {
    }

    public static int hash32(long l, long l2) {
        return MurmurHash3.hash32(l, l2, 104729);
    }

    public static int hash32(long l, long l2, int n) {
        int n2 = n;
        long l3 = Long.reverseBytes(l);
        long l4 = Long.reverseBytes(l2);
        n2 = MurmurHash3.mix32((int)l3, n2);
        n2 = MurmurHash3.mix32((int)(l3 >>> 32), n2);
        n2 = MurmurHash3.mix32((int)l4, n2);
        n2 = MurmurHash3.mix32((int)(l4 >>> 32), n2);
        return MurmurHash3.fmix32(n2 ^= 0x10);
    }

    public static int hash32(long l) {
        return MurmurHash3.hash32(l, 104729);
    }

    public static int hash32(long l, int n) {
        int n2 = n;
        long l2 = Long.reverseBytes(l);
        n2 = MurmurHash3.mix32((int)l2, n2);
        n2 = MurmurHash3.mix32((int)(l2 >>> 32), n2);
        return MurmurHash3.fmix32(n2 ^= 8);
    }

    @Deprecated
    public static int hash32(byte[] byArray) {
        return MurmurHash3.hash32(byArray, 0, byArray.length, 104729);
    }

    @Deprecated
    public static int hash32(String string) {
        byte[] byArray = StringUtils.getBytesUtf8(string);
        return MurmurHash3.hash32(byArray, 0, byArray.length, 104729);
    }

    @Deprecated
    public static int hash32(byte[] byArray, int n) {
        return MurmurHash3.hash32(byArray, n, 104729);
    }

    @Deprecated
    public static int hash32(byte[] byArray, int n, int n2) {
        return MurmurHash3.hash32(byArray, 0, n, n2);
    }

    @Deprecated
    public static int hash32(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n3;
        int n7 = n2 >> 2;
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = n + (n5 << 2);
            int n8 = MurmurHash3.getLittleEndianInt(byArray, n4);
            n6 = MurmurHash3.mix32(n8, n6);
        }
        n5 = n + (n7 << 2);
        n4 = 0;
        switch (n + n2 - n5) {
            case 3: {
                n4 ^= byArray[n5 + 2] << 16;
            }
            case 2: {
                n4 ^= byArray[n5 + 1] << 8;
            }
            case 1: {
                n4 ^= byArray[n5];
                n4 *= -862048943;
                n4 = Integer.rotateLeft(n4, 15);
                n6 ^= (n4 *= 461845907);
            }
        }
        return MurmurHash3.fmix32(n6 ^= n2);
    }

    public static int hash32x86(byte[] byArray) {
        return MurmurHash3.hash32x86(byArray, 0, byArray.length, 0);
    }

    public static int hash32x86(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n3;
        int n7 = n2 >> 2;
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = n + (n5 << 2);
            int n8 = MurmurHash3.getLittleEndianInt(byArray, n4);
            n6 = MurmurHash3.mix32(n8, n6);
        }
        n5 = n + (n7 << 2);
        n4 = 0;
        switch (n + n2 - n5) {
            case 3: {
                n4 ^= (byArray[n5 + 2] & 0xFF) << 16;
            }
            case 2: {
                n4 ^= (byArray[n5 + 1] & 0xFF) << 8;
            }
            case 1: {
                n4 ^= byArray[n5] & 0xFF;
                n4 *= -862048943;
                n4 = Integer.rotateLeft(n4, 15);
                n6 ^= (n4 *= 461845907);
            }
        }
        return MurmurHash3.fmix32(n6 ^= n2);
    }

    @Deprecated
    public static long hash64(long l) {
        long l2 = 104729L;
        long l3 = Long.reverseBytes(l);
        int n = 8;
        l3 *= -8663945395140668459L;
        l3 = Long.rotateLeft(l3, 31);
        l2 ^= (l3 *= 5545529020109919103L);
        l2 = Long.rotateLeft(l2, 27) * 5L + 1390208809L;
        l2 ^= 8L;
        l2 = MurmurHash3.fmix64(l2);
        return l2;
    }

    @Deprecated
    public static long hash64(int n) {
        long l = (long)Integer.reverseBytes(n) & 0xFFFFFFFFL;
        int n2 = 4;
        long l2 = 104729L;
        l *= -8663945395140668459L;
        l = Long.rotateLeft(l, 31);
        l2 ^= (l *= 5545529020109919103L);
        l2 ^= 4L;
        l2 = MurmurHash3.fmix64(l2);
        return l2;
    }

    @Deprecated
    public static long hash64(short s2) {
        long l = 104729L;
        long l2 = 0L;
        l2 ^= ((long)s2 & 0xFFL) << 8;
        l2 ^= (long)((s2 & 0xFF00) >> 8) & 0xFFL;
        l2 *= -8663945395140668459L;
        l2 = Long.rotateLeft(l2, 31);
        l ^= (l2 *= 5545529020109919103L);
        l ^= 2L;
        l = MurmurHash3.fmix64(l);
        return l;
    }

    @Deprecated
    public static long hash64(byte[] byArray) {
        return MurmurHash3.hash64(byArray, 0, byArray.length, 104729);
    }

    @Deprecated
    public static long hash64(byte[] byArray, int n, int n2) {
        return MurmurHash3.hash64(byArray, n, n2, 104729);
    }

    @Deprecated
    public static long hash64(byte[] byArray, int n, int n2, int n3) {
        long l = n3;
        int n4 = n2 >> 3;
        for (int i = 0; i < n4; ++i) {
            int n5 = n + (i << 3);
            long l2 = MurmurHash3.getLittleEndianLong(byArray, n5);
            l2 *= -8663945395140668459L;
            l2 = Long.rotateLeft(l2, 31);
            l ^= (l2 *= 5545529020109919103L);
            l = Long.rotateLeft(l, 27) * 5L + 1390208809L;
        }
        long l3 = 0L;
        int n6 = n + (n4 << 3);
        switch (n + n2 - n6) {
            case 7: {
                l3 ^= ((long)byArray[n6 + 6] & 0xFFL) << 48;
            }
            case 6: {
                l3 ^= ((long)byArray[n6 + 5] & 0xFFL) << 40;
            }
            case 5: {
                l3 ^= ((long)byArray[n6 + 4] & 0xFFL) << 32;
            }
            case 4: {
                l3 ^= ((long)byArray[n6 + 3] & 0xFFL) << 24;
            }
            case 3: {
                l3 ^= ((long)byArray[n6 + 2] & 0xFFL) << 16;
            }
            case 2: {
                l3 ^= ((long)byArray[n6 + 1] & 0xFFL) << 8;
            }
            case 1: {
                l3 ^= (long)byArray[n6] & 0xFFL;
                l3 *= -8663945395140668459L;
                l3 = Long.rotateLeft(l3, 31);
                l ^= (l3 *= 5545529020109919103L);
            }
        }
        l ^= (long)n2;
        l = MurmurHash3.fmix64(l);
        return l;
    }

    public static long[] hash128(byte[] byArray) {
        return MurmurHash3.hash128(byArray, 0, byArray.length, 104729);
    }

    public static long[] hash128x64(byte[] byArray) {
        return MurmurHash3.hash128x64(byArray, 0, byArray.length, 0);
    }

    @Deprecated
    public static long[] hash128(String string) {
        byte[] byArray = StringUtils.getBytesUtf8(string);
        return MurmurHash3.hash128(byArray, 0, byArray.length, 104729);
    }

    @Deprecated
    public static long[] hash128(byte[] byArray, int n, int n2, int n3) {
        return MurmurHash3.hash128x64Internal(byArray, n, n2, n3);
    }

    public static long[] hash128x64(byte[] byArray, int n, int n2, int n3) {
        return MurmurHash3.hash128x64Internal(byArray, n, n2, (long)n3 & 0xFFFFFFFFL);
    }

    private static long[] hash128x64Internal(byte[] byArray, int n, int n2, long l) {
        long l2;
        long l3 = l;
        long l4 = l;
        int n3 = n2 >> 4;
        for (int i = 0; i < n3; ++i) {
            int n4 = n + (i << 4);
            l2 = MurmurHash3.getLittleEndianLong(byArray, n4);
            long l5 = MurmurHash3.getLittleEndianLong(byArray, n4 + 8);
            l2 *= -8663945395140668459L;
            l2 = Long.rotateLeft(l2, 31);
            l3 ^= (l2 *= 5545529020109919103L);
            l3 = Long.rotateLeft(l3, 27);
            l3 += l4;
            l3 = l3 * 5L + 1390208809L;
            l5 *= 5545529020109919103L;
            l5 = Long.rotateLeft(l5, 33);
            l4 ^= (l5 *= -8663945395140668459L);
            l4 = Long.rotateLeft(l4, 31);
            l4 += l3;
            l4 = l4 * 5L + 944331445L;
        }
        long l6 = 0L;
        l2 = 0L;
        int n5 = n + (n3 << 4);
        switch (n + n2 - n5) {
            case 15: {
                l2 ^= ((long)byArray[n5 + 14] & 0xFFL) << 48;
            }
            case 14: {
                l2 ^= ((long)byArray[n5 + 13] & 0xFFL) << 40;
            }
            case 13: {
                l2 ^= ((long)byArray[n5 + 12] & 0xFFL) << 32;
            }
            case 12: {
                l2 ^= ((long)byArray[n5 + 11] & 0xFFL) << 24;
            }
            case 11: {
                l2 ^= ((long)byArray[n5 + 10] & 0xFFL) << 16;
            }
            case 10: {
                l2 ^= ((long)byArray[n5 + 9] & 0xFFL) << 8;
            }
            case 9: {
                l2 ^= (long)(byArray[n5 + 8] & 0xFF);
                l2 *= 5545529020109919103L;
                l2 = Long.rotateLeft(l2, 33);
                l4 ^= (l2 *= -8663945395140668459L);
            }
            case 8: {
                l6 ^= ((long)byArray[n5 + 7] & 0xFFL) << 56;
            }
            case 7: {
                l6 ^= ((long)byArray[n5 + 6] & 0xFFL) << 48;
            }
            case 6: {
                l6 ^= ((long)byArray[n5 + 5] & 0xFFL) << 40;
            }
            case 5: {
                l6 ^= ((long)byArray[n5 + 4] & 0xFFL) << 32;
            }
            case 4: {
                l6 ^= ((long)byArray[n5 + 3] & 0xFFL) << 24;
            }
            case 3: {
                l6 ^= ((long)byArray[n5 + 2] & 0xFFL) << 16;
            }
            case 2: {
                l6 ^= ((long)byArray[n5 + 1] & 0xFFL) << 8;
            }
            case 1: {
                l6 ^= (long)(byArray[n5] & 0xFF);
                l6 *= -8663945395140668459L;
                l6 = Long.rotateLeft(l6, 31);
                l3 ^= (l6 *= 5545529020109919103L);
            }
        }
        l3 ^= (long)n2;
        l3 += (l4 ^= (long)n2);
        l4 += l3;
        l3 = MurmurHash3.fmix64(l3);
        l4 = MurmurHash3.fmix64(l4);
        l3 += l4;
        return new long[]{l3, l4 += l3};
    }

    private static long getLittleEndianLong(byte[] byArray, int n) {
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    private static int getLittleEndianInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private static int mix32(int n, int n2) {
        n *= -862048943;
        n = Integer.rotateLeft(n, 15);
        return Integer.rotateLeft(n2 ^= (n *= 461845907), 13) * 5 + -430675100;
    }

    private static int fmix32(int n) {
        n ^= n >>> 16;
        n *= -2048144789;
        n ^= n >>> 13;
        n *= -1028477387;
        n ^= n >>> 16;
        return n;
    }

    private static long fmix64(long l) {
        l ^= l >>> 33;
        l *= -49064778989728563L;
        l ^= l >>> 33;
        l *= -4265267296055464877L;
        l ^= l >>> 33;
        return l;
    }

    @Deprecated
    public static class IncrementalHash32
    extends IncrementalHash32x86 {
        @Override
        @Deprecated
        int finalise(int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = 0;
            switch (n2) {
                case 3: {
                    n5 ^= byArray[2] << 16;
                }
                case 2: {
                    n5 ^= byArray[1] << 8;
                }
                case 1: {
                    n5 ^= byArray[0];
                    n5 *= -862048943;
                    n5 = Integer.rotateLeft(n5, 15);
                    n4 ^= (n5 *= 461845907);
                }
            }
            return MurmurHash3.fmix32(n4 ^= n3);
        }
    }

    public static class IncrementalHash32x86 {
        private static final int BLOCK_SIZE = 4;
        private final byte[] unprocessed = new byte[3];
        private int unprocessedLength;
        private int totalLen;
        private int hash;

        public final void start(int n) {
            this.totalLen = 0;
            this.unprocessedLength = 0;
            this.hash = n;
        }

        public final void add(byte[] byArray, int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (n2 <= 0) {
                return;
            }
            this.totalLen += n2;
            if (this.unprocessedLength + n2 - 4 < 0) {
                System.arraycopy(byArray, n, this.unprocessed, this.unprocessedLength, n2);
                this.unprocessedLength += n2;
                return;
            }
            if (this.unprocessedLength > 0) {
                n6 = -1;
                switch (this.unprocessedLength) {
                    case 1: {
                        n6 = IncrementalHash32x86.orBytes(this.unprocessed[0], byArray[n], byArray[n + 1], byArray[n + 2]);
                        break;
                    }
                    case 2: {
                        n6 = IncrementalHash32x86.orBytes(this.unprocessed[0], this.unprocessed[1], byArray[n], byArray[n + 1]);
                        break;
                    }
                    case 3: {
                        n6 = IncrementalHash32x86.orBytes(this.unprocessed[0], this.unprocessed[1], this.unprocessed[2], byArray[n]);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unprocessed length should be 1, 2, or 3: " + this.unprocessedLength);
                    }
                }
                this.hash = MurmurHash3.mix32(n6, this.hash);
                n5 = 4 - this.unprocessedLength;
                n4 = n + n5;
                n3 = n2 - n5;
            } else {
                n4 = n;
                n3 = n2;
            }
            n6 = n3 >> 2;
            for (n5 = 0; n5 < n6; ++n5) {
                int n7 = n4 + (n5 << 2);
                int n8 = MurmurHash3.getLittleEndianInt(byArray, n7);
                this.hash = MurmurHash3.mix32(n8, this.hash);
            }
            n5 = n6 << 2;
            this.unprocessedLength = n3 - n5;
            if (this.unprocessedLength != 0) {
                System.arraycopy(byArray, n4 + n5, this.unprocessed, 0, this.unprocessedLength);
            }
        }

        public final int end() {
            return this.finalise(this.hash, this.unprocessedLength, this.unprocessed, this.totalLen);
        }

        int finalise(int n, int n2, byte[] byArray, int n3) {
            int n4 = n;
            int n5 = 0;
            switch (n2) {
                case 3: {
                    n5 ^= (byArray[2] & 0xFF) << 16;
                }
                case 2: {
                    n5 ^= (byArray[1] & 0xFF) << 8;
                }
                case 1: {
                    n5 ^= byArray[0] & 0xFF;
                    n5 *= -862048943;
                    n5 = Integer.rotateLeft(n5, 15);
                    n4 ^= (n5 *= 461845907);
                }
            }
            return MurmurHash3.fmix32(n4 ^= n3);
        }

        private static int orBytes(byte by, byte by2, byte by3, byte by4) {
            return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
        }
    }
}

