/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.binary.BaseNCodec;

public class Base16
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 4;
    private static final int BYTES_PER_ENCODED_BLOCK = 2;
    private static final int BYTES_PER_UNENCODED_BLOCK = 1;
    private static final byte[] UPPER_CASE_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final byte[] UPPER_CASE_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] LOWER_CASE_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final byte[] LOWER_CASE_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final int MASK_4BITS = 15;
    private final byte[] decodeTable;
    private final byte[] encodeTable;

    public Base16() {
        this(false);
    }

    public Base16(boolean bl) {
        this(bl, DECODING_POLICY_DEFAULT);
    }

    public Base16(boolean bl, CodecPolicy codecPolicy) {
        super(1, 2, 0, 0, (byte)61, codecPolicy);
        if (bl) {
            this.encodeTable = LOWER_CASE_ENCODE_TABLE;
            this.decodeTable = LOWER_CASE_DECODE_TABLE;
        } else {
            this.encodeTable = UPPER_CASE_ENCODE_TABLE;
            this.decodeTable = UPPER_CASE_DECODE_TABLE;
        }
    }

    @Override
    void decode(byte[] byArray, int n, int n2, BaseNCodec.Context context) {
        int n3;
        int n4;
        if (context.eof || n2 < 0) {
            context.eof = true;
            if (context.ibitWorkArea != 0) {
                this.validateTrailingCharacter();
            }
            return;
        }
        int n5 = (context.ibitWorkArea != 0 ? 1 : 0) + (n4 = Math.min(byArray.length - n, n2));
        if (n5 == 1 && n5 == n4) {
            context.ibitWorkArea = this.decodeOctet(byArray[n]) + 1;
            return;
        }
        int n6 = n5 % 2 == 0 ? n5 : n5 - 1;
        byte[] byArray2 = this.ensureBufferSize(n6 / 2, context);
        int n7 = 0;
        if (n4 < n5) {
            n3 = context.ibitWorkArea - 1 << 4;
            int n8 = n++;
            n7 = 2;
            byArray2[context.pos++] = (byte)(n3 |= this.decodeOctet(byArray[n8]));
            context.ibitWorkArea = 0;
        }
        while (n7 < n6) {
            n3 = this.decodeOctet(byArray[n++]) << 4;
            int n9 = n++;
            n7 += 2;
            byArray2[context.pos++] = (byte)(n3 |= this.decodeOctet(byArray[n9]));
        }
        if (n7 < n4) {
            context.ibitWorkArea = this.decodeOctet(byArray[n7]) + 1;
        }
    }

    private int decodeOctet(byte by) {
        int n = -1;
        if ((by & 0xFF) < this.decodeTable.length) {
            n = this.decodeTable[by];
        }
        if (n == -1) {
            throw new IllegalArgumentException("Invalid octet in encoded value: " + by);
        }
        return n;
    }

    @Override
    void encode(byte[] byArray, int n, int n2, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (n2 < 0) {
            context.eof = true;
            return;
        }
        int n3 = n2 * 2;
        if (n3 < 0) {
            throw new IllegalArgumentException("Input length exceeds maximum size for encoded data: " + n2);
        }
        byte[] byArray2 = this.ensureBufferSize(n3, context);
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            byte by = byArray[i];
            int n5 = by >> 4 & 0xF;
            int n6 = by & 0xF;
            byArray2[context.pos++] = this.encodeTable[n5];
            byArray2[context.pos++] = this.encodeTable[n6];
        }
    }

    @Override
    public boolean isInAlphabet(byte by) {
        return (by & 0xFF) < this.decodeTable.length && this.decodeTable[by] != -1;
    }

    private void validateTrailingCharacter() {
        if (this.isStrictDecoding()) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character is a valid base 16 alphabetcharacter but not a possible encoding. Decoding requires at least two characters to create one byte.");
        }
    }
}

