/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import okio.-Util;
import okio.Buffer;
import okio.ByteString;
import okio.Segment;
import okio.internal.SegmentedByteStringKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0015\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\r\u0010\u0019\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\u001d\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0001H\u0010\u00a2\u0006\u0002\b J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u001aH\u0016J\r\u0010#\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b(J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u001aH\u0016J(\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0016J(\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0016J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u001aH\u0016J\b\u00104\u001a\u00020\u0001H\u0016J\b\u00105\u001a\u00020\u0001H\u0016J\b\u00106\u001a\u00020\u0004H\u0016J\b\u00107\u001a\u00020\u0001H\u0002J\b\u00108\u001a\u00020\u0010H\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J%\u00109\u001a\u00020:2\u0006\u0010=\u001a\u00020>2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b?J\b\u0010@\u001a\u00020AH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006B"}, d2={"Lokio/SegmentedByteString;", "Lokio/ByteString;", "segments", "", "", "directory", "", "([[B[I)V", "getDirectory$okio", "()[I", "getSegments$okio", "()[[B", "[[B", "asByteBuffer", "Ljava/nio/ByteBuffer;", "base64", "", "base64Url", "digest", "algorithm", "digest$okio", "equals", "", "other", "", "getSize", "", "getSize$okio", "hashCode", "hex", "hmac", "key", "hmac$okio", "indexOf", "fromIndex", "internalArray", "internalArray$okio", "internalGet", "", "pos", "internalGet$okio", "lastIndexOf", "rangeEquals", "offset", "otherOffset", "byteCount", "string", "charset", "Ljava/nio/charset/Charset;", "substring", "beginIndex", "endIndex", "toAsciiLowercase", "toAsciiUppercase", "toByteArray", "toByteString", "toString", "write", "", "out", "Ljava/io/OutputStream;", "buffer", "Lokio/Buffer;", "write$okio", "writeReplace", "Ljava/lang/Object;", "okio"})
public final class SegmentedByteString
extends ByteString {
    @NotNull
    private final transient byte[][] segments;
    @NotNull
    private final transient int[] directory;

    @Override
    @NotNull
    public String string(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        return this.toByteString().string(charset);
    }

    @Override
    @NotNull
    public String base64() {
        return this.toByteString().base64();
    }

    @Override
    @NotNull
    public String hex() {
        return this.toByteString().hex();
    }

    @Override
    @NotNull
    public ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    @Override
    @NotNull
    public ByteString toAsciiUppercase() {
        return this.toByteString().toAsciiUppercase();
    }

    @Override
    @NotNull
    public ByteString digest$okio(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        SegmentedByteString segmentedByteString = this;
        boolean bl = false;
        int n = ((Object[])segmentedByteString.getSegments$okio()).length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = segmentedByteString.getDirectory$okio()[n + i];
            int n4 = segmentedByteString.getDirectory$okio()[i];
            int n5 = n4 - n2;
            int n6 = n3;
            byte[] byArray = segmentedByteString.getSegments$okio()[i];
            boolean bl2 = false;
            messageDigest.update(byArray, n6, n5);
            n2 = n4;
        }
        byte[] byArray = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue(byArray, "digest.digest()");
        return new ByteString(byArray);
    }

    @Override
    @NotNull
    public ByteString hmac$okio(@NotNull String string, @NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter(string, "algorithm");
        Intrinsics.checkNotNullParameter(byteString, "key");
        try {
            Mac mac = Mac.getInstance(string);
            mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            SegmentedByteString segmentedByteString = this;
            boolean bl = false;
            int n = ((Object[])segmentedByteString.getSegments$okio()).length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = segmentedByteString.getDirectory$okio()[n + i];
                int n4 = segmentedByteString.getDirectory$okio()[i];
                int n5 = n4 - n2;
                int n6 = n3;
                byte[] byArray = segmentedByteString.getSegments$okio()[i];
                boolean bl2 = false;
                mac.update(byArray, n6, n5);
                n2 = n4;
            }
            byte[] byArray = mac.doFinal();
            Intrinsics.checkNotNullExpressionValue(byArray, "mac.doFinal()");
            return new ByteString(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw (Throwable)new IllegalArgumentException(invalidKeyException);
        }
    }

    @Override
    @NotNull
    public String base64Url() {
        return this.toByteString().base64Url();
    }

    @Override
    @NotNull
    public ByteString substring(int n, int n2) {
        ByteString byteString;
        SegmentedByteString segmentedByteString = this;
        boolean bl = false;
        int n3 = n >= 0 ? 1 : 0;
        int n4 = 0;
        int n5 = 0;
        if (n3 == 0) {
            boolean bl2 = false;
            String string = "beginIndex=" + n + " < 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n3 = n2 <= segmentedByteString.size() ? 1 : 0;
        n4 = 0;
        n5 = 0;
        if (n3 == 0) {
            boolean bl3 = false;
            String string = "endIndex=" + n2 + " > length(" + segmentedByteString.size() + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n3 = n2 - n;
        n4 = n3 >= 0 ? 1 : 0;
        n5 = 0;
        boolean bl4 = false;
        if (n4 == 0) {
            boolean bl5 = false;
            String string = "endIndex=" + n2 + " < beginIndex=" + n;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (n == 0 && n2 == segmentedByteString.size()) {
            byteString = segmentedByteString;
        } else if (n == n2) {
            byteString = ByteString.EMPTY;
        } else {
            n4 = SegmentedByteStringKt.segment(segmentedByteString, n);
            n5 = SegmentedByteStringKt.segment(segmentedByteString, n2 - 1);
            Object[] objectArray = (Object[])segmentedByteString.getSegments$okio();
            int n6 = n5 + 1;
            int n7 = 0;
            byte[][] byArray = (byte[][])ArraysKt.copyOfRange(objectArray, n4, n6);
            objectArray = new int[((Object[])byArray).length * 2];
            n6 = 0;
            n7 = n4;
            int n8 = n5;
            if (n7 <= n8) {
                while (true) {
                    int n9 = segmentedByteString.getDirectory$okio()[n7] - n;
                    boolean bl6 = false;
                    objectArray[n6] = Math.min(n9, n3);
                    objectArray[n6++ + ((Object[])byArray).length] = segmentedByteString.getDirectory$okio()[n7 + ((Object[])segmentedByteString.getSegments$okio()).length];
                    if (n7 == n8) break;
                    ++n7;
                }
            }
            n7 = n4 == 0 ? 0 : segmentedByteString.getDirectory$okio()[n4 - 1];
            int n10 = ((Object[])byArray).length;
            objectArray[n10] = objectArray[n10] + (n - n7);
            byteString = new SegmentedByteString(byArray, (int[])objectArray);
        }
        return byteString;
    }

    @Override
    public byte internalGet$okio(int n) {
        SegmentedByteString segmentedByteString = this;
        boolean bl = false;
        -Util.checkOffsetAndCount(segmentedByteString.getDirectory$okio()[((Object[])segmentedByteString.getSegments$okio()).length - 1], n, 1L);
        int n2 = SegmentedByteStringKt.segment(segmentedByteString, n);
        int n3 = n2 == 0 ? 0 : segmentedByteString.getDirectory$okio()[n2 - 1];
        int n4 = segmentedByteString.getDirectory$okio()[n2 + ((Object[])segmentedByteString.getSegments$okio()).length];
        return segmentedByteString.getSegments$okio()[n2][n - n3 + n4];
    }

    @Override
    public int getSize$okio() {
        SegmentedByteString segmentedByteString = this;
        boolean bl = false;
        return segmentedByteString.getDirectory$okio()[((Object[])segmentedByteString.getSegments$okio()).length - 1];
    }

    @Override
    @NotNull
    public byte[] toByteArray() {
        SegmentedByteString segmentedByteString = this;
        boolean bl = false;
        byte[] byArray = new byte[segmentedByteString.size()];
        int n = 0;
        SegmentedByteString segmentedByteString2 = segmentedByteString;
        boolean bl2 = false;
        int n2 = ((Object[])segmentedByteString2.getSegments$okio()).length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = segmentedByteString2.getDirectory$okio()[n2 + i];
            int n5 = segmentedByteString2.getDirectory$okio()[i];
            int n6 = n5 - n3;
            int n7 = n4;
            byte[] byArray2 = segmentedByteString2.getSegments$okio()[i];
            boolean bl3 = false;
            ArraysKt.copyInto(byArray2, byArray, n, n7, n7 + n6);
            n += n6;
            n3 = n5;
        }
        return byArray;
    }

    @Override
    @NotNull
    public ByteBuffer asByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.toByteArray()).asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "ByteBuffer.wrap(toByteArray()).asReadOnlyBuffer()");
        return byteBuffer;
    }

    @Override
    public void write(@NotNull OutputStream outputStream2) throws IOException {
        Intrinsics.checkNotNullParameter(outputStream2, "out");
        SegmentedByteString segmentedByteString = this;
        boolean bl = false;
        int n = ((Object[])segmentedByteString.getSegments$okio()).length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = segmentedByteString.getDirectory$okio()[n + i];
            int n4 = segmentedByteString.getDirectory$okio()[i];
            int n5 = n4 - n2;
            int n6 = n3;
            byte[] byArray = segmentedByteString.getSegments$okio()[i];
            boolean bl2 = false;
            outputStream2.write(byArray, n6, n5);
            n2 = n4;
        }
    }

    @Override
    public void write$okio(@NotNull Buffer buffer, int n, int n2) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        SegmentedByteString segmentedByteString = this;
        boolean bl = false;
        SegmentedByteString segmentedByteString2 = segmentedByteString;
        int n3 = n + n2;
        boolean bl2 = false;
        int n4 = SegmentedByteStringKt.segment(segmentedByteString2, n);
        int n5 = n;
        while (n5 < n3) {
            int n6 = n4 == 0 ? 0 : segmentedByteString2.getDirectory$okio()[n4 - 1];
            int n7 = segmentedByteString2.getDirectory$okio()[n4] - n6;
            int n8 = segmentedByteString2.getDirectory$okio()[((Object[])segmentedByteString2.getSegments$okio()).length + n4];
            int n9 = n6 + n7;
            boolean bl3 = false;
            int n10 = Math.min(n3, n9) - n5;
            n9 = n8 + (n5 - n6);
            int n11 = n10;
            int n12 = n9;
            byte[] byArray = segmentedByteString2.getSegments$okio()[n4];
            boolean bl4 = false;
            Segment segment = new Segment(byArray, n12, n12 + n11, true, false);
            if (buffer.head == null) {
                buffer.head = segment.next = (segment.prev = segment);
            } else {
                Segment segment2 = buffer.head;
                Intrinsics.checkNotNull(segment2);
                Segment segment3 = segment2.prev;
                Intrinsics.checkNotNull(segment3);
                segment3.push(segment);
            }
            n5 += n10;
            ++n4;
        }
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + (long)segmentedByteString.size());
    }

    @Override
    public boolean rangeEquals(int n, @NotNull ByteString byteString, int n2, int n3) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(byteString, "other");
            SegmentedByteString segmentedByteString = this;
            boolean bl2 = false;
            if (n < 0 || n > segmentedByteString.size() - n3) {
                bl = false;
            } else {
                int n4 = n2;
                SegmentedByteString segmentedByteString2 = segmentedByteString;
                int n5 = n + n3;
                boolean bl3 = false;
                int n6 = SegmentedByteStringKt.segment(segmentedByteString2, n);
                int n7 = n;
                while (n7 < n5) {
                    int n8 = n6 == 0 ? 0 : segmentedByteString2.getDirectory$okio()[n6 - 1];
                    int n9 = segmentedByteString2.getDirectory$okio()[n6] - n8;
                    int n10 = segmentedByteString2.getDirectory$okio()[((Object[])segmentedByteString2.getSegments$okio()).length + n6];
                    int n11 = n8 + n9;
                    boolean bl4 = false;
                    int n12 = Math.min(n5, n11) - n7;
                    n11 = n10 + (n7 - n8);
                    int n13 = n12;
                    int n14 = n11;
                    byte[] byArray = segmentedByteString2.getSegments$okio()[n6];
                    boolean bl5 = false;
                    if (!byteString.rangeEquals(n4, byArray, n14, n13)) {
                        bl = false;
                        break block4;
                    }
                    n4 += n13;
                    n7 += n12;
                    ++n6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean rangeEquals(int n, @NotNull byte[] byArray, int n2, int n3) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(byArray, "other");
            SegmentedByteString segmentedByteString = this;
            boolean bl2 = false;
            if (n < 0 || n > segmentedByteString.size() - n3 || n2 < 0 || n2 > byArray.length - n3) {
                bl = false;
            } else {
                int n4 = n2;
                SegmentedByteString segmentedByteString2 = segmentedByteString;
                int n5 = n + n3;
                boolean bl3 = false;
                int n6 = SegmentedByteStringKt.segment(segmentedByteString2, n);
                int n7 = n;
                while (n7 < n5) {
                    int n8 = n6 == 0 ? 0 : segmentedByteString2.getDirectory$okio()[n6 - 1];
                    int n9 = segmentedByteString2.getDirectory$okio()[n6] - n8;
                    int n10 = segmentedByteString2.getDirectory$okio()[((Object[])segmentedByteString2.getSegments$okio()).length + n6];
                    int n11 = n8 + n9;
                    boolean bl4 = false;
                    int n12 = Math.min(n5, n11) - n7;
                    n11 = n10 + (n7 - n8);
                    int n13 = n12;
                    int n14 = n11;
                    byte[] byArray2 = segmentedByteString2.getSegments$okio()[n6];
                    boolean bl5 = false;
                    if (!-Util.arrayRangeEquals(byArray2, n14, byArray, n4, n13)) {
                        bl = false;
                        break block4;
                    }
                    n4 += n13;
                    n7 += n12;
                    ++n6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public int indexOf(@NotNull byte[] byArray, int n) {
        Intrinsics.checkNotNullParameter(byArray, "other");
        return this.toByteString().indexOf(byArray, n);
    }

    @Override
    public int lastIndexOf(@NotNull byte[] byArray, int n) {
        Intrinsics.checkNotNullParameter(byArray, "other");
        return this.toByteString().lastIndexOf(byArray, n);
    }

    private final ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    @Override
    @NotNull
    public byte[] internalArray$okio() {
        return this.toByteArray();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        SegmentedByteString segmentedByteString = this;
        boolean bl = false;
        return object == segmentedByteString ? true : (object instanceof ByteString ? ((ByteString)object).size() == segmentedByteString.size() && segmentedByteString.rangeEquals(0, (ByteString)object, 0, segmentedByteString.size()) : false);
    }

    @Override
    public int hashCode() {
        int n;
        SegmentedByteString segmentedByteString = this;
        boolean bl = false;
        int n2 = segmentedByteString.getHashCode$okio();
        if (n2 != 0) {
            n = n2;
        } else {
            n2 = 1;
            SegmentedByteString segmentedByteString2 = segmentedByteString;
            boolean bl2 = false;
            int n3 = ((Object[])segmentedByteString2.getSegments$okio()).length;
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                int n5 = segmentedByteString2.getDirectory$okio()[n3 + i];
                int n6 = segmentedByteString2.getDirectory$okio()[i];
                int n7 = n6 - n4;
                int n8 = n5;
                byte[] byArray = segmentedByteString2.getSegments$okio()[i];
                boolean bl3 = false;
                int n9 = n8 + n7;
                for (int j = n8; j < n9; ++j) {
                    n2 = 31 * n2 + byArray[j];
                }
                n4 = n6;
            }
            segmentedByteString.setHashCode$okio(n2);
            n = n2;
        }
        return n;
    }

    @Override
    @NotNull
    public String toString() {
        return this.toByteString().toString();
    }

    private final Object writeReplace() {
        ByteString byteString = this.toByteString();
        if (byteString == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Object");
        }
        return byteString;
    }

    @NotNull
    public final byte[][] getSegments$okio() {
        return this.segments;
    }

    @NotNull
    public final int[] getDirectory$okio() {
        return this.directory;
    }

    public SegmentedByteString(@NotNull byte[][] byArray, @NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter(byArray, "segments");
        Intrinsics.checkNotNullParameter(nArray, "directory");
        super(ByteString.EMPTY.getData$okio());
        this.segments = byArray;
        this.directory = nArray;
    }
}

