/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.tls.TrustRootIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lokhttp3/internal/tls/BasicTrustRootIndex;", "Lokhttp3/internal/tls/TrustRootIndex;", "caCerts", "", "Ljava/security/cert/X509Certificate;", "([Ljava/security/cert/X509Certificate;)V", "subjectToCaCerts", "", "Ljavax/security/auth/x500/X500Principal;", "", "equals", "", "other", "", "findByIssuerAndSignature", "cert", "hashCode", "", "okhttp"})
public final class BasicTrustRootIndex
implements TrustRootIndex {
    private final Map<X500Principal, Set<X509Certificate>> subjectToCaCerts;

    @Override
    @Nullable
    public X509Certificate findByIssuerAndSignature(@NotNull X509Certificate x509Certificate) {
        Object v2;
        block4: {
            Intrinsics.checkNotNullParameter(x509Certificate, "cert");
            X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
            Set<X509Certificate> set = this.subjectToCaCerts.get(x500Principal);
            if (set == null) {
                return null;
            }
            Set<X509Certificate> set2 = set;
            Iterable iterable = set2;
            boolean bl = false;
            for (Object t2 : iterable) {
                boolean bl2;
                X509Certificate x509Certificate2 = (X509Certificate)t2;
                boolean bl3 = false;
                try {
                    x509Certificate.verify(x509Certificate2.getPublicKey());
                    bl2 = true;
                }
                catch (Exception exception) {
                    bl2 = false;
                }
                if (!bl2) continue;
                v2 = t2;
                break block4;
            }
            v2 = null;
        }
        return v2;
    }

    public boolean equals(@Nullable Object object) {
        return object == this || object instanceof BasicTrustRootIndex && Intrinsics.areEqual(((BasicTrustRootIndex)object).subjectToCaCerts, this.subjectToCaCerts);
    }

    public int hashCode() {
        return ((Object)this.subjectToCaCerts).hashCode();
    }

    public BasicTrustRootIndex(X509Certificate ... x509CertificateArray) {
        Intrinsics.checkNotNullParameter(x509CertificateArray, "caCerts");
        boolean bl = false;
        Map map = new LinkedHashMap();
        for (X509Certificate x509Certificate : x509CertificateArray) {
            Object object;
            X500Principal x500Principal;
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue(x509Certificate.getSubjectX500Principal(), "caCert.subjectX500Principal");
            boolean bl2 = false;
            Object v = map2.get(x500Principal);
            if (v == null) {
                boolean bl3 = false;
                boolean bl4 = false;
                Set set = new LinkedHashSet();
                map2.put(x500Principal, set);
                object = set;
            } else {
                object = v;
            }
            ((Set)object).add(x509Certificate);
        }
        this.subjectToCaCerts = map;
    }
}

