/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.util.Log;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.platform.android.AndroidLogHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lokhttp3/internal/platform/android/AndroidLog;", "", "()V", "MAX_LOG_LENGTH", "", "configuredLoggers", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Ljava/util/logging/Logger;", "knownLoggers", "", "", "androidLog", "", "loggerName", "logLevel", "message", "t", "", "androidLog$okhttp", "enable", "enableLogging", "logger", "tag", "loggerTag", "okhttp"})
@SuppressSignatureCheck
public final class AndroidLog {
    private static final int MAX_LOG_LENGTH = 4000;
    private static final CopyOnWriteArraySet<Logger> configuredLoggers;
    private static final Map<String, String> knownLoggers;
    public static final AndroidLog INSTANCE;

    public final void androidLog$okhttp(@NotNull String string, int n, @NotNull String string2, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter(string, "loggerName");
        Intrinsics.checkNotNullParameter(string2, "message");
        String string3 = this.loggerTag(string);
        if (Log.isLoggable((String)string3, (int)n)) {
            String string4 = string2;
            if (throwable != null) {
                string4 = string4 + "\n" + Log.getStackTraceString((Throwable)throwable);
            }
            int n2 = string4.length();
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4 = StringsKt.indexOf$default((CharSequence)string4, '\n', i, false, 4, null);
                n4 = n4 != -1 ? n4 : n2;
                do {
                    int n5 = i + 4000;
                    boolean bl = false;
                    n3 = Math.min(n4, n5);
                    String string5 = string4;
                    bl = false;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(i, n3);
                    Intrinsics.checkNotNullExpressionValue(string7, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Log.println((int)n, (String)string3, (String)string7);
                } while ((i = n3) < n4);
            }
        }
    }

    private final String loggerTag(String string) {
        String string2 = knownLoggers.get(string);
        if (string2 == null) {
            string2 = StringsKt.take(string, 23);
        }
        return string2;
    }

    public final void enable() {
        Object object = knownLoggers;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            String string = entry2.getValue();
            this.enableLogging((String)object, string);
        }
    }

    private final void enableLogging(String string, String string2) {
        Logger logger = Logger.getLogger(string);
        if (configuredLoggers.add(logger)) {
            Logger logger2 = logger;
            Intrinsics.checkNotNullExpressionValue(logger2, "logger");
            logger2.setUseParentHandlers(false);
            logger.setLevel(Log.isLoggable((String)string2, (int)3) ? Level.FINE : (Log.isLoggable((String)string2, (int)4) ? Level.INFO : Level.WARNING));
            logger.addHandler(AndroidLogHandler.INSTANCE);
        }
    }

    private AndroidLog() {
    }

    static {
        String string;
        AndroidLog androidLog;
        INSTANCE = androidLog = new AndroidLog();
        configuredLoggers = new CopyOnWriteArraySet();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        boolean bl = false;
        boolean bl2 = false;
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        boolean bl3 = false;
        Package package_ = OkHttpClient.class.getPackage();
        String string2 = string = package_ != null ? package_.getName() : null;
        if (string != null) {
            ((Map)linkedHashMap2).put(string, "OkHttp");
        }
        Map map = linkedHashMap2;
        String string3 = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "OkHttpClient::class.java.name");
        map.put(string3, "okhttp.OkHttpClient");
        Map map2 = linkedHashMap2;
        String string4 = Http2.class.getName();
        Intrinsics.checkNotNullExpressionValue(string4, "Http2::class.java.name");
        map2.put(string4, "okhttp.Http2");
        Map map3 = linkedHashMap2;
        String string5 = TaskRunner.class.getName();
        Intrinsics.checkNotNullExpressionValue(string5, "TaskRunner::class.java.name");
        map3.put(string5, "okhttp.TaskRunner");
        ((Map)linkedHashMap2).put("okhttp3.mockwebserver.MockWebServer", "okhttp.MockWebServer");
        knownLoggers = MapsKt.toMap(linkedHashMap);
    }
}

