/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u0099\u00012\u00020\u0001:\b\u0098\u0001\u0099\u0001\u009a\u0001\u009b\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010P\u001a\u00020QJ\b\u0010R\u001a\u00020QH\u0016J'\u0010R\u001a\u00020Q2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020T2\b\u0010V\u001a\u0004\u0018\u00010WH\u0000\u00a2\u0006\u0002\bXJ\u0012\u0010Y\u001a\u00020Q2\b\u0010Z\u001a\u0004\u0018\u00010WH\u0002J\u0006\u0010[\u001a\u00020QJ\u0010\u0010\\\u001a\u0004\u0018\u00010B2\u0006\u0010]\u001a\u00020\u0012J\u000e\u0010^\u001a\u00020\t2\u0006\u0010_\u001a\u00020\u0006J&\u0010`\u001a\u00020B2\u0006\u0010a\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\tH\u0002J\u001c\u0010`\u001a\u00020B2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\tJ\u0006\u0010f\u001a\u00020\u0012J-\u0010g\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020\u00122\u0006\u0010l\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bmJ+\u0010n\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010l\u001a\u00020\tH\u0000\u00a2\u0006\u0002\boJ#\u0010p\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0cH\u0000\u00a2\u0006\u0002\bqJ\u001d\u0010r\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010s\u001a\u00020TH\u0000\u00a2\u0006\u0002\btJ$\u0010u\u001a\u00020B2\u0006\u0010a\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\tJ\u0015\u0010v\u001a\u00020\t2\u0006\u0010h\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\bwJ\u0017\u0010x\u001a\u0004\u0018\u00010B2\u0006\u0010h\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\byJ\r\u0010z\u001a\u00020QH\u0000\u00a2\u0006\u0002\b{J\u000e\u0010|\u001a\u00020Q2\u0006\u0010}\u001a\u00020&J\u000e\u0010~\u001a\u00020Q2\u0006\u0010\u007f\u001a\u00020TJ\u001e\u0010\u0080\u0001\u001a\u00020Q2\t\b\u0002\u0010\u0081\u0001\u001a\u00020\t2\b\b\u0002\u0010E\u001a\u00020FH\u0007J\u0018\u0010\u0082\u0001\u001a\u00020Q2\u0007\u0010\u0083\u0001\u001a\u00020\u0006H\u0000\u00a2\u0006\u0003\b\u0084\u0001J,\u0010\u0085\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0007\u0010\u0086\u0001\u001a\u00020\t2\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\u0006\u0010k\u001a\u00020\u0006J/\u0010\u0089\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0007\u0010\u0086\u0001\u001a\u00020\t2\r\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020d0cH\u0000\u00a2\u0006\u0003\b\u008b\u0001J\u0007\u0010\u008c\u0001\u001a\u00020QJ\"\u0010\u008c\u0001\u001a\u00020Q2\u0007\u0010\u008d\u0001\u001a\u00020\t2\u0007\u0010\u008e\u0001\u001a\u00020\u00122\u0007\u0010\u008f\u0001\u001a\u00020\u0012J\u0007\u0010\u0090\u0001\u001a\u00020QJ\u001f\u0010\u0091\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010\u007f\u001a\u00020TH\u0000\u00a2\u0006\u0003\b\u0092\u0001J\u001f\u0010\u0093\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010s\u001a\u00020TH\u0000\u00a2\u0006\u0003\b\u0094\u0001J \u0010\u0095\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0007\u0010\u0096\u0001\u001a\u00020\u0006H\u0000\u00a2\u0006\u0003\b\u0097\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001b\"\u0004\b$\u0010\u001dR\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010(\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001e\u00105\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00104R\u0015\u00107\u001a\u000608R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u000e\u0010;\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\u00020=X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R \u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020B0AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010G\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u00104R\u001e\u0010I\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u00104R\u0011\u0010K\u001a\u00020L\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u000e\u0010O\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009c\u0001"}, d2={"Lokhttp3/internal/http2/Http2Connection;", "Ljava/io/Closeable;", "builder", "Lokhttp3/internal/http2/Http2Connection$Builder;", "(Lokhttp3/internal/http2/Http2Connection$Builder;)V", "awaitPingsSent", "", "awaitPongsReceived", "client", "", "getClient$okhttp", "()Z", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "currentPushRequests", "", "", "degradedPingsSent", "degradedPongDeadlineNs", "degradedPongsReceived", "intervalPingsSent", "intervalPongsReceived", "isShutdown", "lastGoodStreamId", "getLastGoodStreamId$okhttp", "()I", "setLastGoodStreamId$okhttp", "(I)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "nextStreamId", "getNextStreamId$okhttp", "setNextStreamId$okhttp", "okHttpSettings", "Lokhttp3/internal/http2/Settings;", "getOkHttpSettings", "()Lokhttp3/internal/http2/Settings;", "peerSettings", "getPeerSettings", "setPeerSettings", "(Lokhttp3/internal/http2/Settings;)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "pushQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "<set-?>", "readBytesAcknowledged", "getReadBytesAcknowledged", "()J", "readBytesTotal", "getReadBytesTotal", "readerRunnable", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "getReaderRunnable", "()Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "settingsListenerQueue", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "streams", "", "Lokhttp3/internal/http2/Http2Stream;", "getStreams$okhttp", "()Ljava/util/Map;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "writeBytesMaximum", "getWriteBytesMaximum", "writeBytesTotal", "getWriteBytesTotal", "writer", "Lokhttp3/internal/http2/Http2Writer;", "getWriter", "()Lokhttp3/internal/http2/Http2Writer;", "writerQueue", "awaitPong", "", "close", "connectionCode", "Lokhttp3/internal/http2/ErrorCode;", "streamCode", "cause", "Ljava/io/IOException;", "close$okhttp", "failConnection", "e", "flush", "getStream", "id", "isHealthy", "nowNs", "newStream", "associatedStreamId", "requestHeaders", "", "Lokhttp3/internal/http2/Header;", "out", "openStreamCount", "pushDataLater", "streamId", "source", "Lokio/BufferedSource;", "byteCount", "inFinished", "pushDataLater$okhttp", "pushHeadersLater", "pushHeadersLater$okhttp", "pushRequestLater", "pushRequestLater$okhttp", "pushResetLater", "errorCode", "pushResetLater$okhttp", "pushStream", "pushedStream", "pushedStream$okhttp", "removeStream", "removeStream$okhttp", "sendDegradedPingLater", "sendDegradedPingLater$okhttp", "setSettings", "settings", "shutdown", "statusCode", "start", "sendConnectionPreface", "updateConnectionFlowControl", "read", "updateConnectionFlowControl$okhttp", "writeData", "outFinished", "buffer", "Lokio/Buffer;", "writeHeaders", "alternating", "writeHeaders$okhttp", "writePing", "reply", "payload1", "payload2", "writePingAndAwaitPong", "writeSynReset", "writeSynReset$okhttp", "writeSynResetLater", "writeSynResetLater$okhttp", "writeWindowUpdateLater", "unacknowledgedBytesRead", "writeWindowUpdateLater$okhttp", "Builder", "Companion", "Listener", "ReaderRunnable", "okhttp"})
public final class Http2Connection
implements Closeable {
    private final boolean client;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Map<Integer, Http2Stream> streams;
    @NotNull
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    private final TaskRunner taskRunner;
    private final TaskQueue writerQueue;
    private final TaskQueue pushQueue;
    private final TaskQueue settingsListenerQueue;
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPingsSent;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    @NotNull
    private final Settings okHttpSettings;
    @NotNull
    private Settings peerSettings;
    private long readBytesTotal;
    private long readBytesAcknowledged;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    @NotNull
    private final Socket socket;
    @NotNull
    private final Http2Writer writer;
    @NotNull
    private final ReaderRunnable readerRunnable;
    private final Set<Integer> currentPushRequests;
    public static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    @NotNull
    private static final Settings DEFAULT_SETTINGS;
    public static final int INTERVAL_PING = 1;
    public static final int DEGRADED_PING = 2;
    public static final int AWAIT_PING = 3;
    public static final int DEGRADED_PONG_TIMEOUT_NS = 1000000000;
    public static final Companion Companion;

    public final boolean getClient$okhttp() {
        return this.client;
    }

    @NotNull
    public final Listener getListener$okhttp() {
        return this.listener;
    }

    @NotNull
    public final Map<Integer, Http2Stream> getStreams$okhttp() {
        return this.streams;
    }

    @NotNull
    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    public final void setLastGoodStreamId$okhttp(int n) {
        this.lastGoodStreamId = n;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    public final void setNextStreamId$okhttp(int n) {
        this.nextStreamId = n;
    }

    @NotNull
    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    @NotNull
    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    public final void setPeerSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "<set-?>");
        this.peerSettings = settings;
    }

    public final long getReadBytesTotal() {
        return this.readBytesTotal;
    }

    public final long getReadBytesAcknowledged() {
        return this.readBytesAcknowledged;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    @NotNull
    public final Socket getSocket$okhttp() {
        return this.socket;
    }

    @NotNull
    public final Http2Writer getWriter() {
        return this.writer;
    }

    @NotNull
    public final ReaderRunnable getReaderRunnable() {
        return this.readerRunnable;
    }

    public final synchronized int openStreamCount() {
        return this.streams.size();
    }

    @Nullable
    public final synchronized Http2Stream getStream(int n) {
        return this.streams.get(n);
    }

    @Nullable
    public final synchronized Http2Stream removeStream$okhttp(int n) {
        Http2Stream http2Stream = this.streams.remove(n);
        Http2Connection http2Connection = this;
        boolean bl = false;
        Http2Connection http2Connection2 = http2Connection;
        if (http2Connection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Object");
        }
        ((Object)http2Connection2).notifyAll();
        return http2Stream;
    }

    public final synchronized void updateConnectionFlowControl$okhttp(long l) {
        this.readBytesTotal += l;
        long l2 = this.readBytesTotal - this.readBytesAcknowledged;
        if (l2 >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            this.writeWindowUpdateLater$okhttp(0, l2);
            this.readBytesAcknowledged += l2;
        }
    }

    @NotNull
    public final Http2Stream pushStream(int n, @NotNull List<Header> list, boolean bl) throws IOException {
        Intrinsics.checkNotNullParameter(list, "requestHeaders");
        boolean bl2 = !this.client;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Client cannot push requests.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.newStream(n, list, bl);
    }

    @NotNull
    public final Http2Stream newStream(@NotNull List<Header> list, boolean bl) throws IOException {
        Intrinsics.checkNotNullParameter(list, "requestHeaders");
        return this.newStream(0, list, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Http2Stream newStream(int n, List<Header> list, boolean bl) throws IOException {
        boolean bl2 = !bl;
        boolean bl3 = false;
        boolean bl4 = false;
        Http2Stream http2Stream = null;
        int n2 = 0;
        Http2Writer http2Writer = this.writer;
        boolean bl5 = false;
        boolean bl6 = false;
        synchronized (http2Writer) {
            boolean bl7;
            boolean bl8 = false;
            Http2Connection http2Connection = this;
            boolean bl9 = false;
            boolean bl10 = false;
            synchronized (http2Connection) {
                bl7 = false;
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw (Throwable)new ConnectionShutdownException();
                }
                n2 = this.nextStreamId;
                this.nextStreamId += 2;
                http2Stream = new Http2Stream(n2, this, bl2, bl3, null);
                boolean bl11 = bl4 = !bl || this.writeBytesTotal >= this.writeBytesMaximum || http2Stream.getWriteBytesTotal() >= http2Stream.getWriteBytesMaximum();
                if (http2Stream.isOpen()) {
                    this.streams.put(n2, http2Stream);
                }
                Unit unit = Unit.INSTANCE;
            }
            if (n == 0) {
                this.writer.headers(bl2, n2, list);
            } else {
                boolean bl12 = !this.client;
                bl9 = false;
                boolean bl13 = false;
                if (!bl12) {
                    bl7 = false;
                    String string = "client streams shouldn't have associated stream IDs";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                this.writer.pushPromise(n, n2, list);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bl4) {
            this.writer.flush();
        }
        return http2Stream;
    }

    public final void writeHeaders$okhttp(int n, boolean bl, @NotNull List<Header> list) throws IOException {
        Intrinsics.checkNotNullParameter(list, "alternating");
        this.writer.headers(bl, n, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(int n, boolean bl, @Nullable Buffer buffer, long l) throws IOException {
        if (l == 0L) {
            this.writer.data(bl, n, buffer, 0);
            return;
        }
        long l2 = l;
        while (l2 > 0L) {
            int n2 = 0;
            Http2Connection http2Connection = this;
            boolean bl2 = false;
            boolean bl3 = false;
            synchronized (http2Connection) {
                int n3;
                boolean bl4 = false;
                try {
                    while (this.writeBytesTotal >= this.writeBytesMaximum) {
                        if (!this.streams.containsKey(n)) {
                            throw (Throwable)new IOException("stream closed");
                        }
                        Http2Connection http2Connection2 = this;
                        n3 = 0;
                        Http2Connection http2Connection3 = http2Connection2;
                        if (http2Connection3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.Object");
                        }
                        ((Object)http2Connection3).wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw (Throwable)new InterruptedIOException();
                }
                long l3 = l2;
                long l4 = this.writeBytesMaximum - this.writeBytesTotal;
                boolean bl5 = false;
                int n4 = n2 = (int)Math.min(l3, l4);
                n3 = this.writer.maxDataLength();
                boolean bl6 = false;
                n2 = Math.min(n4, n3);
                this.writeBytesTotal += (long)n2;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.data(bl && (l2 -= (long)n2) == 0L, n, buffer, n2);
        }
    }

    public final void writeSynResetLater$okhttp(int n, @NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        TaskQueue taskQueue = this.writerQueue;
        String string = this.connectionName + '[' + n + "] writeSynReset";
        long l = 0L;
        boolean bl = true;
        boolean bl2 = false;
        taskQueue.schedule(new Task(string, bl, string, bl, this, n, errorCode){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                this.$name = string;
                this.$cancelable = bl;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super(string2, bl2);
            }

            public long runOnce() {
                boolean bl = false;
                try {
                    this.this$0.writeSynReset$okhttp(this.$streamId$inlined, this.$errorCode$inlined);
                }
                catch (IOException iOException) {
                    Http2Connection.access$failConnection(this.this$0, iOException);
                }
                return -1L;
            }
        }, l);
    }

    public final void writeSynReset$okhttp(int n, @NotNull ErrorCode errorCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)errorCode, "statusCode");
        this.writer.rstStream(n, errorCode);
    }

    public final void writeWindowUpdateLater$okhttp(int n, long l) {
        TaskQueue taskQueue = this.writerQueue;
        String string = this.connectionName + '[' + n + "] windowUpdate";
        long l2 = 0L;
        boolean bl = true;
        boolean bl2 = false;
        taskQueue.schedule(new Task(string, bl, string, bl, this, n, l){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ long $unacknowledgedBytesRead$inlined;
            {
                this.$name = string;
                this.$cancelable = bl;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$unacknowledgedBytesRead$inlined = l;
                super(string2, bl2);
            }

            public long runOnce() {
                boolean bl = false;
                try {
                    this.this$0.getWriter().windowUpdate(this.$streamId$inlined, this.$unacknowledgedBytesRead$inlined);
                }
                catch (IOException iOException) {
                    Http2Connection.access$failConnection(this.this$0, iOException);
                }
                return -1L;
            }
        }, l2);
    }

    public final void writePing(boolean bl, int n, int n2) {
        try {
            this.writer.ping(bl, n, n2);
        }
        catch (IOException iOException) {
            this.failConnection(iOException);
        }
    }

    public final void writePingAndAwaitPong() throws InterruptedException {
        this.writePing();
        this.awaitPong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writePing() throws InterruptedException {
        Http2Connection http2Connection = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (http2Connection) {
            boolean bl3 = false;
            long l = this.awaitPingsSent;
            this.awaitPingsSent = l + 1L;
            long l2 = l;
        }
        this.writePing(false, 3, 1330343787);
    }

    public final synchronized void awaitPong() throws InterruptedException {
        while (this.awaitPongsReceived < this.awaitPingsSent) {
            Http2Connection http2Connection = this;
            boolean bl = false;
            Http2Connection http2Connection2 = http2Connection;
            if (http2Connection2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Object");
            }
            ((Object)http2Connection2).wait();
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(@NotNull ErrorCode errorCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)errorCode, "statusCode");
        Http2Writer http2Writer = this.writer;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (http2Writer) {
            boolean bl3 = false;
            int n = 0;
            Http2Connection http2Connection = this;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (http2Connection) {
                boolean bl6 = false;
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                n = this.lastGoodStreamId;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.goAway(n, errorCode, Util.EMPTY_BYTE_ARRAY);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close$okhttp(@NotNull ErrorCode errorCode, @NotNull ErrorCode errorCode2, @Nullable IOException iOException) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)errorCode, "connectionCode");
        Intrinsics.checkNotNullParameter((Object)errorCode2, "streamCode");
        Http2Stream[] http2StreamArray = this;
        boolean bl = false;
        if (Util.assertionsEnabled && Thread.holdsLock(http2StreamArray)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST NOT hold lock on ").append(http2StreamArray).toString()));
        }
        boolean bl2 = false;
        try {
            bl = false;
            this.shutdown(errorCode);
        }
        catch (IOException iOException2) {
        }
        Http2Stream[] http2StreamArray2 = null;
        Http2Stream[] http2StreamArray3 = this;
        boolean bl3 = false;
        boolean bl4 = false;
        synchronized (http2StreamArray3) {
            int n = 0;
            Object object2 = this.streams;
            boolean bl5 = false;
            if (!object2.isEmpty()) {
                object2 = this.streams.values();
                bl5 = false;
                object = object2;
                Http2Stream[] http2StreamArray4 = object.toArray(new Http2Stream[0]);
                if (http2StreamArray4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                http2StreamArray2 = http2StreamArray4;
                this.streams.clear();
            }
            Http2Stream[] http2StreamArray5 = Unit.INSTANCE;
        }
        if (http2StreamArray2 != null) {
            http2StreamArray3 = http2StreamArray2;
            bl3 = false;
            for (Http2Stream http2Stream : http2StreamArray3) {
                object = http2Stream;
                boolean bl6 = false;
                boolean bl7 = false;
                try {
                    boolean bl8 = false;
                    ((Http2Stream)object).close(errorCode2, iOException);
                }
                catch (IOException iOException3) {
                }
            }
        }
        boolean bl9 = false;
        try {
            bl3 = false;
            this.writer.close();
        }
        catch (IOException iOException4) {
        }
        bl9 = false;
        try {
            bl3 = false;
            this.socket.close();
        }
        catch (IOException iOException5) {
        }
        this.writerQueue.shutdown();
        this.pushQueue.shutdown();
        this.settingsListenerQueue.shutdown();
    }

    private final void failConnection(IOException iOException) {
        this.close$okhttp(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR, iOException);
    }

    @JvmOverloads
    public final void start(boolean bl, @NotNull TaskRunner taskRunner) throws IOException {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        if (bl) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int n = this.okHttpSettings.getInitialWindowSize();
            if (n != 65535) {
                this.writer.windowUpdate(0, n - 65535);
            }
        }
        TaskQueue taskQueue = taskRunner.newQueue();
        String string = this.connectionName;
        Function0 function0 = this.readerRunnable;
        long l = 0L;
        boolean bl2 = true;
        boolean bl3 = false;
        taskQueue.schedule(new Task(function0, string, bl2, string, bl2){
            final /* synthetic */ Function0 $block;
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;

            public long runOnce() {
                this.$block.invoke();
                return -1L;
            }
            {
                this.$block = function0;
                this.$name = string;
                this.$cancelable = bl;
                super(string2, bl2);
            }
        }, l);
    }

    public static /* synthetic */ void start$default(Http2Connection http2Connection, boolean bl, TaskRunner taskRunner, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            taskRunner = TaskRunner.INSTANCE;
        }
        http2Connection.start(bl, taskRunner);
    }

    @JvmOverloads
    public final void start(boolean bl) throws IOException {
        Http2Connection.start$default(this, bl, null, 2, null);
    }

    @JvmOverloads
    public final void start() throws IOException {
        Http2Connection.start$default(this, false, null, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSettings(@NotNull Settings settings) throws IOException {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Http2Writer http2Writer = this.writer;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (http2Writer) {
            boolean bl3 = false;
            Http2Connection http2Connection = this;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (http2Connection) {
                boolean bl6 = false;
                if (this.isShutdown) {
                    throw (Throwable)new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
                Unit unit = Unit.INSTANCE;
            }
            this.writer.settings(settings);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final synchronized boolean isHealthy(long l) {
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || l < this.degradedPongDeadlineNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendDegradedPingLater$okhttp() {
        Object object = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            long l = this.degradedPingsSent;
            this.degradedPingsSent = l + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + (long)1000000000;
            Unit unit = Unit.INSTANCE;
        }
        object = this.writerQueue;
        String string = this.connectionName + " ping";
        long l = 0L;
        boolean bl4 = true;
        boolean bl5 = false;
        ((TaskQueue)object).schedule(new Task(string, bl4, string, bl4, this){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            {
                this.$name = string;
                this.$cancelable = bl;
                this.this$0 = http2Connection;
                super(string2, bl2);
            }

            public long runOnce() {
                boolean bl = false;
                this.this$0.writePing(false, 2, 0);
                return -1L;
            }
        }, l);
    }

    public final boolean pushedStream$okhttp(int n) {
        return n != 0 && (n & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushRequestLater$okhttp(int n, @NotNull List<Header> list) {
        Intrinsics.checkNotNullParameter(list, "requestHeaders");
        Object object = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.currentPushRequests.contains(n)) {
                this.writeSynResetLater$okhttp(n, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            bl2 = this.currentPushRequests.add(n);
        }
        object = this.pushQueue;
        String string = this.connectionName + '[' + n + "] onRequest";
        long l = 0L;
        boolean bl4 = true;
        boolean bl5 = false;
        ((TaskQueue)object).schedule(new Task(string, bl4, string, bl4, this, n, list){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            {
                this.$name = string;
                this.$cancelable = bl;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                super(string2, bl2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                block5: {
                    boolean bl = false;
                    boolean bl2 = Http2Connection.access$getPushObserver$p(this.this$0).onRequest(this.$streamId$inlined, this.$requestHeaders$inlined);
                    boolean bl3 = false;
                    try {
                        boolean bl4 = false;
                        if (!bl2) break block5;
                        this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        Http2Connection http2Connection = this.this$0;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        synchronized (http2Connection) {
                            boolean bl7 = false;
                            bl6 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return -1L;
            }
        }, l);
    }

    public final void pushHeadersLater$okhttp(int n, @NotNull List<Header> list, boolean bl) {
        Intrinsics.checkNotNullParameter(list, "requestHeaders");
        TaskQueue taskQueue = this.pushQueue;
        String string = this.connectionName + '[' + n + "] onHeaders";
        long l = 0L;
        boolean bl2 = true;
        boolean bl3 = false;
        taskQueue.schedule(new Task(string, bl2, string, bl2, this, n, list, bl){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                this.$name = string;
                this.$cancelable = bl;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                this.$inFinished$inlined = bl3;
                super(string2, bl2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                block6: {
                    boolean bl = false;
                    boolean bl2 = Http2Connection.access$getPushObserver$p(this.this$0).onHeaders(this.$streamId$inlined, this.$requestHeaders$inlined, this.$inFinished$inlined);
                    boolean bl3 = false;
                    try {
                        boolean bl4 = false;
                        if (bl2) {
                            this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        }
                        if (!bl2 && !this.$inFinished$inlined) break block6;
                        Http2Connection http2Connection = this.this$0;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        synchronized (http2Connection) {
                            boolean bl7 = false;
                            bl6 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return -1L;
            }
        }, l);
    }

    public final void pushDataLater$okhttp(int n, @NotNull BufferedSource bufferedSource, int n2, boolean bl) throws IOException {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Buffer buffer = new Buffer();
        bufferedSource.require(n2);
        bufferedSource.read(buffer, n2);
        TaskQueue taskQueue = this.pushQueue;
        String string = this.connectionName + '[' + n + "] onData";
        long l = 0L;
        boolean bl2 = true;
        boolean bl3 = false;
        taskQueue.schedule(new Task(string, bl2, string, bl2, this, n, buffer, n2, bl){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ Buffer $buffer$inlined;
            final /* synthetic */ int $byteCount$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                this.$name = string;
                this.$cancelable = bl;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$buffer$inlined = buffer;
                this.$byteCount$inlined = n2;
                this.$inFinished$inlined = bl3;
                super(string2, bl2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                block6: {
                    boolean bl = false;
                    boolean bl2 = false;
                    try {
                        boolean bl3 = false;
                        boolean bl4 = Http2Connection.access$getPushObserver$p(this.this$0).onData(this.$streamId$inlined, this.$buffer$inlined, this.$byteCount$inlined, this.$inFinished$inlined);
                        if (bl4) {
                            this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        }
                        if (!bl4 && !this.$inFinished$inlined) break block6;
                        Http2Connection http2Connection = this.this$0;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        synchronized (http2Connection) {
                            boolean bl7 = false;
                            bl6 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return -1L;
            }
        }, l);
    }

    public final void pushResetLater$okhttp(int n, @NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        TaskQueue taskQueue = this.pushQueue;
        String string = this.connectionName + '[' + n + "] onReset";
        long l = 0L;
        boolean bl = true;
        boolean bl2 = false;
        taskQueue.schedule(new Task(string, bl, string, bl, this, n, errorCode){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                this.$name = string;
                this.$cancelable = bl;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super(string2, bl2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                boolean bl = false;
                Http2Connection.access$getPushObserver$p(this.this$0).onReset(this.$streamId$inlined, this.$errorCode$inlined);
                Http2Connection http2Connection = this.this$0;
                boolean bl2 = false;
                boolean bl3 = false;
                synchronized (http2Connection) {
                    boolean bl4 = false;
                    Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                    Unit unit = Unit.INSTANCE;
                }
                return -1L;
            }
        }, l);
    }

    public Http2Connection(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.client = builder.getClient$okhttp();
        this.listener = builder.getListener$okhttp();
        boolean bl = false;
        this.streams = new LinkedHashMap();
        this.connectionName = builder.getConnectionName$okhttp();
        this.nextStreamId = builder.getClient$okhttp() ? 3 : 2;
        this.taskRunner = builder.getTaskRunner$okhttp();
        this.writerQueue = this.taskRunner.newQueue();
        this.pushQueue = this.taskRunner.newQueue();
        this.settingsListenerQueue = this.taskRunner.newQueue();
        this.pushObserver = builder.getPushObserver$okhttp();
        Settings settings = new Settings();
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = settings;
        Http2Connection http2Connection = this;
        boolean bl4 = false;
        if (builder.getClient$okhttp()) {
            ((Settings)object).set(7, 0x1000000);
        }
        Unit unit = Unit.INSTANCE;
        http2Connection.okHttpSettings = settings;
        this.peerSettings = DEFAULT_SETTINGS;
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        this.socket = builder.getSocket$okhttp();
        this.writer = new Http2Writer(builder.getSink$okhttp(), this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.getSource$okhttp(), this.client));
        boolean bl5 = false;
        this.currentPushRequests = new LinkedHashSet();
        if (builder.getPingIntervalMillis$okhttp() != 0) {
            long l = TimeUnit.MILLISECONDS.toNanos(builder.getPingIntervalMillis$okhttp());
            TaskQueue taskQueue = this.writerQueue;
            object = this.connectionName + " ping";
            bl4 = false;
            taskQueue.schedule(new Task((String)object, (String)object, this, l){
                final /* synthetic */ String $name;
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ long $pingIntervalNanos$inlined;
                {
                    this.$name = string;
                    this.this$0 = http2Connection;
                    this.$pingIntervalNanos$inlined = l;
                    super(string2, false, 2, null);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public long runOnce() {
                    long l;
                    boolean bl = false;
                    Http2Connection http2Connection = this.this$0;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    synchronized (http2Connection) {
                        boolean bl4;
                        boolean bl5 = false;
                        if (Http2Connection.access$getIntervalPongsReceived$p(this.this$0) < Http2Connection.access$getIntervalPingsSent$p(this.this$0)) {
                            bl4 = true;
                        } else {
                            Http2Connection http2Connection2 = this.this$0;
                            long l2 = Http2Connection.access$getIntervalPingsSent$p(http2Connection2);
                            Http2Connection.access$setIntervalPingsSent$p(http2Connection2, l2 + 1L);
                            bl4 = false;
                        }
                        bl3 = bl4;
                    }
                    boolean bl6 = bl3;
                    if (bl6) {
                        Http2Connection.access$failConnection(this.this$0, null);
                        l = -1L;
                    } else {
                        this.this$0.writePing(false, 1, 0);
                        l = this.$pingIntervalNanos$inlined;
                    }
                    return l;
                }
            }, l);
        }
    }

    static {
        Companion = new Companion(null);
        Settings settings = new Settings();
        boolean bl = false;
        boolean bl2 = false;
        Settings settings2 = settings;
        boolean bl3 = false;
        settings2.set(7, 65535);
        settings2.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    public static final /* synthetic */ long access$getWriteBytesMaximum$p(Http2Connection http2Connection) {
        return http2Connection.writeBytesMaximum;
    }

    public static final /* synthetic */ PushObserver access$getPushObserver$p(Http2Connection http2Connection) {
        return http2Connection.pushObserver;
    }

    public static final /* synthetic */ Set access$getCurrentPushRequests$p(Http2Connection http2Connection) {
        return http2Connection.currentPushRequests;
    }

    public static final /* synthetic */ long access$getIntervalPingsSent$p(Http2Connection http2Connection) {
        return http2Connection.intervalPingsSent;
    }

    public static final /* synthetic */ void access$setIntervalPingsSent$p(Http2Connection http2Connection, long l) {
        http2Connection.intervalPingsSent = l;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00107\u001a\u000208J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ.\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*2\b\b\u0002\u00109\u001a\u00020\f2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u0010#\u001a\u00020$H\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006:"}, d2={"Lokhttp3/internal/http2/Http2Connection$Builder;", "", "client", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(ZLokhttp3/internal/concurrent/TaskRunner;)V", "getClient$okhttp", "()Z", "setClient$okhttp", "(Z)V", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "setConnectionName$okhttp", "(Ljava/lang/String;)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "setListener$okhttp", "(Lokhttp3/internal/http2/Http2Connection$Listener;)V", "pingIntervalMillis", "", "getPingIntervalMillis$okhttp", "()I", "setPingIntervalMillis$okhttp", "(I)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "getPushObserver$okhttp", "()Lokhttp3/internal/http2/PushObserver;", "setPushObserver$okhttp", "(Lokhttp3/internal/http2/PushObserver;)V", "sink", "Lokio/BufferedSink;", "getSink$okhttp", "()Lokio/BufferedSink;", "setSink$okhttp", "(Lokio/BufferedSink;)V", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "setSocket$okhttp", "(Ljava/net/Socket;)V", "source", "Lokio/BufferedSource;", "getSource$okhttp", "()Lokio/BufferedSource;", "setSource$okhttp", "(Lokio/BufferedSource;)V", "getTaskRunner$okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;", "build", "Lokhttp3/internal/http2/Http2Connection;", "peerName", "okhttp"})
    public static final class Builder {
        @NotNull
        public Socket socket;
        @NotNull
        public String connectionName;
        @NotNull
        public BufferedSource source;
        @NotNull
        public BufferedSink sink;
        @NotNull
        private Listener listener;
        @NotNull
        private PushObserver pushObserver;
        private int pingIntervalMillis;
        private boolean client;
        @NotNull
        private final TaskRunner taskRunner;

        @NotNull
        public final Socket getSocket$okhttp() {
            Socket socket = this.socket;
            if (socket == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
            }
            return socket;
        }

        public final void setSocket$okhttp(@NotNull Socket socket) {
            Intrinsics.checkNotNullParameter(socket, "<set-?>");
            this.socket = socket;
        }

        @NotNull
        public final String getConnectionName$okhttp() {
            String string = this.connectionName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("connectionName");
            }
            return string;
        }

        public final void setConnectionName$okhttp(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.connectionName = string;
        }

        @NotNull
        public final BufferedSource getSource$okhttp() {
            BufferedSource bufferedSource = this.source;
            if (bufferedSource == null) {
                Intrinsics.throwUninitializedPropertyAccessException("source");
            }
            return bufferedSource;
        }

        public final void setSource$okhttp(@NotNull BufferedSource bufferedSource) {
            Intrinsics.checkNotNullParameter(bufferedSource, "<set-?>");
            this.source = bufferedSource;
        }

        @NotNull
        public final BufferedSink getSink$okhttp() {
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink == null) {
                Intrinsics.throwUninitializedPropertyAccessException("sink");
            }
            return bufferedSink;
        }

        public final void setSink$okhttp(@NotNull BufferedSink bufferedSink) {
            Intrinsics.checkNotNullParameter(bufferedSink, "<set-?>");
            this.sink = bufferedSink;
        }

        @NotNull
        public final Listener getListener$okhttp() {
            return this.listener;
        }

        public final void setListener$okhttp(@NotNull Listener listener) {
            Intrinsics.checkNotNullParameter(listener, "<set-?>");
            this.listener = listener;
        }

        @NotNull
        public final PushObserver getPushObserver$okhttp() {
            return this.pushObserver;
        }

        public final void setPushObserver$okhttp(@NotNull PushObserver pushObserver) {
            Intrinsics.checkNotNullParameter(pushObserver, "<set-?>");
            this.pushObserver = pushObserver;
        }

        public final int getPingIntervalMillis$okhttp() {
            return this.pingIntervalMillis;
        }

        public final void setPingIntervalMillis$okhttp(int n) {
            this.pingIntervalMillis = n;
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String string, @NotNull BufferedSource bufferedSource, @NotNull BufferedSink bufferedSink) throws IOException {
            Intrinsics.checkNotNullParameter(socket, "socket");
            Intrinsics.checkNotNullParameter(string, "peerName");
            Intrinsics.checkNotNullParameter(bufferedSource, "source");
            Intrinsics.checkNotNullParameter(bufferedSink, "sink");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            builder2.socket = socket;
            builder2.connectionName = builder2.client ? Util.okHttpName + ' ' + string : "MockWebServer " + string;
            builder2.source = bufferedSource;
            builder2.sink = bufferedSink;
            return builder;
        }

        public static /* synthetic */ Builder socket$default(Builder builder, Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = Util.peerName(socket);
            }
            if ((n & 4) != 0) {
                bufferedSource = Okio.buffer(Okio.source(socket));
            }
            if ((n & 8) != 0) {
                bufferedSink = Okio.buffer(Okio.sink(socket));
            }
            return builder.socket(socket, string, bufferedSource, bufferedSink);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String string, @NotNull BufferedSource bufferedSource) throws IOException {
            return Builder.socket$default(this, socket, string, bufferedSource, null, 8, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String string) throws IOException {
            return Builder.socket$default(this, socket, string, null, null, 12, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket) throws IOException {
            return Builder.socket$default(this, socket, null, null, null, 14, null);
        }

        @NotNull
        public final Builder listener(@NotNull Listener listener) {
            Intrinsics.checkNotNullParameter(listener, "listener");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            builder2.listener = listener;
            return builder;
        }

        @NotNull
        public final Builder pushObserver(@NotNull PushObserver pushObserver) {
            Intrinsics.checkNotNullParameter(pushObserver, "pushObserver");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            builder2.pushObserver = pushObserver;
            return builder;
        }

        @NotNull
        public final Builder pingIntervalMillis(int n) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            builder2.pingIntervalMillis = n;
            return builder;
        }

        @NotNull
        public final Http2Connection build() {
            return new Http2Connection(this);
        }

        public final boolean getClient$okhttp() {
            return this.client;
        }

        public final void setClient$okhttp(boolean bl) {
            this.client = bl;
        }

        @NotNull
        public final TaskRunner getTaskRunner$okhttp() {
            return this.taskRunner;
        }

        public Builder(boolean bl, @NotNull TaskRunner taskRunner) {
            Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
            this.client = bl;
            this.taskRunner = taskRunner;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016J8\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J \u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010H\u0016J.\u0010$\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\t\u0010)\u001a\u00020\u0003H\u0096\u0002J \u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0016J(\u0010.\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0017H\u0016J&\u00102\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00103\u001a\u00020\f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0018\u00105\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00106\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00068"}, d2={"Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "Lokhttp3/internal/http2/Http2Reader$Handler;", "Lkotlin/Function0;", "", "reader", "Lokhttp3/internal/http2/Http2Reader;", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Http2Reader;)V", "getReader$okhttp", "()Lokhttp3/internal/http2/Http2Reader;", "ackSettings", "alternateService", "streamId", "", "origin", "", "protocol", "Lokio/ByteString;", "host", "port", "maxAge", "", "applyAndAckSettings", "clearPrevious", "", "settings", "Lokhttp3/internal/http2/Settings;", "data", "inFinished", "source", "Lokio/BufferedSource;", "length", "goAway", "lastGoodStreamId", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "debugData", "headers", "associatedStreamId", "headerBlock", "", "Lokhttp3/internal/http2/Header;", "invoke", "ping", "ack", "payload1", "payload2", "priority", "streamDependency", "weight", "exclusive", "pushPromise", "promisedStreamId", "requestHeaders", "rstStream", "windowUpdate", "windowSizeIncrement", "okhttp"})
    public final class ReaderRunnable
    implements Function0<Unit>,
    Http2Reader.Handler {
        @NotNull
        private final Http2Reader reader;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke() {
            ErrorCode errorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode errorCode2 = ErrorCode.INTERNAL_ERROR;
            IOException iOException = null;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                errorCode = ErrorCode.NO_ERROR;
                errorCode2 = ErrorCode.CANCEL;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                errorCode = ErrorCode.PROTOCOL_ERROR;
                errorCode2 = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                Http2Connection.this.close$okhttp(errorCode, errorCode2, iOException);
                Util.closeQuietly(this.reader);
            }
        }

        @Override
        public void data(boolean bl, int n, @NotNull BufferedSource bufferedSource, int n2) throws IOException {
            Intrinsics.checkNotNullParameter(bufferedSource, "source");
            if (Http2Connection.this.pushedStream$okhttp(n)) {
                Http2Connection.this.pushDataLater$okhttp(n, bufferedSource, n2, bl);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n);
            if (http2Stream == null) {
                Http2Connection.this.writeSynResetLater$okhttp(n, ErrorCode.PROTOCOL_ERROR);
                Http2Connection.this.updateConnectionFlowControl$okhttp(n2);
                bufferedSource.skip(n2);
                return;
            }
            http2Stream.receiveData(bufferedSource, n2);
            if (bl) {
                http2Stream.receiveHeaders(Util.EMPTY_HEADERS, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean bl, int n, int n2, @NotNull List<Header> list) {
            Intrinsics.checkNotNullParameter(list, "headerBlock");
            if (Http2Connection.this.pushedStream$okhttp(n)) {
                Http2Connection.this.pushHeadersLater$okhttp(n, list, bl);
                return;
            }
            Http2Stream http2Stream = null;
            Http2Connection http2Connection = Http2Connection.this;
            boolean bl2 = false;
            boolean bl3 = false;
            synchronized (http2Connection) {
                boolean bl4 = false;
                http2Stream = Http2Connection.this.getStream(n);
                if (http2Stream == null) {
                    if (Http2Connection.this.isShutdown) {
                        return;
                    }
                    if (n <= Http2Connection.this.getLastGoodStreamId$okhttp()) {
                        return;
                    }
                    if (n % 2 == Http2Connection.this.getNextStreamId$okhttp() % 2) {
                        return;
                    }
                    Headers headers = Util.toHeaders(list);
                    Http2Stream http2Stream2 = new Http2Stream(n, Http2Connection.this, false, bl, headers);
                    Http2Connection.this.setLastGoodStreamId$okhttp(n);
                    Http2Connection.this.getStreams$okhttp().put(n, http2Stream2);
                    TaskQueue taskQueue = Http2Connection.this.taskRunner.newQueue();
                    String string = Http2Connection.this.getConnectionName$okhttp() + '[' + n + "] onStream";
                    long l = 0L;
                    boolean bl5 = true;
                    boolean bl6 = false;
                    taskQueue.schedule(new Task(string, bl5, string, bl5, http2Stream2, this, http2Stream, n, list, bl){
                        final /* synthetic */ String $name;
                        final /* synthetic */ boolean $cancelable;
                        final /* synthetic */ Http2Stream $newStream$inlined;
                        final /* synthetic */ ReaderRunnable this$0;
                        final /* synthetic */ Http2Stream $stream$inlined;
                        final /* synthetic */ int $streamId$inlined;
                        final /* synthetic */ List $headerBlock$inlined;
                        final /* synthetic */ boolean $inFinished$inlined;
                        {
                            this.$name = string;
                            this.$cancelable = bl;
                            this.$newStream$inlined = http2Stream;
                            this.this$0 = readerRunnable;
                            this.$stream$inlined = http2Stream2;
                            this.$streamId$inlined = n;
                            this.$headerBlock$inlined = list;
                            this.$inFinished$inlined = bl3;
                            super(string2, bl2);
                        }

                        public long runOnce() {
                            boolean bl = false;
                            try {
                                this.this$0.Http2Connection.this.getListener$okhttp().onStream(this.$newStream$inlined);
                            }
                            catch (IOException iOException) {
                                Platform.Companion.get().log("Http2Connection.Listener failure for " + this.this$0.Http2Connection.this.getConnectionName$okhttp(), 4, iOException);
                                boolean bl2 = false;
                                try {
                                    boolean bl3 = false;
                                    this.$newStream$inlined.close(ErrorCode.PROTOCOL_ERROR, iOException);
                                }
                                catch (IOException iOException2) {
                                }
                            }
                            return -1L;
                        }
                    }, l);
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            http2Stream.receiveHeaders(Util.toHeaders(list), bl);
        }

        @Override
        public void rstStream(int n, @NotNull ErrorCode errorCode) {
            block1: {
                Http2Stream http2Stream;
                Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
                if (Http2Connection.this.pushedStream$okhttp(n)) {
                    Http2Connection.this.pushResetLater$okhttp(n, errorCode);
                    return;
                }
                Http2Stream http2Stream2 = http2Stream = Http2Connection.this.removeStream$okhttp(n);
                if (http2Stream2 == null) break block1;
                http2Stream2.receiveRstStream(errorCode);
            }
        }

        @Override
        public void settings(boolean bl, @NotNull Settings settings) {
            Intrinsics.checkNotNullParameter(settings, "settings");
            TaskQueue taskQueue = Http2Connection.this.writerQueue;
            String string = Http2Connection.this.getConnectionName$okhttp() + " applyAndAckSettings";
            long l = 0L;
            boolean bl2 = true;
            boolean bl3 = false;
            taskQueue.schedule(new Task(string, bl2, string, bl2, this, bl, settings){
                final /* synthetic */ String $name;
                final /* synthetic */ boolean $cancelable;
                final /* synthetic */ ReaderRunnable this$0;
                final /* synthetic */ boolean $clearPrevious$inlined;
                final /* synthetic */ Settings $settings$inlined;
                {
                    this.$name = string;
                    this.$cancelable = bl;
                    this.this$0 = readerRunnable;
                    this.$clearPrevious$inlined = bl3;
                    this.$settings$inlined = settings;
                    super(string2, bl2);
                }

                public long runOnce() {
                    boolean bl = false;
                    this.this$0.applyAndAckSettings(this.$clearPrevious$inlined, this.$settings$inlined);
                    return -1L;
                }
            }, l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void applyAndAckSettings(boolean bl, @NotNull Settings settings) {
            Intrinsics.checkNotNullParameter(settings, "settings");
            Ref.LongRef longRef = new Ref.LongRef();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            Http2Writer object3 = Http2Connection.this.getWriter();
            int n = 0;
            boolean bl2 = false;
            synchronized (object3) {
                int n2 = 0;
                Http2Connection bl12 = Http2Connection.this;
                boolean unit = false;
                boolean bl3 = false;
                synchronized (bl12) {
                    Http2Stream[] http2StreamArray;
                    Object object;
                    Settings settings2;
                    boolean bl4 = false;
                    Settings settings3 = Http2Connection.this.getPeerSettings();
                    Ref.ObjectRef objectRef3 = objectRef2;
                    if (bl) {
                        settings2 = settings;
                    } else {
                        Settings settings4 = new Settings();
                        boolean bl5 = false;
                        boolean taskQueue = false;
                        object = settings4;
                        Ref.ObjectRef objectRef4 = objectRef3;
                        boolean bl6 = false;
                        ((Settings)object).merge(settings3);
                        ((Settings)object).merge(settings);
                        Unit unit2 = Unit.INSTANCE;
                        objectRef3 = objectRef4;
                        settings2 = settings4;
                    }
                    objectRef3.element = settings2;
                    long l = ((Settings)objectRef2.element).getInitialWindowSize();
                    longRef.element = l - (long)settings3.getInitialWindowSize();
                    if (longRef.element == 0L || Http2Connection.this.getStreams$okhttp().isEmpty()) {
                        http2StreamArray = null;
                    } else {
                        Collection<Http2Stream> collection = Http2Connection.this.getStreams$okhttp().values();
                        boolean bl7 = false;
                        Collection<Http2Stream> collection2 = collection;
                        Http2Stream[] http2StreamArray2 = collection2.toArray(new Http2Stream[0]);
                        if (http2StreamArray2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        http2StreamArray = http2StreamArray2;
                    }
                    objectRef.element = http2StreamArray;
                    Http2Connection.this.setPeerSettings((Settings)objectRef2.element);
                    TaskQueue taskQueue = Http2Connection.this.settingsListenerQueue;
                    object = Http2Connection.this.getConnectionName$okhttp() + " onSettings";
                    long l2 = 0L;
                    boolean bl8 = true;
                    boolean bl9 = false;
                    taskQueue.schedule(new Task((String)object, bl8, (String)object, bl8, this, objectRef2, bl, settings, longRef, objectRef){
                        final /* synthetic */ String $name;
                        final /* synthetic */ boolean $cancelable;
                        final /* synthetic */ ReaderRunnable this$0;
                        final /* synthetic */ Ref.ObjectRef $newPeerSettings$inlined;
                        final /* synthetic */ boolean $clearPrevious$inlined;
                        final /* synthetic */ Settings $settings$inlined;
                        final /* synthetic */ Ref.LongRef $delta$inlined;
                        final /* synthetic */ Ref.ObjectRef $streamsToNotify$inlined;
                        {
                            this.$name = string;
                            this.$cancelable = bl;
                            this.this$0 = readerRunnable;
                            this.$newPeerSettings$inlined = objectRef;
                            this.$clearPrevious$inlined = bl3;
                            this.$settings$inlined = settings;
                            this.$delta$inlined = longRef;
                            this.$streamsToNotify$inlined = objectRef2;
                            super(string2, bl2);
                        }

                        public long runOnce() {
                            boolean bl = false;
                            this.this$0.Http2Connection.this.getListener$okhttp().onSettings(this.this$0.Http2Connection.this, (Settings)this.$newPeerSettings$inlined.element);
                            return -1L;
                        }
                    }, l2);
                    Unit bl14 = Unit.INSTANCE;
                }
                try {
                    Http2Connection.this.getWriter().applyAndAckSettings((Settings)objectRef2.element);
                }
                catch (IOException iOException) {
                    Http2Connection.this.failConnection(iOException);
                }
                Http2Stream[] http2StreamArray = Unit.INSTANCE;
            }
            if ((Http2Stream[])objectRef.element != null) {
                Http2Stream[] http2StreamArray = (Http2Stream[])objectRef.element;
                Intrinsics.checkNotNull(http2StreamArray);
                for (Http2Stream http2Stream : http2StreamArray) {
                    boolean bl10 = false;
                    boolean bl11 = false;
                    synchronized (http2Stream) {
                        boolean bl12 = false;
                        http2Stream.addBytesToWriteWindow(longRef.element);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ping(boolean bl, int n, int n2) {
            if (bl) {
                Http2Connection http2Connection = Http2Connection.this;
                boolean bl2 = false;
                boolean bl3 = false;
                synchronized (http2Connection) {
                    Object object;
                    boolean bl4 = false;
                    switch (n) {
                        case 1: {
                            Http2Connection http2Connection2 = Http2Connection.this;
                            long l = http2Connection2.intervalPongsReceived;
                            http2Connection2.intervalPongsReceived = l + 1L;
                            object = l;
                            break;
                        }
                        case 2: {
                            Http2Connection http2Connection3 = Http2Connection.this;
                            long l = http2Connection3.degradedPongsReceived;
                            http2Connection3.degradedPongsReceived = l + 1L;
                            object = l;
                            break;
                        }
                        case 3: {
                            Http2Connection http2Connection4 = Http2Connection.this;
                            long l = http2Connection4.awaitPongsReceived;
                            http2Connection4.awaitPongsReceived = l + 1L;
                            Http2Connection http2Connection5 = Http2Connection.this;
                            boolean bl5 = false;
                            Http2Connection http2Connection6 = http2Connection5;
                            if (http2Connection6 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.Object");
                            }
                            ((Object)http2Connection6).notifyAll();
                            object = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            object = Unit.INSTANCE;
                        }
                    }
                    Unit unit = object;
                }
            } else {
                TaskQueue taskQueue = Http2Connection.this.writerQueue;
                String string = Http2Connection.this.getConnectionName$okhttp() + " ping";
                long l = 0L;
                boolean bl6 = true;
                boolean bl7 = false;
                taskQueue.schedule(new Task(string, bl6, string, bl6, this, n, n2){
                    final /* synthetic */ String $name;
                    final /* synthetic */ boolean $cancelable;
                    final /* synthetic */ ReaderRunnable this$0;
                    final /* synthetic */ int $payload1$inlined;
                    final /* synthetic */ int $payload2$inlined;
                    {
                        this.$name = string;
                        this.$cancelable = bl;
                        this.this$0 = readerRunnable;
                        this.$payload1$inlined = n;
                        this.$payload2$inlined = n2;
                        super(string2, bl2);
                    }

                    public long runOnce() {
                        boolean bl = false;
                        this.this$0.Http2Connection.this.writePing(true, this.$payload1$inlined, this.$payload2$inlined);
                        return -1L;
                    }
                }, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int n, @NotNull ErrorCode errorCode, @NotNull ByteString byteString) {
            Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
            Intrinsics.checkNotNullParameter(byteString, "debugData");
            if (byteString.size() > 0) {
                // empty if block
            }
            Http2Stream[] http2StreamArray = null;
            Http2Connection object2 = Http2Connection.this;
            int n2 = 0;
            boolean bl = false;
            synchronized (object2) {
                int n3 = 0;
                Collection<Http2Stream> collection = Http2Connection.this.getStreams$okhttp().values();
                boolean bl2 = false;
                Collection<Http2Stream> collection2 = collection;
                Http2Stream[] http2StreamArray2 = collection2.toArray(new Http2Stream[0]);
                if (http2StreamArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                http2StreamArray = http2StreamArray2;
                Http2Connection.this.isShutdown = true;
                Http2Stream[] http2StreamArray3 = Unit.INSTANCE;
            }
            for (Http2Stream http2Stream : http2StreamArray) {
                if (http2Stream.getId() <= n || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                Http2Connection.this.removeStream$okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int n, long l) {
            if (n == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (http2Connection) {
                    boolean bl3 = false;
                    Http2Connection http2Connection2 = Http2Connection.this;
                    http2Connection2.writeBytesMaximum = http2Connection2.getWriteBytesMaximum() + l;
                    Http2Connection http2Connection3 = Http2Connection.this;
                    boolean bl4 = false;
                    Http2Connection http2Connection4 = http2Connection3;
                    if (http2Connection4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Object");
                    }
                    ((Object)http2Connection4).notifyAll();
                    Unit unit = Unit.INSTANCE;
                }
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n);
            if (http2Stream != null) {
                boolean bl = false;
                boolean bl5 = false;
                synchronized (http2Stream) {
                    boolean bl6 = false;
                    http2Stream.addBytesToWriteWindow(l);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        @Override
        public void priority(int n, int n2, int n3, boolean bl) {
        }

        @Override
        public void pushPromise(int n, int n2, @NotNull List<Header> list) {
            Intrinsics.checkNotNullParameter(list, "requestHeaders");
            Http2Connection.this.pushRequestLater$okhttp(n2, list);
        }

        @Override
        public void alternateService(int n, @NotNull String string, @NotNull ByteString byteString, @NotNull String string2, int n2, long l) {
            Intrinsics.checkNotNullParameter(string, "origin");
            Intrinsics.checkNotNullParameter(byteString, "protocol");
            Intrinsics.checkNotNullParameter(string2, "host");
        }

        @NotNull
        public final Http2Reader getReader$okhttp() {
            return this.reader;
        }

        public ReaderRunnable(@NotNull Http2Reader http2Reader) {
            Intrinsics.checkNotNullParameter(http2Reader, "reader");
            this.reader = http2Reader;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener;", "", "()V", "onSettings", "", "connection", "Lokhttp3/internal/http2/Http2Connection;", "settings", "Lokhttp3/internal/http2/Settings;", "onStream", "stream", "Lokhttp3/internal/http2/Http2Stream;", "Companion", "okhttp"})
    public static abstract class Listener {
        @JvmField
        @NotNull
        public static final Listener REFUSE_INCOMING_STREAMS;
        public static final Companion Companion;

        public abstract void onStream(@NotNull Http2Stream var1) throws IOException;

        public void onSettings(@NotNull Http2Connection http2Connection, @NotNull Settings settings) {
            Intrinsics.checkNotNullParameter(http2Connection, "connection");
            Intrinsics.checkNotNullParameter(settings, "settings");
        }

        static {
            Companion = new Companion(null);
            REFUSE_INCOMING_STREAMS = new Listener(){

                public void onStream(@NotNull Http2Stream http2Stream) throws IOException {
                    Intrinsics.checkNotNullParameter(http2Stream, "stream");
                    http2Stream.close(ErrorCode.REFUSED_STREAM, null);
                }
            };
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener$Companion;", "", "()V", "REFUSE_INCOMING_STREAMS", "Lokhttp3/internal/http2/Http2Connection$Listener;", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http2/Http2Connection$Companion;", "", "()V", "AWAIT_PING", "", "DEFAULT_SETTINGS", "Lokhttp3/internal/http2/Settings;", "getDEFAULT_SETTINGS", "()Lokhttp3/internal/http2/Settings;", "DEGRADED_PING", "DEGRADED_PONG_TIMEOUT_NS", "INTERVAL_PING", "OKHTTP_CLIENT_WINDOW_SIZE", "okhttp"})
    public static final class Companion {
        @NotNull
        public final Settings getDEFAULT_SETTINGS() {
            return DEFAULT_SETTINGS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

