/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lokhttp3/internal/http2/Hpack;", "", "()V", "NAME_TO_FIRST_INDEX", "", "Lokio/ByteString;", "", "getNAME_TO_FIRST_INDEX", "()Ljava/util/Map;", "PREFIX_4_BITS", "PREFIX_5_BITS", "PREFIX_6_BITS", "PREFIX_7_BITS", "SETTINGS_HEADER_TABLE_SIZE", "SETTINGS_HEADER_TABLE_SIZE_LIMIT", "STATIC_HEADER_TABLE", "", "Lokhttp3/internal/http2/Header;", "getSTATIC_HEADER_TABLE", "()[Lokhttp3/internal/http2/Header;", "[Lokhttp3/internal/http2/Header;", "checkLowercase", "name", "nameToFirstIndex", "Reader", "Writer", "okhttp"})
public final class Hpack {
    private static final int PREFIX_4_BITS = 15;
    private static final int PREFIX_5_BITS = 31;
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    private static final int SETTINGS_HEADER_TABLE_SIZE = 4096;
    private static final int SETTINGS_HEADER_TABLE_SIZE_LIMIT = 16384;
    @NotNull
    private static final Header[] STATIC_HEADER_TABLE;
    @NotNull
    private static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX;
    public static final Hpack INSTANCE;

    @NotNull
    public final Header[] getSTATIC_HEADER_TABLE() {
        return STATIC_HEADER_TABLE;
    }

    @NotNull
    public final Map<ByteString, Integer> getNAME_TO_FIRST_INDEX() {
        return NAME_TO_FIRST_INDEX;
    }

    private final Map<ByteString, Integer> nameToFirstIndex() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(STATIC_HEADER_TABLE.length);
        int n = STATIC_HEADER_TABLE.length;
        for (int i = 0; i < n; ++i) {
            if (linkedHashMap.containsKey(Hpack.STATIC_HEADER_TABLE[i].name)) continue;
            ((Map)linkedHashMap).put(Hpack.STATIC_HEADER_TABLE[i].name, i);
        }
        Map<ByteString, Integer> map = Collections.unmodifiableMap(linkedHashMap);
        Intrinsics.checkNotNullExpressionValue(map, "Collections.unmodifiableMap(result)");
        return map;
    }

    @NotNull
    public final ByteString checkLowercase(@NotNull ByteString byteString) throws IOException {
        Intrinsics.checkNotNullParameter(byteString, "name");
        int n = byteString.size();
        for (int i = 0; i < n; ++i) {
            byte by = byteString.getByte(i);
            if ((byte)65 > by || (byte)90 < by) continue;
            throw (Throwable)new IOException("PROTOCOL_ERROR response malformed: mixed case name: " + byteString.utf8());
        }
        return byteString;
    }

    private Hpack() {
    }

    static {
        Hpack hpack;
        INSTANCE = hpack = new Hpack();
        STATIC_HEADER_TABLE = new Header[]{new Header(Header.TARGET_AUTHORITY, ""), new Header(Header.TARGET_METHOD, "GET"), new Header(Header.TARGET_METHOD, "POST"), new Header(Header.TARGET_PATH, "/"), new Header(Header.TARGET_PATH, "/index.html"), new Header(Header.TARGET_SCHEME, "http"), new Header(Header.TARGET_SCHEME, "https"), new Header(Header.RESPONSE_STATUS, "200"), new Header(Header.RESPONSE_STATUS, "204"), new Header(Header.RESPONSE_STATUS, "206"), new Header(Header.RESPONSE_STATUS, "304"), new Header(Header.RESPONSE_STATUS, "400"), new Header(Header.RESPONSE_STATUS, "404"), new Header(Header.RESPONSE_STATUS, "500"), new Header("accept-charset", ""), new Header("accept-encoding", "gzip, deflate"), new Header("accept-language", ""), new Header("accept-ranges", ""), new Header("accept", ""), new Header("access-control-allow-origin", ""), new Header("age", ""), new Header("allow", ""), new Header("authorization", ""), new Header("cache-control", ""), new Header("content-disposition", ""), new Header("content-encoding", ""), new Header("content-language", ""), new Header("content-length", ""), new Header("content-location", ""), new Header("content-range", ""), new Header("content-type", ""), new Header("cookie", ""), new Header("date", ""), new Header("etag", ""), new Header("expect", ""), new Header("expires", ""), new Header("from", ""), new Header("host", ""), new Header("if-match", ""), new Header("if-modified-since", ""), new Header("if-none-match", ""), new Header("if-range", ""), new Header("if-unmodified-since", ""), new Header("last-modified", ""), new Header("link", ""), new Header("location", ""), new Header("max-forwards", ""), new Header("proxy-authenticate", ""), new Header("proxy-authorization", ""), new Header("range", ""), new Header("referer", ""), new Header("refresh", ""), new Header("retry-after", ""), new Header("server", ""), new Header("set-cookie", ""), new Header("strict-transport-security", ""), new Header("transfer-encoding", ""), new Header("user-agent", ""), new Header("vary", ""), new Header("via", ""), new Header("www-authenticate", "")};
        NAME_TO_FIRST_INDEX = hpack.nameToFirstIndex();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010!\u001a\u00020\u0005H\u0002J\u0006\u0010\"\u001a\u00020\u001cJ\u0006\u0010#\u001a\u00020\u0013J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0016\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0005H\u0002J\b\u0010*\u001a\u00020\u0013H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\b\u0010,\u001a\u00020\u0013H\u0002R\u001c\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lokhttp3/internal/http2/Hpack$Reader;", "", "source", "Lokio/Source;", "headerTableSizeSetting", "", "maxDynamicTableByteCount", "(Lokio/Source;II)V", "dynamicTable", "", "Lokhttp3/internal/http2/Header;", "[Lokhttp3/internal/http2/Header;", "dynamicTableByteCount", "headerCount", "headerList", "", "nextHeaderIndex", "Lokio/BufferedSource;", "adjustDynamicTableByteCount", "", "clearDynamicTable", "dynamicTableIndex", "index", "evictToRecoverBytes", "bytesToRecover", "getAndResetHeaderList", "", "getName", "Lokio/ByteString;", "insertIntoDynamicTable", "entry", "isStaticHeader", "", "readByte", "readByteString", "readHeaders", "readIndexedHeader", "readInt", "firstByte", "prefixMask", "readLiteralHeaderWithIncrementalIndexingIndexedName", "nameIndex", "readLiteralHeaderWithIncrementalIndexingNewName", "readLiteralHeaderWithoutIndexingIndexedName", "readLiteralHeaderWithoutIndexingNewName", "okhttp"})
    public static final class Reader {
        private final List<Header> headerList;
        private final BufferedSource source;
        @JvmField
        @NotNull
        public Header[] dynamicTable;
        private int nextHeaderIndex;
        @JvmField
        public int headerCount;
        @JvmField
        public int dynamicTableByteCount;
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;

        @NotNull
        public final List<Header> getAndResetHeaderList() {
            List<Header> list = CollectionsKt.toList((Iterable)this.headerList);
            this.headerList.clear();
            return list;
        }

        public final int maxDynamicTableByteCount() {
            return this.maxDynamicTableByteCount;
        }

        private final void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
                }
            }
        }

        private final void clearDynamicTable() {
            ArraysKt.fill$default(this.dynamicTable, null, 0, 0, 6, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private final int evictToRecoverBytes(int n) {
            int n2 = n;
            int n3 = 0;
            if (n2 > 0) {
                for (int i = this.dynamicTable.length - 1; i >= this.nextHeaderIndex && n2 > 0; --i) {
                    Header header;
                    Intrinsics.checkNotNull(this.dynamicTable[i]);
                    n2 -= header.hpackSize;
                    this.dynamicTableByteCount -= header.hpackSize;
                    int n4 = this.headerCount;
                    this.headerCount = n4 + -1;
                    ++n3;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n3, this.headerCount);
                this.nextHeaderIndex += n3;
            }
            return n3;
        }

        public final void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int n;
                int n2 = Util.and(this.source.readByte(), 255);
                if (n2 == 128) {
                    throw (Throwable)new IOException("index == 0");
                }
                if ((n2 & 0x80) == 128) {
                    n = this.readInt(n2, 127);
                    this.readIndexedHeader(n - 1);
                    continue;
                }
                if (n2 == 64) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((n2 & 0x40) == 64) {
                    n = this.readInt(n2, 63);
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(n - 1);
                    continue;
                }
                if ((n2 & 0x20) == 32) {
                    this.maxDynamicTableByteCount = this.readInt(n2, 31);
                    if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                        throw (Throwable)new IOException("Invalid dynamic table size update " + this.maxDynamicTableByteCount);
                    }
                    this.adjustDynamicTableByteCount();
                    continue;
                }
                if (n2 == 16 || n2 == 0) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                n = this.readInt(n2, 15);
                this.readLiteralHeaderWithoutIndexingIndexedName(n - 1);
            }
        }

        private final void readIndexedHeader(int n) throws IOException {
            if (this.isStaticHeader(n)) {
                Header header = INSTANCE.getSTATIC_HEADER_TABLE()[n];
                this.headerList.add(header);
            } else {
                int n2 = this.dynamicTableIndex(n - INSTANCE.getSTATIC_HEADER_TABLE().length);
                if (n2 < 0 || n2 >= this.dynamicTable.length) {
                    throw (Throwable)new IOException("Header index too large " + (n + 1));
                }
                Collection collection = this.headerList;
                Header header = this.dynamicTable[n2];
                Intrinsics.checkNotNull(header);
                Header header2 = header;
                boolean bl = false;
                collection.add(header2);
            }
        }

        private final int dynamicTableIndex(int n) {
            return this.nextHeaderIndex + 1 + n;
        }

        private final void readLiteralHeaderWithoutIndexingIndexedName(int n) throws IOException {
            ByteString byteString = this.getName(n);
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private final void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            ByteString byteString = INSTANCE.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private final void readLiteralHeaderWithIncrementalIndexingIndexedName(int n) throws IOException {
            ByteString byteString = this.getName(n);
            ByteString byteString2 = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
        }

        private final void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            ByteString byteString = INSTANCE.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.insertIntoDynamicTable(-1, new Header(byteString, byteString2));
        }

        private final ByteString getName(int n) throws IOException {
            ByteString byteString;
            if (this.isStaticHeader(n)) {
                byteString = Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[n].name;
            } else {
                int n2 = this.dynamicTableIndex(n - INSTANCE.getSTATIC_HEADER_TABLE().length);
                if (n2 < 0 || n2 >= this.dynamicTable.length) {
                    throw (Throwable)new IOException("Header index too large " + (n + 1));
                }
                Header header = this.dynamicTable[n2];
                Intrinsics.checkNotNull(header);
                byteString = header.name;
            }
            return byteString;
        }

        private final boolean isStaticHeader(int n) {
            return n >= 0 && n <= INSTANCE.getSTATIC_HEADER_TABLE().length - 1;
        }

        private final void insertIntoDynamicTable(int n, Header header) {
            int n2 = n;
            this.headerList.add(header);
            int n3 = header.hpackSize;
            if (n2 != -1) {
                Header header2 = this.dynamicTable[this.dynamicTableIndex(n2)];
                Intrinsics.checkNotNull(header2);
                n3 -= header2.hpackSize;
            }
            if (n3 > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int n4 = this.dynamicTableByteCount + n3 - this.maxDynamicTableByteCount;
            int n5 = this.evictToRecoverBytes(n4);
            if (n2 == -1) {
                if (this.headerCount + 1 > this.dynamicTable.length) {
                    Header[] headerArray = new Header[this.dynamicTable.length * 2];
                    System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = headerArray;
                }
                int n6 = this.nextHeaderIndex;
                this.nextHeaderIndex = n6 + -1;
                n2 = n6;
                this.dynamicTable[n2] = header;
                n6 = this.headerCount;
                this.headerCount = n6 + 1;
            } else {
                n2 += this.dynamicTableIndex(n2) + n5;
                this.dynamicTable[n2] = header;
            }
            this.dynamicTableByteCount += n3;
        }

        private final int readByte() throws IOException {
            return Util.and(this.source.readByte(), 255);
        }

        public final int readInt(int n, int n2) throws IOException {
            int n3;
            int n4 = n & n2;
            if (n4 < n2) {
                return n4;
            }
            int n5 = n2;
            int n6 = 0;
            while (((n3 = this.readByte()) & 0x80) != 0) {
                n5 += (n3 & 0x7F) << n6;
                n6 += 7;
            }
            return n5 += n3 << n6;
        }

        @NotNull
        public final ByteString readByteString() throws IOException {
            ByteString byteString;
            int n = this.readByte();
            boolean bl = (n & 0x80) == 128;
            long l = this.readInt(n, 127);
            if (bl) {
                Buffer buffer = new Buffer();
                Huffman.INSTANCE.decode(this.source, l, buffer);
                byteString = buffer.readByteString();
            } else {
                byteString = this.source.readByteString(l);
            }
            return byteString;
        }

        @JvmOverloads
        public Reader(@NotNull Source source2, int n, int n2) {
            Intrinsics.checkNotNullParameter(source2, "source");
            this.headerTableSizeSetting = n;
            this.maxDynamicTableByteCount = n2;
            boolean bl = false;
            this.headerList = new ArrayList();
            this.source = Okio.buffer(source2);
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
        }

        public /* synthetic */ Reader(Source source2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = n;
            }
            this(source2, n, n2);
        }

        @JvmOverloads
        public Reader(@NotNull Source source2, int n) {
            this(source2, n, 0, 4, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 J\u001e\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003R\u001c\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lokhttp3/internal/http2/Hpack$Writer;", "", "headerTableSizeSetting", "", "useCompression", "", "out", "Lokio/Buffer;", "(IZLokio/Buffer;)V", "dynamicTable", "", "Lokhttp3/internal/http2/Header;", "[Lokhttp3/internal/http2/Header;", "dynamicTableByteCount", "emitDynamicTableSizeUpdate", "headerCount", "maxDynamicTableByteCount", "nextHeaderIndex", "smallestHeaderTableSizeSetting", "adjustDynamicTableByteCount", "", "clearDynamicTable", "evictToRecoverBytes", "bytesToRecover", "insertIntoDynamicTable", "entry", "resizeHeaderTable", "writeByteString", "data", "Lokio/ByteString;", "writeHeaders", "headerBlock", "", "writeInt", "value", "prefixMask", "bits", "okhttp"})
    public static final class Writer {
        private int smallestHeaderTableSizeSetting;
        private boolean emitDynamicTableSizeUpdate;
        @JvmField
        public int maxDynamicTableByteCount;
        @JvmField
        @NotNull
        public Header[] dynamicTable;
        private int nextHeaderIndex;
        @JvmField
        public int headerCount;
        @JvmField
        public int dynamicTableByteCount;
        @JvmField
        public int headerTableSizeSetting;
        private final boolean useCompression;
        private final Buffer out;

        private final void clearDynamicTable() {
            ArraysKt.fill$default(this.dynamicTable, null, 0, 0, 6, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private final int evictToRecoverBytes(int n) {
            int n2 = n;
            int n3 = 0;
            if (n2 > 0) {
                for (int i = this.dynamicTable.length - 1; i >= this.nextHeaderIndex && n2 > 0; --i) {
                    Header header = this.dynamicTable[i];
                    Intrinsics.checkNotNull(header);
                    n2 -= header.hpackSize;
                    Header header2 = this.dynamicTable[i];
                    Intrinsics.checkNotNull(header2);
                    this.dynamicTableByteCount -= header2.hpackSize;
                    int n4 = this.headerCount;
                    this.headerCount = n4 + -1;
                    ++n3;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n3, this.headerCount);
                Arrays.fill(this.dynamicTable, this.nextHeaderIndex + 1, this.nextHeaderIndex + 1 + n3, null);
                this.nextHeaderIndex += n3;
            }
            return n3;
        }

        private final void insertIntoDynamicTable(Header header) {
            int n = header.hpackSize;
            if (n > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int n2 = this.dynamicTableByteCount + n - this.maxDynamicTableByteCount;
            this.evictToRecoverBytes(n2);
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] headerArray = new Header[this.dynamicTable.length * 2];
                System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray;
            }
            int n3 = this.nextHeaderIndex;
            this.nextHeaderIndex = n3 + -1;
            int n4 = n3;
            this.dynamicTable[n4] = header;
            n3 = this.headerCount;
            this.headerCount = n3 + 1;
            this.dynamicTableByteCount += n;
        }

        public final void writeHeaders(@NotNull List<Header> list) throws IOException {
            Intrinsics.checkNotNullParameter(list, "headerBlock");
            if (this.emitDynamicTableSizeUpdate) {
                if (this.smallestHeaderTableSizeSetting < this.maxDynamicTableByteCount) {
                    this.writeInt(this.smallestHeaderTableSizeSetting, 31, 32);
                }
                this.emitDynamicTableSizeUpdate = false;
                this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
                this.writeInt(this.maxDynamicTableByteCount, 31, 32);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                Header header = list.get(i);
                ByteString byteString = header.name.toAsciiLowercase();
                ByteString byteString2 = header.value;
                int n3 = -1;
                int n4 = -1;
                Integer n5 = INSTANCE.getNAME_TO_FIRST_INDEX().get(byteString);
                if (n5 != null && 2 <= (n2 = (n4 = n5 + 1)) && 7 >= n2) {
                    if (Intrinsics.areEqual(Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[n4 - 1].value, byteString2)) {
                        n3 = n4;
                    } else if (Intrinsics.areEqual(Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[n4].value, byteString2)) {
                        n3 = n4 + 1;
                    }
                }
                if (n3 == -1) {
                    int n6 = this.dynamicTable.length;
                    for (n2 = this.nextHeaderIndex + 1; n2 < n6; ++n2) {
                        Header header2 = this.dynamicTable[n2];
                        Intrinsics.checkNotNull(header2);
                        if (!Intrinsics.areEqual(header2.name, byteString)) continue;
                        Header header3 = this.dynamicTable[n2];
                        Intrinsics.checkNotNull(header3);
                        if (Intrinsics.areEqual(header3.value, byteString2)) {
                            n3 = n2 - this.nextHeaderIndex + INSTANCE.getSTATIC_HEADER_TABLE().length;
                            break;
                        }
                        if (n4 != -1) continue;
                        n4 = n2 - this.nextHeaderIndex + INSTANCE.getSTATIC_HEADER_TABLE().length;
                    }
                }
                if (n3 != -1) {
                    this.writeInt(n3, 127, 128);
                    continue;
                }
                if (n4 == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(byteString);
                    this.writeByteString(byteString2);
                    this.insertIntoDynamicTable(header);
                    continue;
                }
                if (byteString.startsWith(Header.PSEUDO_PREFIX) && Intrinsics.areEqual(Header.TARGET_AUTHORITY, byteString) ^ true) {
                    this.writeInt(n4, 15, 0);
                    this.writeByteString(byteString2);
                    continue;
                }
                this.writeInt(n4, 63, 64);
                this.writeByteString(byteString2);
                this.insertIntoDynamicTable(header);
            }
        }

        public final void writeInt(int n, int n2, int n3) {
            int n4 = n;
            if (n4 < n2) {
                this.out.writeByte(n3 | n4);
                return;
            }
            this.out.writeByte(n3 | n2);
            n4 -= n2;
            while (n4 >= 128) {
                int n5 = n4 & 0x7F;
                this.out.writeByte(n5 | 0x80);
                n4 >>>= 7;
            }
            this.out.writeByte(n4);
        }

        public final void writeByteString(@NotNull ByteString byteString) throws IOException {
            Intrinsics.checkNotNullParameter(byteString, "data");
            if (this.useCompression && Huffman.INSTANCE.encodedLength(byteString) < byteString.size()) {
                Buffer buffer = new Buffer();
                Huffman.INSTANCE.encode(byteString, buffer);
                ByteString byteString2 = buffer.readByteString();
                this.writeInt(byteString2.size(), 127, 128);
                this.out.write(byteString2);
            } else {
                this.writeInt(byteString.size(), 127, 0);
                this.out.write(byteString);
            }
        }

        public final void resizeHeaderTable(int n) {
            this.headerTableSizeSetting = n;
            int n2 = 16384;
            boolean bl = false;
            int n3 = Math.min(n, n2);
            if (this.maxDynamicTableByteCount == n3) {
                return;
            }
            if (n3 < this.maxDynamicTableByteCount) {
                n2 = this.smallestHeaderTableSizeSetting;
                bl = false;
                this.smallestHeaderTableSizeSetting = Math.min(n2, n3);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = n3;
            this.adjustDynamicTableByteCount();
        }

        private final void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
                }
            }
        }

        @JvmOverloads
        public Writer(int n, boolean bl, @NotNull Buffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "out");
            this.headerTableSizeSetting = n;
            this.useCompression = bl;
            this.out = buffer;
            this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            this.maxDynamicTableByteCount = this.headerTableSizeSetting;
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
        }

        public /* synthetic */ Writer(int n, boolean bl, Buffer buffer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 4096;
            }
            if ((n2 & 2) != 0) {
                bl = true;
            }
            this(n, bl, buffer);
        }

        @JvmOverloads
        public Writer(int n, @NotNull Buffer buffer) {
            this(n, false, buffer, 2, null);
        }

        @JvmOverloads
        public Writer(@NotNull Buffer buffer) {
            this(0, false, buffer, 3, null);
        }
    }
}

