/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.lang.ref.Reference;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.ConnectionPool;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005*\u0001\u000e\u0018\u0000 (2\u00020\u0001:\u0001(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0005J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u000e\u0010'\u001a\u00020$2\u0006\u0010!\u001a\u00020\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lokhttp3/internal/connection/RealConnectionPool;", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "maxIdleConnections", "", "keepAliveDuration", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(Lokhttp3/internal/concurrent/TaskRunner;IJLjava/util/concurrent/TimeUnit;)V", "cleanupQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "cleanupTask", "okhttp3/internal/connection/RealConnectionPool$cleanupTask$1", "Lokhttp3/internal/connection/RealConnectionPool$cleanupTask$1;", "connections", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lokhttp3/internal/connection/RealConnection;", "keepAliveDurationNs", "callAcquirePooledConnection", "", "address", "Lokhttp3/Address;", "call", "Lokhttp3/internal/connection/RealCall;", "routes", "", "Lokhttp3/Route;", "requireMultiplexed", "cleanup", "now", "connectionBecameIdle", "connection", "connectionCount", "evictAll", "", "idleConnectionCount", "pruneAndGetAllocationCount", "put", "Companion", "okhttp"})
public final class RealConnectionPool {
    private final long keepAliveDurationNs;
    private final TaskQueue cleanupQueue;
    private final cleanupTask.1 cleanupTask;
    private final ConcurrentLinkedQueue<RealConnection> connections;
    private final int maxIdleConnections;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int idleConnectionCount() {
        int n;
        Iterable iterable = this.connections;
        boolean bl = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            n = 0;
        } else {
            int n2 = 0;
            for (Object t2 : iterable) {
                RealConnection realConnection;
                RealConnection realConnection2 = (RealConnection)t2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(realConnection2, "it");
                boolean bl3 = false;
                boolean bl4 = false;
                synchronized (realConnection) {
                    boolean bl5 = false;
                    bl4 = realConnection2.getCalls().isEmpty();
                }
                if (!bl4) continue;
                int n3 = ++n2;
                bl2 = false;
                if (n3 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = n2;
        }
        return n;
    }

    public final int connectionCount() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean callAcquirePooledConnection(@NotNull Address address, @NotNull RealCall realCall, @Nullable List<Route> list, boolean bl) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(realCall, "call");
        for (RealConnection realConnection : this.connections) {
            RealConnection realConnection2;
            Intrinsics.checkNotNullExpressionValue(realConnection, "connection");
            boolean bl2 = false;
            boolean bl3 = false;
            synchronized (realConnection2) {
                block5: {
                    boolean bl4 = false;
                    if (bl && !realConnection.isMultiplexed$okhttp() || !realConnection.isEligible$okhttp(address, list)) break block5;
                    realCall.acquireConnectionNoEvents(realConnection);
                    boolean bl5 = true;
                    return bl5;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return false;
    }

    public final void put(@NotNull RealConnection realConnection) {
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        RealConnection realConnection2 = realConnection;
        boolean bl = false;
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection2)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST hold lock on ").append(realConnection2).toString()));
        }
        this.connections.add(realConnection);
        TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
    }

    public final boolean connectionBecameIdle(@NotNull RealConnection realConnection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        RealConnection realConnection2 = realConnection;
        boolean bl2 = false;
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection2)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST hold lock on ").append(realConnection2).toString()));
        }
        if (realConnection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            realConnection.setNoNewExchanges(true);
            this.connections.remove(realConnection);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            bl = true;
        } else {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        Iterator<RealConnection> iterator2 = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "connections.iterator()");
        Iterator<RealConnection> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Socket socket;
            Socket socket2;
            RealConnection realConnection;
            RealConnection realConnection2 = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(realConnection2, "connection");
            boolean bl = false;
            boolean bl2 = false;
            synchronized (realConnection) {
                Socket socket3;
                boolean bl3 = false;
                if (realConnection2.getCalls().isEmpty()) {
                    iterator3.remove();
                    realConnection2.setNoNewExchanges(true);
                    socket3 = realConnection2.socket();
                } else {
                    socket3 = null;
                }
                socket2 = socket3;
            }
            Socket socket4 = socket = socket2;
            if (socket4 == null) continue;
            Util.closeQuietly(socket4);
        }
        if (this.connections.isEmpty()) {
            this.cleanupQueue.cancelAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long cleanup(long l) {
        Object object;
        boolean bl;
        boolean bl2;
        int n = 0;
        int n2 = 0;
        RealConnection realConnection = null;
        long l2 = Long.MIN_VALUE;
        for (RealConnection realConnection2 : this.connections) {
            RealConnection realConnection3;
            Intrinsics.checkNotNullExpressionValue(realConnection2, "connection");
            bl2 = false;
            boolean bl3 = false;
            synchronized (realConnection3) {
                Object object2;
                int n3;
                bl = false;
                if (this.pruneAndGetAllocationCount(realConnection2, l) > 0) {
                    n3 = n;
                    n = n3 + 1;
                    object2 = n3;
                } else {
                    n3 = n2;
                    n2 = n3 + 1;
                    long l3 = l - realConnection2.getIdleAtNs$okhttp();
                    if (l3 > l2) {
                        l2 = l3;
                        realConnection = realConnection2;
                        object2 = Unit.INSTANCE;
                    } else {
                        object2 = Unit.INSTANCE;
                    }
                }
                object = object2;
            }
        }
        if (l2 >= this.keepAliveDurationNs || n2 > this.maxIdleConnections) {
            RealConnection realConnection2;
            RealConnection realConnection4 = realConnection;
            Intrinsics.checkNotNull(realConnection4);
            realConnection2 = realConnection4;
            boolean bl4 = false;
            boolean bl5 = false;
            synchronized (realConnection2) {
                block18: {
                    block17: {
                        bl2 = false;
                        object = realConnection2.getCalls();
                        bl = false;
                        if (!(!object.isEmpty())) break block17;
                        long l4 = 0L;
                        return l4;
                    }
                    if (realConnection2.getIdleAtNs$okhttp() + l2 == l) break block18;
                    long l5 = 0L;
                    return l5;
                }
                realConnection2.setNoNewExchanges(true);
                bl5 = this.connections.remove(realConnection);
            }
            Util.closeQuietly(realConnection2.socket());
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return 0L;
        }
        if (n2 > 0) {
            return this.keepAliveDurationNs - l2;
        }
        if (n > 0) {
            return this.keepAliveDurationNs;
        }
        return -1L;
    }

    private final int pruneAndGetAllocationCount(RealConnection realConnection, long l) {
        Object object = realConnection;
        int n = 0;
        if (Util.assertionsEnabled && !Thread.holdsLock(object)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST hold lock on ").append(object).toString()));
        }
        object = realConnection.getCalls();
        n = 0;
        while (n < object.size()) {
            Reference reference = (Reference)object.get(n);
            if (reference.get() != null) {
                ++n;
                continue;
            }
            Reference reference2 = reference;
            if (reference2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type okhttp3.internal.connection.RealCall.CallReference");
            }
            RealCall.CallReference callReference = (RealCall.CallReference)reference2;
            String string = "A connection to " + realConnection.route().address().url() + " was leaked. " + "Did you forget to close a response body?";
            Platform.Companion.get().logCloseableLeak(string, callReference.getCallStackTrace());
            object.remove(n);
            realConnection.setNoNewExchanges(true);
            if (!object.isEmpty()) continue;
            realConnection.setIdleAtNs$okhttp(l - this.keepAliveDurationNs);
            return 0;
        }
        return object.size();
    }

    public RealConnectionPool(@NotNull TaskRunner taskRunner, int n, long l, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        this.maxIdleConnections = n;
        this.keepAliveDurationNs = timeUnit.toNanos(l);
        this.cleanupQueue = taskRunner.newQueue();
        this.cleanupTask = new Task(this, Util.okHttpName + " ConnectionPool"){
            final /* synthetic */ RealConnectionPool this$0;

            public long runOnce() {
                return this.this$0.cleanup(System.nanoTime());
            }
            {
                this.this$0 = realConnectionPool;
                super(string, false, 2, null);
            }
        };
        this.connections = new ConcurrentLinkedQueue();
        boolean bl = l > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "keepAliveDuration <= 0: " + l;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lokhttp3/internal/connection/RealConnectionPool$Companion;", "", "()V", "get", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionPool", "Lokhttp3/ConnectionPool;", "okhttp"})
    public static final class Companion {
        @NotNull
        public final RealConnectionPool get(@NotNull ConnectionPool connectionPool) {
            Intrinsics.checkNotNullParameter(connectionPool, "connectionPool");
            return connectionPool.getDelegate$okhttp();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

