/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001.\u0018\u00002\u00020\u0001:\u0002deB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u00101\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u000fJ!\u00103\u001a\u0002H4\"\n\b\u0000\u00104*\u0004\u0018\u0001052\u0006\u00106\u001a\u0002H4H\u0002\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u000202H\u0002J\b\u00109\u001a\u000202H\u0016J\b\u0010:\u001a\u00020\u0000H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u0002022\u0006\u0010@\u001a\u00020AH\u0016J\u0016\u0010B\u001a\u0002022\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u0007J\b\u0010E\u001a\u00020FH\u0016J\u0015\u0010G\u001a\u0002022\u0006\u0010H\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bIJ\r\u0010J\u001a\u00020FH\u0000\u00a2\u0006\u0002\bKJ\u0015\u0010L\u001a\u00020\u001e2\u0006\u0010M\u001a\u00020NH\u0000\u00a2\u0006\u0002\bOJ\b\u0010P\u001a\u00020\u0007H\u0016J\b\u0010Q\u001a\u00020\u0007H\u0016J;\u0010R\u001a\u0002H4\"\n\b\u0000\u00104*\u0004\u0018\u0001052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u00072\u0006\u00106\u001a\u0002H4H\u0000\u00a2\u0006\u0004\bU\u0010VJ\u0019\u0010W\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000105H\u0000\u00a2\u0006\u0002\bXJ\r\u0010Y\u001a\u00020ZH\u0000\u00a2\u0006\u0002\b[J\u000f\u0010\\\u001a\u0004\u0018\u00010]H\u0000\u00a2\u0006\u0002\b^J\b\u0010C\u001a\u00020\u0005H\u0016J\u0006\u0010_\u001a\u00020\u0007J\b\u0010-\u001a\u00020`H\u0016J\u0006\u00100\u001a\u000202J!\u0010a\u001a\u0002H4\"\n\b\u0000\u00104*\u0004\u0018\u0001052\u0006\u0010b\u001a\u0002H4H\u0002\u00a2\u0006\u0002\u00107J\b\u0010c\u001a\u00020ZH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\"\u0010&\u001a\u0004\u0018\u00010\u001e2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001e@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010/R\u000e\u00100\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lokhttp3/internal/connection/RealCall;", "Lokhttp3/Call;", "client", "Lokhttp3/OkHttpClient;", "originalRequest", "Lokhttp3/Request;", "forWebSocket", "", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Z)V", "callStackTrace", "", "canceled", "getClient", "()Lokhttp3/OkHttpClient;", "<set-?>", "Lokhttp3/internal/connection/RealConnection;", "connection", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionToCancel", "getConnectionToCancel", "setConnectionToCancel", "(Lokhttp3/internal/connection/RealConnection;)V", "eventListener", "Lokhttp3/EventListener;", "getEventListener$okhttp", "()Lokhttp3/EventListener;", "exchange", "Lokhttp3/internal/connection/Exchange;", "exchangeFinder", "Lokhttp3/internal/connection/ExchangeFinder;", "executed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "expectMoreExchanges", "getForWebSocket", "()Z", "interceptorScopedExchange", "getInterceptorScopedExchange$okhttp", "()Lokhttp3/internal/connection/Exchange;", "getOriginalRequest", "()Lokhttp3/Request;", "requestBodyOpen", "responseBodyOpen", "timeout", "okhttp3/internal/connection/RealCall$timeout$1", "Lokhttp3/internal/connection/RealCall$timeout$1;", "timeoutEarlyExit", "acquireConnectionNoEvents", "", "callDone", "E", "Ljava/io/IOException;", "e", "(Ljava/io/IOException;)Ljava/io/IOException;", "callStart", "cancel", "clone", "createAddress", "Lokhttp3/Address;", "url", "Lokhttp3/HttpUrl;", "enqueue", "responseCallback", "Lokhttp3/Callback;", "enterNetworkInterceptorExchange", "request", "newExchangeFinder", "execute", "Lokhttp3/Response;", "exitNetworkInterceptorExchange", "closeExchange", "exitNetworkInterceptorExchange$okhttp", "getResponseWithInterceptorChain", "getResponseWithInterceptorChain$okhttp", "initExchange", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "initExchange$okhttp", "isCanceled", "isExecuted", "messageDone", "requestDone", "responseDone", "messageDone$okhttp", "(Lokhttp3/internal/connection/Exchange;ZZLjava/io/IOException;)Ljava/io/IOException;", "noMoreExchanges", "noMoreExchanges$okhttp", "redactedUrl", "", "redactedUrl$okhttp", "releaseConnectionNoEvents", "Ljava/net/Socket;", "releaseConnectionNoEvents$okhttp", "retryAfterFailure", "Lokio/AsyncTimeout;", "timeoutExit", "cause", "toLoggableString", "AsyncCall", "CallReference", "okhttp"})
public final class RealCall
implements Call {
    private final RealConnectionPool connectionPool;
    @NotNull
    private final EventListener eventListener;
    private final timeout.1 timeout;
    private final AtomicBoolean executed;
    private Object callStackTrace;
    private ExchangeFinder exchangeFinder;
    @Nullable
    private RealConnection connection;
    private boolean timeoutEarlyExit;
    @Nullable
    private Exchange interceptorScopedExchange;
    private boolean requestBodyOpen;
    private boolean responseBodyOpen;
    private boolean expectMoreExchanges;
    private volatile boolean canceled;
    private volatile Exchange exchange;
    @Nullable
    private volatile RealConnection connectionToCancel;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final Request originalRequest;
    private final boolean forWebSocket;

    @NotNull
    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    @Nullable
    public final RealConnection getConnection() {
        return this.connection;
    }

    @Nullable
    public final Exchange getInterceptorScopedExchange$okhttp() {
        return this.interceptorScopedExchange;
    }

    @Nullable
    public final RealConnection getConnectionToCancel() {
        return this.connectionToCancel;
    }

    public final void setConnectionToCancel(@Nullable RealConnection realConnection) {
        this.connectionToCancel = realConnection;
    }

    @Override
    @NotNull
    public AsyncTimeout timeout() {
        return this.timeout;
    }

    @Override
    @NotNull
    public RealCall clone() {
        return new RealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    @Override
    @NotNull
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Exchange exchange = this.exchange;
        if (exchange != null) {
            exchange.cancel();
        }
        RealConnection realConnection = this.connectionToCancel;
        if (realConnection != null) {
            realConnection.cancel();
        }
        this.eventListener.canceled(this);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response execute() {
        boolean bl = this.executed.compareAndSet(false, true);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.timeout.enter();
        this.callStart();
        try {
            this.client.dispatcher().executed$okhttp(this);
            Response response = this.getResponseWithInterceptorChain$okhttp();
            return response;
        }
        finally {
            this.client.dispatcher().finished$okhttp(this);
        }
    }

    @Override
    public void enqueue(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter(callback, "responseCallback");
        boolean bl = this.executed.compareAndSet(false, true);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.callStart();
        this.client.dispatcher().enqueue$okhttp(new AsyncCall(callback));
    }

    @Override
    public boolean isExecuted() {
        return this.executed.get();
    }

    private final void callStart() {
        this.callStackTrace = Platform.Companion.get().getStackTraceForCloseable("response.body().close()");
        this.eventListener.callStart(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Response getResponseWithInterceptorChain$okhttp() throws IOException {
        Response response;
        boolean bl = false;
        List list = new ArrayList();
        Object object = list;
        Object object2 = this.client.interceptors();
        boolean bl2 = false;
        CollectionsKt.addAll(object, object2);
        object = list;
        object2 = new RetryAndFollowUpInterceptor(this.client);
        bl2 = false;
        object.add(object2);
        object = list;
        object2 = new BridgeInterceptor(this.client.cookieJar());
        bl2 = false;
        object.add(object2);
        object = list;
        object2 = new CacheInterceptor(this.client.cache());
        bl2 = false;
        object.add(object2);
        object = list;
        object2 = ConnectInterceptor.INSTANCE;
        bl2 = false;
        object.add(object2);
        if (!this.forWebSocket) {
            object = list;
            object2 = this.client.networkInterceptors();
            bl2 = false;
            CollectionsKt.addAll(object, object2);
        }
        object = list;
        object2 = new CallServerInterceptor(this.forWebSocket);
        bl2 = false;
        object.add(object2);
        object = new RealInterceptorChain(this, list, 0, null, this.originalRequest, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean bl3 = false;
        try {
            Response response2 = ((RealInterceptorChain)object).proceed(this.originalRequest);
            if (this.isCanceled()) {
                Util.closeQuietly(response2);
                throw (Throwable)new IOException("Canceled");
            }
            response = response2;
        }
        catch (IOException iOException) {
            try {
                bl3 = true;
                IOException iOException2 = this.noMoreExchanges$okhttp(iOException);
                if (iOException2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                }
                throw (Throwable)iOException2;
            }
            catch (Throwable throwable) {
                if (!bl3) {
                    this.noMoreExchanges$okhttp(null);
                }
                throw throwable;
            }
        }
        this.noMoreExchanges$okhttp(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterNetworkInterceptorExchange(@NotNull Request request, boolean bl) {
        Intrinsics.checkNotNullParameter(request, "request");
        boolean bl2 = this.interceptorScopedExchange == null;
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        RealCall realCall = this;
        bl3 = false;
        bl4 = false;
        synchronized (realCall) {
            bl5 = false;
            boolean bl7 = !this.responseBodyOpen;
            boolean bl8 = false;
            boolean bl9 = false;
            if (!bl7) {
                boolean bl10 = false;
                String string = "cannot make a new request because the previous response is still open: please call response.close()";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl7 = !this.requestBodyOpen;
            bl8 = false;
            bl9 = false;
            bl9 = false;
            boolean bl11 = false;
            if (!bl7) {
                boolean bl12 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bl) {
            this.exchangeFinder = new ExchangeFinder(this.connectionPool, this.createAddress(request.url()), this, this.eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Exchange initExchange$okhttp(@NotNull RealInterceptorChain realInterceptorChain) {
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3;
        Intrinsics.checkNotNullParameter(realInterceptorChain, "chain");
        Object object2 = this;
        boolean bl4 = false;
        boolean bl5 = false;
        synchronized (object2) {
            boolean bl6 = false;
            bl3 = this.expectMoreExchanges;
            bl2 = false;
            bl = false;
            if (!bl3) {
                boolean bl7 = false;
                String string = "released";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl3 = !this.responseBodyOpen;
            bl2 = false;
            bl = false;
            bl = false;
            boolean bl8 = false;
            if (!bl3) {
                boolean bl9 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl3 = !this.requestBodyOpen;
            bl2 = false;
            bl = false;
            bl = false;
            bl8 = false;
            if (!bl3) {
                boolean bl10 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            object = Unit.INSTANCE;
        }
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull(exchangeFinder);
        object2 = exchangeFinder;
        ExchangeCodec exchangeCodec = ((ExchangeFinder)object2).find(this.client, realInterceptorChain);
        this.interceptorScopedExchange = object = new Exchange(this, this.eventListener, (ExchangeFinder)object2, exchangeCodec);
        this.exchange = object;
        RealCall realCall = this;
        bl3 = false;
        bl2 = false;
        synchronized (realCall) {
            bl = false;
            this.requestBodyOpen = true;
            this.responseBodyOpen = true;
            Unit unit = Unit.INSTANCE;
        }
        if (this.canceled) {
            throw (Throwable)new IOException("Canceled");
        }
        return object;
    }

    public final void acquireConnectionNoEvents(@NotNull RealConnection realConnection) {
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        RealConnection realConnection2 = realConnection;
        boolean bl = false;
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection2)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST hold lock on ").append(realConnection2).toString()));
        }
        boolean bl2 = this.connection == null;
        bl = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.connection = realConnection;
        realConnection.getCalls().add(new CallReference(this, this.callStackTrace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends IOException> E messageDone$okhttp(@NotNull Exchange exchange, boolean bl, boolean bl2, E e) {
        Intrinsics.checkNotNullParameter(exchange, "exchange");
        if (Intrinsics.areEqual(exchange, this.exchange) ^ true) {
            return e;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        RealCall realCall = this;
        boolean bl5 = false;
        boolean bl6 = false;
        synchronized (realCall) {
            boolean bl7 = false;
            if (bl && this.requestBodyOpen || bl2 && this.responseBodyOpen) {
                if (bl) {
                    this.requestBodyOpen = false;
                }
                if (bl2) {
                    this.responseBodyOpen = false;
                }
                bl3 = !this.requestBodyOpen && !this.responseBodyOpen;
                bl4 = !this.requestBodyOpen && !this.responseBodyOpen && !this.expectMoreExchanges;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bl3) {
            this.exchange = null;
            RealConnection realConnection = this.connection;
            if (realConnection != null) {
                realConnection.incrementSuccessCount$okhttp();
            }
        }
        if (bl4) {
            return this.callDone(e);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IOException noMoreExchanges$okhttp(@Nullable IOException iOException) {
        boolean bl = false;
        RealCall realCall = this;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (realCall) {
            boolean bl4 = false;
            if (this.expectMoreExchanges) {
                this.expectMoreExchanges = false;
                bl = !this.requestBodyOpen && !this.responseBodyOpen;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bl) {
            return this.callDone(iOException);
        }
        return iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <E extends IOException> E callDone(E e) {
        Object object = this;
        boolean bl = false;
        if (Util.assertionsEnabled && Thread.holdsLock(object)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST NOT hold lock on ").append(object).toString()));
        }
        object = this.connection;
        if (object != null) {
            Socket socket;
            boolean bl2;
            Object object2 = object;
            boolean bl3 = false;
            if (Util.assertionsEnabled && Thread.holdsLock(object2)) {
                StringBuilder stringBuilder = new StringBuilder().append("Thread ");
                Thread thread3 = Thread.currentThread();
                Intrinsics.checkNotNullExpressionValue(thread3, "Thread.currentThread()");
                throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread3.getName()).append(" MUST NOT hold lock on ").append(object2).toString()));
            }
            bl3 = false;
            boolean bl4 = false;
            synchronized (object) {
                bl2 = false;
                socket = this.releaseConnectionNoEvents$okhttp();
            }
            object2 = socket;
            if (this.connection == null) {
                Object object3 = object2;
                if (object3 != null) {
                    Util.closeQuietly((Socket)object3);
                }
                this.eventListener.connectionReleased(this, (Connection)object);
            } else {
                bl3 = object2 == null;
                boolean bl5 = false;
                bl2 = false;
                bl2 = false;
                boolean bl6 = false;
                if (!bl3) {
                    boolean bl7 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        E e2 = this.timeoutExit(e);
        if (e != null) {
            Call call = this;
            E e3 = e2;
            Intrinsics.checkNotNull(e3);
            this.eventListener.callFailed(call, e3);
        } else {
            this.eventListener.callEnd(this);
        }
        return e2;
    }

    @Nullable
    public final Socket releaseConnectionNoEvents$okhttp() {
        int n;
        int n2;
        boolean bl;
        int n3;
        Object object;
        RealConnection realConnection;
        block6: {
            RealConnection realConnection2 = this.connection;
            Intrinsics.checkNotNull(realConnection2);
            realConnection = realConnection2;
            object = realConnection;
            n3 = 0;
            if (Util.assertionsEnabled && !Thread.holdsLock(object)) {
                StringBuilder stringBuilder = new StringBuilder().append("Thread ");
                Thread thread2 = Thread.currentThread();
                Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
                throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST hold lock on ").append(object).toString()));
            }
            Object object2 = object = realConnection.getCalls();
            bl = false;
            n2 = 0;
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Reference reference = (Reference)e;
                boolean bl2 = false;
                if (Intrinsics.areEqual((RealCall)reference.get(), this)) {
                    n = n2;
                    break block6;
                }
                ++n2;
            }
            n = -1;
        }
        n3 = n;
        boolean bl3 = n3 != -1;
        bl = false;
        n2 = 0;
        n2 = 0;
        boolean bl4 = false;
        if (!bl3) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        object.remove(n3);
        this.connection = null;
        if (object.isEmpty()) {
            realConnection.setIdleAtNs$okhttp(System.nanoTime());
            if (this.connectionPool.connectionBecameIdle(realConnection)) {
                return realConnection.socket();
            }
        }
        return null;
    }

    private final <E extends IOException> E timeoutExit(E e) {
        if (this.timeoutEarlyExit) {
            return e;
        }
        if (!this.timeout.exit()) {
            return e;
        }
        InterruptedIOException interruptedIOException = new InterruptedIOException("timeout");
        if (e != null) {
            interruptedIOException.initCause(e);
        }
        return (E)interruptedIOException;
    }

    public final void timeoutEarlyExit() {
        boolean bl = !this.timeoutEarlyExit;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.timeoutEarlyExit = true;
        this.timeout.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exitNetworkInterceptorExchange$okhttp(boolean bl) {
        RealCall realCall = this;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (realCall) {
            boolean bl4 = false;
            boolean bl5 = this.expectMoreExchanges;
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl5) {
                boolean bl8 = false;
                String string = "released";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bl) {
            Exchange exchange = this.exchange;
            if (exchange != null) {
                exchange.detachWithViolence();
            }
        }
        this.interceptorScopedExchange = null;
    }

    private final Address createAddress(HttpUrl httpUrl) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (httpUrl.isHttps()) {
            sSLSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(httpUrl.host(), httpUrl.port(), this.client.dns(), this.client.socketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    public final boolean retryAfterFailure() {
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull(exchangeFinder);
        return exchangeFinder.retryAfterFailure();
    }

    private final String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl$okhttp();
    }

    @NotNull
    public final String redactedUrl$okhttp() {
        return this.originalRequest.url().redact();
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @NotNull
    public final Request getOriginalRequest() {
        return this.originalRequest;
    }

    public final boolean getForWebSocket() {
        return this.forWebSocket;
    }

    public RealCall(@NotNull OkHttpClient okHttpClient, @NotNull Request request, boolean bl) {
        Intrinsics.checkNotNullParameter(okHttpClient, "client");
        Intrinsics.checkNotNullParameter(request, "originalRequest");
        this.client = okHttpClient;
        this.originalRequest = request;
        this.forWebSocket = bl;
        this.connectionPool = this.client.connectionPool().getDelegate$okhttp();
        this.eventListener = this.client.eventListenerFactory().create(this);
        AsyncTimeout asyncTimeout = new AsyncTimeout(this){
            final /* synthetic */ RealCall this$0;

            protected void timedOut() {
                this.this$0.cancel();
            }
            {
                this.this$0 = realCall;
            }
        };
        boolean bl2 = false;
        boolean bl3 = false;
        AsyncTimeout asyncTimeout2 = asyncTimeout;
        RealCall realCall = this;
        boolean bl4 = false;
        asyncTimeout2.timeout(this.client.callTimeoutMillis(), TimeUnit.MILLISECONDS);
        Unit unit = Unit.INSTANCE;
        realCall.timeout = asyncTimeout;
        this.executed = new AtomicBoolean();
        this.expectMoreExchanges = true;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u0000R\u00020\u0006J\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lokhttp3/internal/connection/RealCall$AsyncCall;", "Ljava/lang/Runnable;", "responseCallback", "Lokhttp3/Callback;", "(Lokhttp3/internal/connection/RealCall;Lokhttp3/Callback;)V", "call", "Lokhttp3/internal/connection/RealCall;", "getCall", "()Lokhttp3/internal/connection/RealCall;", "<set-?>", "Ljava/util/concurrent/atomic/AtomicInteger;", "callsPerHost", "getCallsPerHost", "()Ljava/util/concurrent/atomic/AtomicInteger;", "host", "", "getHost", "()Ljava/lang/String;", "request", "Lokhttp3/Request;", "getRequest", "()Lokhttp3/Request;", "executeOn", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "reuseCallsPerHostFrom", "other", "run", "okhttp"})
    public final class AsyncCall
    implements Runnable {
        @NotNull
        private volatile AtomicInteger callsPerHost;
        private final Callback responseCallback;

        @NotNull
        public final AtomicInteger getCallsPerHost() {
            return this.callsPerHost;
        }

        public final void reuseCallsPerHostFrom(@NotNull AsyncCall asyncCall) {
            Intrinsics.checkNotNullParameter(asyncCall, "other");
            this.callsPerHost = asyncCall.callsPerHost;
        }

        @NotNull
        public final String getHost() {
            return RealCall.this.getOriginalRequest().url().host();
        }

        @NotNull
        public final Request getRequest() {
            return RealCall.this.getOriginalRequest();
        }

        @NotNull
        public final RealCall getCall() {
            return RealCall.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void executeOn(@NotNull ExecutorService executorService) {
            Intrinsics.checkNotNullParameter(executorService, "executorService");
            Dispatcher dispatcher = RealCall.this.getClient().dispatcher();
            boolean bl = false;
            if (Util.assertionsEnabled && Thread.holdsLock(dispatcher)) {
                StringBuilder stringBuilder = new StringBuilder().append("Thread ");
                Thread thread2 = Thread.currentThread();
                Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
                throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST NOT hold lock on ").append(dispatcher).toString()));
            }
            boolean bl2 = false;
            try {
                executorService.execute(this);
                bl2 = true;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                InterruptedIOException interruptedIOException = new InterruptedIOException("executor rejected");
                interruptedIOException.initCause(rejectedExecutionException);
                RealCall.this.noMoreExchanges$okhttp(interruptedIOException);
                this.responseCallback.onFailure(RealCall.this, interruptedIOException);
            }
            finally {
                RealCall.this.getClient().dispatcher().finished$okhttp(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread2;
            String string = "OkHttp " + RealCall.this.redactedUrl$okhttp();
            boolean bl = false;
            Thread thread3 = thread2 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread3, "currentThread");
            String string2 = thread3.getName();
            thread2.setName(string);
            try {
                boolean bl2 = false;
                boolean bl3 = false;
                RealCall.this.timeout.enter();
                try {
                    Response response = RealCall.this.getResponseWithInterceptorChain$okhttp();
                    bl3 = true;
                    this.responseCallback.onResponse(RealCall.this, response);
                }
                catch (IOException iOException) {
                    if (bl3) {
                        Platform.Companion.get().log("Callback failure for " + RealCall.this.toLoggableString(), 4, iOException);
                    } else {
                        this.responseCallback.onFailure(RealCall.this, iOException);
                    }
                }
                catch (Throwable throwable) {
                    RealCall.this.cancel();
                    if (!bl3) {
                        IOException iOException = new IOException("canceled due to " + throwable);
                        ExceptionsKt.addSuppressed(iOException, throwable);
                        this.responseCallback.onFailure(RealCall.this, iOException);
                    }
                    throw throwable;
                }
                finally {
                    RealCall.this.getClient().dispatcher().finished$okhttp(this);
                }
            }
            finally {
                thread2.setName(string2);
            }
        }

        public AsyncCall(@NotNull Callback callback) {
            Intrinsics.checkNotNullParameter(callback, "responseCallback");
            this.responseCallback = callback;
            this.callsPerHost = new AtomicInteger(0);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lokhttp3/internal/connection/RealCall$CallReference;", "Ljava/lang/ref/WeakReference;", "Lokhttp3/internal/connection/RealCall;", "referent", "callStackTrace", "", "(Lokhttp3/internal/connection/RealCall;Ljava/lang/Object;)V", "getCallStackTrace", "()Ljava/lang/Object;", "okhttp"})
    public static final class CallReference
    extends WeakReference<RealCall> {
        @Nullable
        private final Object callStackTrace;

        @Nullable
        public final Object getCallStackTrace() {
            return this.callStackTrace;
        }

        public CallReference(@NotNull RealCall realCall, @Nullable Object object) {
            Intrinsics.checkNotNullParameter(realCall, "referent");
            super(realCall);
            this.callStackTrace = object;
        }
    }
}

