/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.StreamResetException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ0\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0002J8\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0002J\u0006\u0010'\u001a\u00020$J\n\u0010(\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lokhttp3/internal/connection/ExchangeFinder;", "", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "address", "Lokhttp3/Address;", "call", "Lokhttp3/internal/connection/RealCall;", "eventListener", "Lokhttp3/EventListener;", "(Lokhttp3/internal/connection/RealConnectionPool;Lokhttp3/Address;Lokhttp3/internal/connection/RealCall;Lokhttp3/EventListener;)V", "getAddress$okhttp", "()Lokhttp3/Address;", "connectionShutdownCount", "", "nextRouteToTry", "Lokhttp3/Route;", "otherFailureCount", "refusedStreamCount", "routeSelection", "Lokhttp3/internal/connection/RouteSelector$Selection;", "routeSelector", "Lokhttp3/internal/connection/RouteSelector;", "find", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "findConnection", "Lokhttp3/internal/connection/RealConnection;", "connectTimeout", "readTimeout", "writeTimeout", "pingIntervalMillis", "connectionRetryEnabled", "", "findHealthyConnection", "doExtensiveHealthChecks", "retryAfterFailure", "retryRoute", "sameHostAndPort", "url", "Lokhttp3/HttpUrl;", "trackFailure", "", "e", "Ljava/io/IOException;", "okhttp"})
public final class ExchangeFinder {
    private RouteSelector.Selection routeSelection;
    private RouteSelector routeSelector;
    private int refusedStreamCount;
    private int connectionShutdownCount;
    private int otherFailureCount;
    private Route nextRouteToTry;
    private final RealConnectionPool connectionPool;
    @NotNull
    private final Address address;
    private final RealCall call;
    private final EventListener eventListener;

    @NotNull
    public final ExchangeCodec find(@NotNull OkHttpClient okHttpClient, @NotNull RealInterceptorChain realInterceptorChain) {
        Intrinsics.checkNotNullParameter(okHttpClient, "client");
        Intrinsics.checkNotNullParameter(realInterceptorChain, "chain");
        try {
            RealConnection realConnection = this.findHealthyConnection(realInterceptorChain.getConnectTimeoutMillis$okhttp(), realInterceptorChain.getReadTimeoutMillis$okhttp(), realInterceptorChain.getWriteTimeoutMillis$okhttp(), okHttpClient.pingIntervalMillis(), okHttpClient.retryOnConnectionFailure(), Intrinsics.areEqual(realInterceptorChain.getRequest$okhttp().method(), "GET") ^ true);
            return realConnection.newCodec$okhttp(okHttpClient, realInterceptorChain);
        }
        catch (RouteException routeException) {
            this.trackFailure(routeException.getLastConnectException());
            throw (Throwable)routeException;
        }
        catch (IOException iOException) {
            this.trackFailure(iOException);
            throw (Throwable)new RouteException(iOException);
        }
    }

    private final RealConnection findHealthyConnection(int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws IOException {
        while (true) {
            boolean bl3;
            boolean bl4;
            RealConnection realConnection;
            if ((realConnection = this.findConnection(n, n2, n3, n4, bl)).isHealthy(bl2)) {
                return realConnection;
            }
            realConnection.noNewExchanges$okhttp();
            if (this.nextRouteToTry != null) continue;
            RouteSelector.Selection selection = this.routeSelection;
            boolean bl5 = bl4 = selection != null ? selection.hasNext() : true;
            if (bl4) continue;
            RouteSelector routeSelector = this.routeSelector;
            boolean bl6 = bl3 = routeSelector != null ? routeSelector.hasNext() : true;
            if (!bl3) break;
        }
        throw (Throwable)new IOException("exhausted all routes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final RealConnection findConnection(int var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) throws IOException {
        block24: {
            block23: {
                if (this.call.isCanceled()) {
                    throw (Throwable)new IOException("Canceled");
                }
                var6_6 = this.call.getConnection();
                if (var6_6 != null) {
                    var7_7 = null;
                    var8_8 = false;
                    var9_10 = false;
                    synchronized (var6_6) {
                        var10_14 = false;
                        if (var6_6.getNoNewExchanges() || !this.sameHostAndPort(var6_6.route().address().url())) {
                            var7_7 = this.call.releaseConnectionNoEvents$okhttp();
                        }
                        var9_11 = Unit.INSTANCE;
                    }
                    if (this.call.getConnection() != null) {
                        var8_8 = var7_7 == null;
                        var9_13 = false;
                        var10_14 = false;
                        var10_14 = false;
                        var11_18 = false;
                        if (!var8_8) {
                            var12_24 = false;
                            var11_19 = "Check failed.";
                            throw (Throwable)new IllegalStateException(var11_19.toString());
                        }
                        return var6_6;
                    }
                    v0 = var7_7;
                    if (v0 != null) {
                        Util.closeQuietly((Socket)v0);
                    }
                    this.eventListener.connectionReleased(this.call, var6_6);
                }
                this.refusedStreamCount = 0;
                this.connectionShutdownCount = 0;
                this.otherFailureCount = 0;
                if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, null, false)) {
                    v1 = this.call.getConnection();
                    Intrinsics.checkNotNull(v1);
                    var7_7 = v1;
                    this.eventListener.connectionAcquired(this.call, (Connection)var7_7);
                    return var7_7;
                }
                var7_7 = null;
                var8_9 = null;
                if (this.nextRouteToTry == null) break block23;
                var7_7 = null;
                v2 = this.nextRouteToTry;
                Intrinsics.checkNotNull(v2);
                var8_9 = v2;
                this.nextRouteToTry = null;
                break block24;
            }
            if (this.routeSelection == null) ** GOTO lbl-1000
            v3 = this.routeSelection;
            Intrinsics.checkNotNull(v3);
            if (v3.hasNext()) {
                var7_7 = null;
                v4 = this.routeSelection;
                Intrinsics.checkNotNull(v4);
                var8_9 = v4.next();
            } else lbl-1000:
            // 2 sources

            {
                if ((var9_11 = this.routeSelector) == null) {
                    this.routeSelector = var9_11 = new RouteSelector(this.address, this.call.getClient().getRouteDatabase(), this.call, this.eventListener);
                }
                this.routeSelection = var10_15 = var9_11.next();
                var7_7 = var10_15.getRoutes();
                if (this.call.isCanceled()) {
                    throw (Throwable)new IOException("Canceled");
                }
                if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, var7_7, false)) {
                    v5 = this.call.getConnection();
                    Intrinsics.checkNotNull(v5);
                    var11_20 = v5;
                    this.eventListener.connectionAcquired(this.call, var11_20);
                    return var11_20;
                }
                var8_9 = var10_15.next();
            }
        }
        var9_11 = new RealConnection(this.connectionPool, var8_9);
        this.call.setConnectionToCancel((RealConnection)var9_11);
        try {
            var9_11.connect(var1_1, var2_2, var3_3, var4_4, var5_5, this.call, this.eventListener);
        }
        finally {
            this.call.setConnectionToCancel(null);
        }
        this.call.getClient().getRouteDatabase().connected(var9_11.route());
        if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, var7_7, true)) {
            v6 = this.call.getConnection();
            Intrinsics.checkNotNull(v6);
            var10_17 = v6;
            this.nextRouteToTry = var8_9;
            Util.closeQuietly(var9_11.socket());
            this.eventListener.connectionAcquired(this.call, var10_17);
            return var10_17;
        }
        var10_14 = false;
        var11_21 = false;
        synchronized (var9_11) {
            var12_25 = false;
            this.connectionPool.put((RealConnection)var9_11);
            this.call.acquireConnectionNoEvents((RealConnection)var9_11);
            var11_22 = Unit.INSTANCE;
        }
        this.eventListener.connectionAcquired(this.call, (Connection)var9_11);
        return var9_11;
    }

    public final void trackFailure(@NotNull IOException iOException) {
        Intrinsics.checkNotNullParameter(iOException, "e");
        this.nextRouteToTry = null;
        if (iOException instanceof StreamResetException && ((StreamResetException)iOException).errorCode == ErrorCode.REFUSED_STREAM) {
            int n = this.refusedStreamCount;
            this.refusedStreamCount = n + 1;
        } else if (iOException instanceof ConnectionShutdownException) {
            int n = this.connectionShutdownCount;
            this.connectionShutdownCount = n + 1;
        } else {
            int n = this.otherFailureCount;
            this.otherFailureCount = n + 1;
        }
    }

    public final boolean retryAfterFailure() {
        if (this.refusedStreamCount == 0 && this.connectionShutdownCount == 0 && this.otherFailureCount == 0) {
            return false;
        }
        if (this.nextRouteToTry != null) {
            return true;
        }
        Route route = this.retryRoute();
        if (route != null) {
            this.nextRouteToTry = route;
            return true;
        }
        RouteSelector.Selection selection = this.routeSelection;
        if (selection != null) {
            if (selection.hasNext()) {
                return true;
            }
        }
        RouteSelector routeSelector = this.routeSelector;
        if (routeSelector == null) {
            return true;
        }
        RouteSelector routeSelector2 = routeSelector;
        return routeSelector2.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Route retryRoute() {
        if (this.refusedStreamCount > 1 || this.connectionShutdownCount > 1 || this.otherFailureCount > 0) {
            return null;
        }
        RealConnection realConnection = this.call.getConnection();
        if (realConnection == null) {
            return null;
        }
        RealConnection realConnection2 = realConnection;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnection2) {
            block8: {
                block7: {
                    boolean bl3 = false;
                    if (realConnection2.getRouteFailureCount$okhttp() == 0) break block7;
                    Route route = null;
                    return route;
                }
                if (Util.canReuseConnectionFor(realConnection2.route().address().url(), this.address.url())) break block8;
                Route route = null;
                return route;
            }
            Route route = realConnection2.route();
            return route;
        }
    }

    public final boolean sameHostAndPort(@NotNull HttpUrl httpUrl) {
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        HttpUrl httpUrl2 = this.address.url();
        return httpUrl.port() == httpUrl2.port() && Intrinsics.areEqual(httpUrl.host(), httpUrl2.host());
    }

    @NotNull
    public final Address getAddress$okhttp() {
        return this.address;
    }

    public ExchangeFinder(@NotNull RealConnectionPool realConnectionPool, @NotNull Address address, @NotNull RealCall realCall, @NotNull EventListener eventListener) {
        Intrinsics.checkNotNullParameter(realConnectionPool, "connectionPool");
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(realCall, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        this.connectionPool = realConnectionPool;
        this.address = address;
        this.call = realCall;
        this.eventListener = eventListener;
    }
}

