/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.MediaType;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0004J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J@\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00110\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00170\u0014H\u0082\b\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH&J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&J\b\u0010\u001d\u001a\u00020\u0015H&J\u0006\u0010\u001e\u001a\u00020\u001fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lokhttp3/ResponseBody;", "Ljava/io/Closeable;", "()V", "reader", "Ljava/io/Reader;", "byteStream", "Ljava/io/InputStream;", "byteString", "Lokio/ByteString;", "bytes", "", "charStream", "charset", "Ljava/nio/charset/Charset;", "close", "", "consumeSource", "T", "", "consumer", "Lkotlin/Function1;", "Lokio/BufferedSource;", "sizeMapper", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "source", "string", "", "BomAwareReader", "Companion", "okhttp"})
public abstract class ResponseBody
implements Closeable {
    private Reader reader;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract MediaType contentType();

    public abstract long contentLength();

    @NotNull
    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    @NotNull
    public abstract BufferedSource source();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] bytes() throws IOException {
        Object object;
        Object object2;
        ResponseBody responseBody = this;
        boolean bl = false;
        long l = responseBody.contentLength();
        if (l > (long)Integer.MAX_VALUE) {
            throw (Throwable)new IOException("Cannot buffer entire body for content length: " + l);
        }
        Closeable closeable = responseBody.source();
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            object2 = (BufferedSource)closeable;
            boolean bl4 = false;
            object2 = object2.readByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Object object3 = object = object2;
        boolean bl5 = false;
        int n = ((Object)object3).length;
        if (l != -1L && l != (long)n) {
            throw (Throwable)new IOException("Content-Length (" + l + ") and stream length (" + n + ") disagree");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ByteString byteString() throws IOException {
        Object object;
        Object object2;
        ResponseBody responseBody = this;
        boolean bl = false;
        long l = responseBody.contentLength();
        if (l > (long)Integer.MAX_VALUE) {
            throw (Throwable)new IOException("Cannot buffer entire body for content length: " + l);
        }
        Closeable closeable = responseBody.source();
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            object2 = (BufferedSource)closeable;
            boolean bl4 = false;
            object2 = object2.readByteString();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Object object3 = object = object2;
        boolean bl5 = false;
        int n = ((ByteString)object3).size();
        if (l != -1L && l != (long)n) {
            throw (Throwable)new IOException("Content-Length (" + l + ") and stream length (" + n + ") disagree");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T consumeSource(Function1<? super BufferedSource, ? extends T> function1, Function1<? super T, Integer> function12) {
        T t2;
        int n = 0;
        long l = this.contentLength();
        if (l > (long)Integer.MAX_VALUE) {
            throw (Throwable)new IOException("Cannot buffer entire body for content length: " + l);
        }
        Closeable closeable = this.source();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            t2 = function1.invoke((BufferedSource)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart(1);
            CloseableKt.closeFinally(closeable, throwable);
            InlineMarker.finallyEnd(1);
        }
        T t3 = t2;
        int n2 = ((Number)function12.invoke(t3)).intValue();
        if (l != -1L && l != (long)n2) {
            throw (Throwable)new IOException("Content-Length (" + l + ") and stream length (" + n2 + ") disagree");
        }
        return t3;
    }

    @NotNull
    public final Reader charStream() {
        Reader reader = this.reader;
        if (reader == null) {
            BomAwareReader bomAwareReader = new BomAwareReader(this.source(), this.charset());
            boolean bl = false;
            boolean bl2 = false;
            BomAwareReader bomAwareReader2 = bomAwareReader;
            boolean bl3 = false;
            this.reader = bomAwareReader2;
            reader = bomAwareReader;
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String string() throws IOException {
        Object object;
        Closeable closeable = this.source();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            object = (BufferedSource)closeable;
            boolean bl3 = false;
            object = object.readString(Util.readBomAsCharset((BufferedSource)object, this.charset()));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return object;
    }

    private final Charset charset() {
        Object object = this.contentType();
        if (object == null || (object = ((MediaType)object).charset(Charsets.UTF_8)) == null) {
            object = Charsets.UTF_8;
        }
        return object;
    }

    @Override
    public void close() {
        Util.closeQuietly(this.source());
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final ResponseBody create(@NotNull String string, @Nullable MediaType mediaType) {
        return Companion.create(string, mediaType);
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final ResponseBody create(@NotNull byte[] byArray, @Nullable MediaType mediaType) {
        return Companion.create(byArray, mediaType);
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final ResponseBody create(@NotNull ByteString byteString, @Nullable MediaType mediaType) {
        return Companion.create(byteString, mediaType);
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final ResponseBody create(@NotNull BufferedSource bufferedSource, @Nullable MediaType mediaType, long l) {
        return Companion.create(bufferedSource, mediaType, l);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(imports={"okhttp3.ResponseBody.Companion.toResponseBody"}, expression="content.toResponseBody(contentType)"), level=DeprecationLevel.WARNING)
    @NotNull
    public static final ResponseBody create(@Nullable MediaType mediaType, @NotNull String string) {
        return Companion.create(mediaType, string);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(imports={"okhttp3.ResponseBody.Companion.toResponseBody"}, expression="content.toResponseBody(contentType)"), level=DeprecationLevel.WARNING)
    @NotNull
    public static final ResponseBody create(@Nullable MediaType mediaType, @NotNull byte[] byArray) {
        return Companion.create(mediaType, byArray);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(imports={"okhttp3.ResponseBody.Companion.toResponseBody"}, expression="content.toResponseBody(contentType)"), level=DeprecationLevel.WARNING)
    @NotNull
    public static final ResponseBody create(@Nullable MediaType mediaType, @NotNull ByteString byteString) {
        return Companion.create(mediaType, byteString);
    }

    @JvmStatic
    @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(imports={"okhttp3.ResponseBody.Companion.asResponseBody"}, expression="content.asResponseBody(contentType, contentLength)"), level=DeprecationLevel.WARNING)
    @NotNull
    public static final ResponseBody create(@Nullable MediaType mediaType, long l, @NotNull BufferedSource bufferedSource) {
        return Companion.create(mediaType, l, bufferedSource);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lokhttp3/ResponseBody$BomAwareReader;", "Ljava/io/Reader;", "source", "Lokio/BufferedSource;", "charset", "Ljava/nio/charset/Charset;", "(Lokio/BufferedSource;Ljava/nio/charset/Charset;)V", "closed", "", "delegate", "close", "", "read", "", "cbuf", "", "off", "len", "okhttp"})
    public static final class BomAwareReader
    extends Reader {
        private boolean closed;
        private Reader delegate;
        private final BufferedSource source;
        private final Charset charset;

        @Override
        public int read(@NotNull char[] cArray, int n, int n2) throws IOException {
            Intrinsics.checkNotNullParameter(cArray, "cbuf");
            if (this.closed) {
                throw (Throwable)new IOException("Stream closed");
            }
            Reader reader = this.delegate;
            if (reader == null) {
                InputStreamReader inputStreamReader = new InputStreamReader(this.source.inputStream(), Util.readBomAsCharset(this.source, this.charset));
                boolean bl = false;
                boolean bl2 = false;
                InputStreamReader inputStreamReader2 = inputStreamReader;
                boolean bl3 = false;
                this.delegate = inputStreamReader2;
                reader = inputStreamReader;
            }
            Reader reader2 = reader;
            return reader2.read(cArray, n, n2);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            Reader reader = this.delegate;
            if (reader != null) {
                reader.close();
            } else {
                BomAwareReader bomAwareReader = this;
                boolean bl = false;
                boolean bl2 = false;
                BomAwareReader bomAwareReader2 = bomAwareReader;
                boolean bl3 = false;
                bomAwareReader2.source.close();
            }
        }

        public BomAwareReader(@NotNull BufferedSource bufferedSource, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter(bufferedSource, "source");
            Intrinsics.checkNotNullParameter(charset, "charset");
            this.source = bufferedSource;
            this.charset = charset;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\rH\u0007J'\u0010\u000e\u001a\u00020\u0004*\u00020\u000b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u0003J\u001d\u0010\u000f\u001a\u00020\u0004*\u00020\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\b\u0003J\u001d\u0010\u000f\u001a\u00020\u0004*\u00020\f2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\b\u0003J\u001d\u0010\u000f\u001a\u00020\u0004*\u00020\r2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\b\u0003\u00a8\u0006\u0010"}, d2={"Lokhttp3/ResponseBody$Companion;", "", "()V", "create", "Lokhttp3/ResponseBody;", "contentType", "Lokhttp3/MediaType;", "content", "", "contentLength", "", "Lokio/BufferedSource;", "", "Lokio/ByteString;", "asResponseBody", "toResponseBody", "okhttp"})
    public static final class Companion {
        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final ResponseBody create(@NotNull String string, @Nullable MediaType mediaType) {
            Object object;
            Intrinsics.checkNotNullParameter(string, "$this$toResponseBody");
            Object object2 = Charsets.UTF_8;
            MediaType mediaType2 = mediaType;
            if (mediaType != null) {
                object = MediaType.charset$default(mediaType, null, 1, null);
                if (object == null) {
                    object2 = Charsets.UTF_8;
                    mediaType2 = MediaType.Companion.parse(mediaType + "; charset=utf-8");
                } else {
                    object2 = object;
                }
            }
            object = new Buffer().writeString(string, (Charset)object2);
            return this.create((BufferedSource)object, mediaType2, ((Buffer)object).size());
        }

        public static /* synthetic */ ResponseBody create$default(Companion companion, String string, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.create(string, mediaType);
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final ResponseBody create(@NotNull byte[] byArray, @Nullable MediaType mediaType) {
            Intrinsics.checkNotNullParameter(byArray, "$this$toResponseBody");
            return this.create(new Buffer().write(byArray), mediaType, byArray.length);
        }

        public static /* synthetic */ ResponseBody create$default(Companion companion, byte[] byArray, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.create(byArray, mediaType);
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final ResponseBody create(@NotNull ByteString byteString, @Nullable MediaType mediaType) {
            Intrinsics.checkNotNullParameter(byteString, "$this$toResponseBody");
            return this.create(new Buffer().write(byteString), mediaType, byteString.size());
        }

        public static /* synthetic */ ResponseBody create$default(Companion companion, ByteString byteString, MediaType mediaType, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            return companion.create(byteString, mediaType);
        }

        @JvmStatic
        @JvmName(name="create")
        @NotNull
        public final ResponseBody create(@NotNull BufferedSource bufferedSource, @Nullable MediaType mediaType, long l) {
            Intrinsics.checkNotNullParameter(bufferedSource, "$this$asResponseBody");
            return new ResponseBody(bufferedSource, mediaType, l){
                final /* synthetic */ BufferedSource $this_asResponseBody;
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ long $contentLength;

                @Nullable
                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$contentLength;
                }

                @NotNull
                public BufferedSource source() {
                    return this.$this_asResponseBody;
                }
                {
                    this.$this_asResponseBody = bufferedSource;
                    this.$contentType = mediaType;
                    this.$contentLength = l;
                }
            };
        }

        public static /* synthetic */ ResponseBody create$default(Companion companion, BufferedSource bufferedSource, MediaType mediaType, long l, int n, Object object) {
            if ((n & 1) != 0) {
                mediaType = null;
            }
            if ((n & 2) != 0) {
                l = -1L;
            }
            return companion.create(bufferedSource, mediaType, l);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(imports={"okhttp3.ResponseBody.Companion.toResponseBody"}, expression="content.toResponseBody(contentType)"), level=DeprecationLevel.WARNING)
        @NotNull
        public final ResponseBody create(@Nullable MediaType mediaType, @NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "content");
            return this.create(string, mediaType);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(imports={"okhttp3.ResponseBody.Companion.toResponseBody"}, expression="content.toResponseBody(contentType)"), level=DeprecationLevel.WARNING)
        @NotNull
        public final ResponseBody create(@Nullable MediaType mediaType, @NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter(byArray, "content");
            return this.create(byArray, mediaType);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(imports={"okhttp3.ResponseBody.Companion.toResponseBody"}, expression="content.toResponseBody(contentType)"), level=DeprecationLevel.WARNING)
        @NotNull
        public final ResponseBody create(@Nullable MediaType mediaType, @NotNull ByteString byteString) {
            Intrinsics.checkNotNullParameter(byteString, "content");
            return this.create(byteString, mediaType);
        }

        @JvmStatic
        @Deprecated(message="Moved to extension function. Put the 'content' argument first to fix Java", replaceWith=@ReplaceWith(imports={"okhttp3.ResponseBody.Companion.asResponseBody"}, expression="content.asResponseBody(contentType, contentLength)"), level=DeprecationLevel.WARNING)
        @NotNull
        public final ResponseBody create(@Nullable MediaType mediaType, long l, @NotNull BufferedSource bufferedSource) {
            Intrinsics.checkNotNullParameter(bufferedSource, "content");
            return this.create(bufferedSource, mediaType, l);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

