/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0003\"#$B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\r\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b\u0015J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0012J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\b\u0018J\r\u0010\u0011\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\b\u0019J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u001aJ\u001a\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0014\u00a8\u0006%"}, d2={"Lokhttp3/MultipartBody;", "Lokhttp3/RequestBody;", "boundaryByteString", "Lokio/ByteString;", "type", "Lokhttp3/MediaType;", "parts", "", "Lokhttp3/MultipartBody$Part;", "(Lokio/ByteString;Lokhttp3/MediaType;Ljava/util/List;)V", "boundary", "", "()Ljava/lang/String;", "contentLength", "", "contentType", "()Ljava/util/List;", "size", "", "()I", "()Lokhttp3/MediaType;", "-deprecated_boundary", "part", "index", "-deprecated_parts", "-deprecated_size", "-deprecated_type", "writeOrCountBytes", "sink", "Lokio/BufferedSink;", "countBytes", "", "writeTo", "", "Builder", "Companion", "Part", "okhttp"})
public final class MultipartBody
extends RequestBody {
    private final MediaType contentType;
    private long contentLength;
    private final ByteString boundaryByteString;
    @NotNull
    private final MediaType type;
    @NotNull
    private final List<Part> parts;
    @JvmField
    @NotNull
    public static final MediaType MIXED;
    @JvmField
    @NotNull
    public static final MediaType ALTERNATIVE;
    @JvmField
    @NotNull
    public static final MediaType DIGEST;
    @JvmField
    @NotNull
    public static final MediaType PARALLEL;
    @JvmField
    @NotNull
    public static final MediaType FORM;
    private static final byte[] COLONSPACE;
    private static final byte[] CRLF;
    private static final byte[] DASHDASH;
    public static final Companion Companion;

    @JvmName(name="boundary")
    @NotNull
    public final String boundary() {
        return this.boundaryByteString.utf8();
    }

    @JvmName(name="size")
    public final int size() {
        return this.parts.size();
    }

    @NotNull
    public final Part part(int n) {
        return this.parts.get(n);
    }

    @Override
    @NotNull
    public MediaType contentType() {
        return this.contentType;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="type"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_type")
    @NotNull
    public final MediaType -deprecated_type() {
        return this.type;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="boundary"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_boundary")
    @NotNull
    public final String -deprecated_boundary() {
        return this.boundary();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="size"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_size")
    public final int -deprecated_size() {
        return this.size();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="parts"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_parts")
    @NotNull
    public final List<Part> -deprecated_parts() {
        return this.parts;
    }

    @Override
    public long contentLength() throws IOException {
        long l = this.contentLength;
        if (l == -1L) {
            this.contentLength = l = this.writeOrCountBytes(null, true);
        }
        return l;
    }

    @Override
    public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
        Intrinsics.checkNotNullParameter(bufferedSink, "sink");
        this.writeOrCountBytes(bufferedSink, false);
    }

    private final long writeOrCountBytes(BufferedSink bufferedSink, boolean bl) throws IOException {
        BufferedSink bufferedSink2 = bufferedSink;
        long l = 0L;
        Buffer buffer = null;
        if (bl) {
            buffer = new Buffer();
            bufferedSink2 = buffer;
        }
        int n = this.parts.size();
        for (int i = 0; i < n; ++i) {
            long l2;
            MediaType mediaType;
            Part part = this.parts.get(i);
            Headers headers = part.headers();
            RequestBody requestBody = part.body();
            BufferedSink bufferedSink3 = bufferedSink2;
            Intrinsics.checkNotNull(bufferedSink3);
            bufferedSink3.write(DASHDASH);
            bufferedSink2.write(this.boundaryByteString);
            bufferedSink2.write(CRLF);
            if (headers != null) {
                int n2 = headers.size();
                for (int j = 0; j < n2; ++j) {
                    bufferedSink2.writeUtf8(headers.name(j)).write(COLONSPACE).writeUtf8(headers.value(j)).write(CRLF);
                }
            }
            if ((mediaType = requestBody.contentType()) != null) {
                bufferedSink2.writeUtf8("Content-Type: ").writeUtf8(mediaType.toString()).write(CRLF);
            }
            if ((l2 = requestBody.contentLength()) != -1L) {
                bufferedSink2.writeUtf8("Content-Length: ").writeDecimalLong(l2).write(CRLF);
            } else if (bl) {
                Buffer buffer2 = buffer;
                Intrinsics.checkNotNull(buffer2);
                buffer2.clear();
                return -1L;
            }
            bufferedSink2.write(CRLF);
            if (bl) {
                l += l2;
            } else {
                requestBody.writeTo(bufferedSink2);
            }
            bufferedSink2.write(CRLF);
        }
        BufferedSink bufferedSink4 = bufferedSink2;
        Intrinsics.checkNotNull(bufferedSink4);
        bufferedSink4.write(DASHDASH);
        bufferedSink2.write(this.boundaryByteString);
        bufferedSink2.write(DASHDASH);
        bufferedSink2.write(CRLF);
        if (bl) {
            Buffer buffer3 = buffer;
            Intrinsics.checkNotNull(buffer3);
            l += buffer3.size();
            buffer.clear();
        }
        return l;
    }

    @JvmName(name="type")
    @NotNull
    public final MediaType type() {
        return this.type;
    }

    @JvmName(name="parts")
    @NotNull
    public final List<Part> parts() {
        return this.parts;
    }

    public MultipartBody(@NotNull ByteString byteString, @NotNull MediaType mediaType, @NotNull List<Part> list) {
        Intrinsics.checkNotNullParameter(byteString, "boundaryByteString");
        Intrinsics.checkNotNullParameter(mediaType, "type");
        Intrinsics.checkNotNullParameter(list, "parts");
        this.boundaryByteString = byteString;
        this.type = mediaType;
        this.parts = list;
        this.contentType = MediaType.Companion.get(this.type + "; boundary=" + this.boundary());
        this.contentLength = -1L;
    }

    static {
        Companion = new Companion(null);
        MIXED = MediaType.Companion.get("multipart/mixed");
        ALTERNATIVE = MediaType.Companion.get("multipart/alternative");
        DIGEST = MediaType.Companion.get("multipart/digest");
        PARALLEL = MediaType.Companion.get("multipart/parallel");
        FORM = MediaType.Companion.get("multipart/form-data");
        COLONSPACE = new byte[]{(byte)58, (byte)32};
        CRLF = new byte[]{(byte)13, (byte)10};
        DASHDASH = new byte[]{(byte)45, (byte)45};
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0019\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\tJ\u000f\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\b\nR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\b\u00a8\u0006\f"}, d2={"Lokhttp3/MultipartBody$Part;", "", "headers", "Lokhttp3/Headers;", "body", "Lokhttp3/RequestBody;", "(Lokhttp3/Headers;Lokhttp3/RequestBody;)V", "()Lokhttp3/RequestBody;", "()Lokhttp3/Headers;", "-deprecated_body", "-deprecated_headers", "Companion", "okhttp"})
    public static final class Part {
        @Nullable
        private final Headers headers;
        @NotNull
        private final RequestBody body;
        public static final Companion Companion = new Companion(null);

        @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="headers"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_headers")
        @Nullable
        public final Headers -deprecated_headers() {
            return this.headers;
        }

        @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="body"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_body")
        @NotNull
        public final RequestBody -deprecated_body() {
            return this.body;
        }

        @JvmName(name="headers")
        @Nullable
        public final Headers headers() {
            return this.headers;
        }

        @JvmName(name="body")
        @NotNull
        public final RequestBody body() {
            return this.body;
        }

        private Part(Headers headers, RequestBody requestBody) {
            this.headers = headers;
            this.body = requestBody;
        }

        public /* synthetic */ Part(Headers headers, RequestBody requestBody, DefaultConstructorMarker defaultConstructorMarker) {
            this(headers, requestBody);
        }

        @JvmStatic
        @NotNull
        public static final Part create(@NotNull RequestBody requestBody) {
            return Companion.create(requestBody);
        }

        @JvmStatic
        @NotNull
        public static final Part create(@Nullable Headers headers, @NotNull RequestBody requestBody) {
            return Companion.create(headers, requestBody);
        }

        @JvmStatic
        @NotNull
        public static final Part createFormData(@NotNull String string, @NotNull String string2) {
            return Companion.createFormData(string, string2);
        }

        @JvmStatic
        @NotNull
        public static final Part createFormData(@NotNull String string, @Nullable String string2, @NotNull RequestBody requestBody) {
            return Companion.createFormData(string, string2, requestBody);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007J\"\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u000e"}, d2={"Lokhttp3/MultipartBody$Part$Companion;", "", "()V", "create", "Lokhttp3/MultipartBody$Part;", "headers", "Lokhttp3/Headers;", "body", "Lokhttp3/RequestBody;", "createFormData", "name", "", "value", "filename", "okhttp"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final Part create(@NotNull RequestBody requestBody) {
                Intrinsics.checkNotNullParameter(requestBody, "body");
                return this.create(null, requestBody);
            }

            @JvmStatic
            @NotNull
            public final Part create(@Nullable Headers headers, @NotNull RequestBody requestBody) {
                Intrinsics.checkNotNullParameter(requestBody, "body");
                Headers headers2 = headers;
                boolean bl = (headers2 != null ? headers2.get("Content-Type") : null) == null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Unexpected header: Content-Type";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                Headers headers3 = headers;
                bl = (headers3 != null ? headers3.get("Content-Length") : null) == null;
                bl2 = false;
                bl3 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "Unexpected header: Content-Length";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                return new Part(headers, requestBody, null);
            }

            @JvmStatic
            @NotNull
            public final Part createFormData(@NotNull String string, @NotNull String string2) {
                Intrinsics.checkNotNullParameter(string, "name");
                Intrinsics.checkNotNullParameter(string2, "value");
                return this.createFormData(string, null, RequestBody.Companion.create$default(RequestBody.Companion, string2, null, 1, null));
            }

            @JvmStatic
            @NotNull
            public final Part createFormData(@NotNull String string, @Nullable String string2, @NotNull RequestBody requestBody) {
                Intrinsics.checkNotNullParameter(string, "name");
                Intrinsics.checkNotNullParameter(requestBody, "body");
                boolean bl = false;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl3 = false;
                boolean bl4 = false;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl5 = false;
                stringBuilder2.append("form-data; name=");
                MultipartBody.Companion.appendQuotedString$okhttp(stringBuilder2, string);
                if (string2 != null) {
                    stringBuilder2.append("; filename=");
                    MultipartBody.Companion.appendQuotedString$okhttp(stringBuilder2, string2);
                }
                String string3 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
                String string4 = string3;
                Headers headers = new Headers.Builder().addUnsafeNonAscii("Content-Disposition", string4).build();
                return this.create(headers, requestBody);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J \u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lokhttp3/MultipartBody$Builder;", "", "boundary", "", "(Ljava/lang/String;)V", "Lokio/ByteString;", "parts", "", "Lokhttp3/MultipartBody$Part;", "type", "Lokhttp3/MediaType;", "addFormDataPart", "name", "value", "filename", "body", "Lokhttp3/RequestBody;", "addPart", "headers", "Lokhttp3/Headers;", "part", "build", "Lokhttp3/MultipartBody;", "setType", "okhttp"})
    public static final class Builder {
        private final ByteString boundary;
        private MediaType type;
        private final List<Part> parts;

        @NotNull
        public final Builder setType(@NotNull MediaType mediaType) {
            Intrinsics.checkNotNullParameter(mediaType, "type");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            boolean bl4 = Intrinsics.areEqual(mediaType.type(), "multipart");
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "multipart != " + mediaType;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            builder2.type = mediaType;
            return builder;
        }

        @NotNull
        public final Builder addPart(@NotNull RequestBody requestBody) {
            Intrinsics.checkNotNullParameter(requestBody, "body");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            builder2.addPart(Part.Companion.create(requestBody));
            return builder;
        }

        @NotNull
        public final Builder addPart(@Nullable Headers headers, @NotNull RequestBody requestBody) {
            Intrinsics.checkNotNullParameter(requestBody, "body");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            builder2.addPart(Part.Companion.create(headers, requestBody));
            return builder;
        }

        @NotNull
        public final Builder addFormDataPart(@NotNull String string, @NotNull String string2) {
            Intrinsics.checkNotNullParameter(string, "name");
            Intrinsics.checkNotNullParameter(string2, "value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            builder2.addPart(Part.Companion.createFormData(string, string2));
            return builder;
        }

        @NotNull
        public final Builder addFormDataPart(@NotNull String string, @Nullable String string2, @NotNull RequestBody requestBody) {
            Intrinsics.checkNotNullParameter(string, "name");
            Intrinsics.checkNotNullParameter(requestBody, "body");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            builder2.addPart(Part.Companion.createFormData(string, string2, requestBody));
            return builder;
        }

        @NotNull
        public final Builder addPart(@NotNull Part part) {
            Intrinsics.checkNotNullParameter(part, "part");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            Collection collection = builder2.parts;
            Part part2 = part;
            boolean bl4 = false;
            collection.add(part2);
            return builder;
        }

        @NotNull
        public final MultipartBody build() {
            Collection collection = this.parts;
            boolean bl = false;
            boolean bl2 = !collection.isEmpty();
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "Multipart body must have at least one part.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return new MultipartBody(this.boundary, this.type, Util.toImmutableList(this.parts));
        }

        @JvmOverloads
        public Builder(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "boundary");
            this.boundary = ByteString.Companion.encodeUtf8(string);
            this.type = MIXED;
            boolean bl = false;
            this.parts = new ArrayList();
        }

        public /* synthetic */ Builder(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                String string2 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue(string2, "UUID.randomUUID().toString()");
                string = string2;
            }
            this(string);
        }

        @JvmOverloads
        public Builder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\r\u001a\u00020\u000e*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokhttp3/MultipartBody$Companion;", "", "()V", "ALTERNATIVE", "Lokhttp3/MediaType;", "COLONSPACE", "", "CRLF", "DASHDASH", "DIGEST", "FORM", "MIXED", "PARALLEL", "appendQuotedString", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "key", "", "appendQuotedString$okhttp", "okhttp"})
    public static final class Companion {
        public final void appendQuotedString$okhttp(@NotNull StringBuilder stringBuilder, @NotNull String string) {
            Intrinsics.checkNotNullParameter(stringBuilder, "$this$appendQuotedString");
            Intrinsics.checkNotNullParameter(string, "key");
            stringBuilder.append('\"');
            int n = string.length();
            block5: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\n': {
                        stringBuilder.append("%0A");
                        continue block5;
                    }
                    case '\r': {
                        stringBuilder.append("%0D");
                        continue block5;
                    }
                    case '\"': {
                        stringBuilder.append("%22");
                        continue block5;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            stringBuilder.append('\"');
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

