/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe.header;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.header.CoffHeader;
import com.uqm.crashsight.symtabtool.pe.header.DosHeader;
import com.uqm.crashsight.symtabtool.pe.header.OptionalHeader;

public class Header {
    DosHeader dosHeader;
    long signature;
    CoffHeader coffHeader;
    OptionalHeader optionalHeader;
    public static final long SIZEOF_PE_MAGIC = 4L;
    public static final long SIZEOF_COFF_HEADER = 20L;
    public static final long COFF_MACHINE_X86_64 = 34404L;

    public static Header parse(ParseBuffer parseBuffer) {
        Header header = new Header();
        header.dosHeader = DosHeader.parse(parseBuffer);
        parseBuffer.pos(header.dosHeader.pePointer);
        header.coffHeader = CoffHeader.parse(parseBuffer);
        if (header.coffHeader.size_of_optional_header > 0) {
            header.optionalHeader = OptionalHeader.parse(parseBuffer);
        }
        return header;
    }

    public DosHeader getDosHeader() {
        return this.dosHeader;
    }

    public long getSignature() {
        return this.signature;
    }

    public CoffHeader getCoffHeader() {
        return this.coffHeader;
    }

    public OptionalHeader getOptionalHeader() {
        return this.optionalHeader;
    }

    public void setDosHeader(DosHeader dosHeader) {
        this.dosHeader = dosHeader;
    }

    public void setSignature(long l) {
        this.signature = l;
    }

    public void setCoffHeader(CoffHeader coffHeader) {
        this.coffHeader = coffHeader;
    }

    public void setOptionalHeader(OptionalHeader optionalHeader) {
        this.optionalHeader = optionalHeader;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Header)) {
            return false;
        }
        Header header = (Header)object;
        if (!header.canEqual(this)) {
            return false;
        }
        if (this.getSignature() != header.getSignature()) {
            return false;
        }
        DosHeader dosHeader = this.getDosHeader();
        DosHeader dosHeader2 = header.getDosHeader();
        if (dosHeader == null ? dosHeader2 != null : !dosHeader.equals(dosHeader2)) {
            return false;
        }
        CoffHeader coffHeader = this.getCoffHeader();
        CoffHeader coffHeader2 = header.getCoffHeader();
        if (coffHeader == null ? coffHeader2 != null : !((Object)coffHeader).equals(coffHeader2)) {
            return false;
        }
        OptionalHeader optionalHeader = this.getOptionalHeader();
        OptionalHeader optionalHeader2 = header.getOptionalHeader();
        return !(optionalHeader == null ? optionalHeader2 != null : !((Object)optionalHeader).equals(optionalHeader2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof Header;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSignature();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        DosHeader dosHeader = this.getDosHeader();
        n2 = n2 * 59 + (dosHeader == null ? 43 : dosHeader.hashCode());
        CoffHeader coffHeader = this.getCoffHeader();
        n2 = n2 * 59 + (coffHeader == null ? 43 : ((Object)coffHeader).hashCode());
        OptionalHeader optionalHeader = this.getOptionalHeader();
        n2 = n2 * 59 + (optionalHeader == null ? 43 : ((Object)optionalHeader).hashCode());
        return n2;
    }

    public String toString() {
        return "Header(dosHeader=" + this.getDosHeader() + ", signature=" + this.getSignature() + ", coffHeader=" + this.getCoffHeader() + ", optionalHeader=" + this.getOptionalHeader() + ")";
    }
}

