/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.tpi.Slice;

public class Header {
    long version;
    long headSize;
    long minimumIndex;
    long maximumIndex;
    long gprecSize;
    int tpiHashStream;
    int tpiHashPadStream;
    long hashKeySize;
    long hashBucketSize;
    Slice hashValues;
    Slice tiOff;
    Slice hashAdj;

    public static Header empty() {
        Header header = new Header();
        header.tiOff = new Slice(0, 0L);
        header.hashAdj = new Slice(0, 0L);
        return header;
    }

    public static Header parse(ParseBuffer parseBuffer) {
        assert (parseBuffer.pos() == 0L);
        if (parseBuffer.isEmpty()) {
            return Header.empty();
        }
        Header header = new Header();
        header.version = parseBuffer.readU32();
        header.headSize = parseBuffer.readU32();
        header.minimumIndex = parseBuffer.readU32();
        header.maximumIndex = parseBuffer.readU32();
        header.gprecSize = parseBuffer.readU32();
        header.tpiHashStream = parseBuffer.readU16();
        header.tpiHashPadStream = parseBuffer.readU16();
        header.hashKeySize = parseBuffer.readU32();
        header.hashBucketSize = parseBuffer.readU32();
        header.hashValues = new Slice(parseBuffer.readI32(), parseBuffer.readU32());
        header.tiOff = new Slice(parseBuffer.readI32(), parseBuffer.readU32());
        header.hashAdj = new Slice(parseBuffer.readI32(), parseBuffer.readU32());
        long l = parseBuffer.pos();
        if (header.headSize < l) {
            Log.error("header size is impossibly small", new Object[0]);
            return null;
        }
        if (header.headSize > 1024L) {
            Log.error("header size is unreasonably large", new Object[0]);
            return null;
        }
        parseBuffer.pos(header.headSize);
        if (header.minimumIndex < 4096L) {
            Log.error("minimum type index is < 4096", new Object[0]);
            return null;
        }
        if (header.maximumIndex < header.minimumIndex) {
            Log.error("maximum type index is < minimum type index", new Object[0]);
            return null;
        }
        return header;
    }

    public long getVersion() {
        return this.version;
    }

    public long getHeadSize() {
        return this.headSize;
    }

    public long getMinimumIndex() {
        return this.minimumIndex;
    }

    public long getMaximumIndex() {
        return this.maximumIndex;
    }

    public long getGprecSize() {
        return this.gprecSize;
    }

    public int getTpiHashStream() {
        return this.tpiHashStream;
    }

    public int getTpiHashPadStream() {
        return this.tpiHashPadStream;
    }

    public long getHashKeySize() {
        return this.hashKeySize;
    }

    public long getHashBucketSize() {
        return this.hashBucketSize;
    }

    public Slice getHashValues() {
        return this.hashValues;
    }

    public Slice getTiOff() {
        return this.tiOff;
    }

    public Slice getHashAdj() {
        return this.hashAdj;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public void setHeadSize(long l) {
        this.headSize = l;
    }

    public void setMinimumIndex(long l) {
        this.minimumIndex = l;
    }

    public void setMaximumIndex(long l) {
        this.maximumIndex = l;
    }

    public void setGprecSize(long l) {
        this.gprecSize = l;
    }

    public void setTpiHashStream(int n) {
        this.tpiHashStream = n;
    }

    public void setTpiHashPadStream(int n) {
        this.tpiHashPadStream = n;
    }

    public void setHashKeySize(long l) {
        this.hashKeySize = l;
    }

    public void setHashBucketSize(long l) {
        this.hashBucketSize = l;
    }

    public void setHashValues(Slice slice) {
        this.hashValues = slice;
    }

    public void setTiOff(Slice slice) {
        this.tiOff = slice;
    }

    public void setHashAdj(Slice slice) {
        this.hashAdj = slice;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Header)) {
            return false;
        }
        Header header = (Header)object;
        if (!header.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != header.getVersion()) {
            return false;
        }
        if (this.getHeadSize() != header.getHeadSize()) {
            return false;
        }
        if (this.getMinimumIndex() != header.getMinimumIndex()) {
            return false;
        }
        if (this.getMaximumIndex() != header.getMaximumIndex()) {
            return false;
        }
        if (this.getGprecSize() != header.getGprecSize()) {
            return false;
        }
        if (this.getTpiHashStream() != header.getTpiHashStream()) {
            return false;
        }
        if (this.getTpiHashPadStream() != header.getTpiHashPadStream()) {
            return false;
        }
        if (this.getHashKeySize() != header.getHashKeySize()) {
            return false;
        }
        if (this.getHashBucketSize() != header.getHashBucketSize()) {
            return false;
        }
        Slice slice = this.getHashValues();
        Slice slice2 = header.getHashValues();
        if (slice == null ? slice2 != null : !slice.equals(slice2)) {
            return false;
        }
        Slice slice3 = this.getTiOff();
        Slice slice4 = header.getTiOff();
        if (slice3 == null ? slice4 != null : !slice3.equals(slice4)) {
            return false;
        }
        Slice slice5 = this.getHashAdj();
        Slice slice6 = header.getHashAdj();
        return !(slice5 == null ? slice6 != null : !slice5.equals(slice6));
    }

    protected boolean canEqual(Object object) {
        return object instanceof Header;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getVersion();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getHeadSize();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getMinimumIndex();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getMaximumIndex();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = this.getGprecSize();
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        n2 = n2 * 59 + this.getTpiHashStream();
        n2 = n2 * 59 + this.getTpiHashPadStream();
        long l6 = this.getHashKeySize();
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        long l7 = this.getHashBucketSize();
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        Slice slice = this.getHashValues();
        n2 = n2 * 59 + (slice == null ? 43 : slice.hashCode());
        Slice slice2 = this.getTiOff();
        n2 = n2 * 59 + (slice2 == null ? 43 : slice2.hashCode());
        Slice slice3 = this.getHashAdj();
        n2 = n2 * 59 + (slice3 == null ? 43 : slice3.hashCode());
        return n2;
    }

    public String toString() {
        return "Header(version=" + this.getVersion() + ", headSize=" + this.getHeadSize() + ", minimumIndex=" + this.getMinimumIndex() + ", maximumIndex=" + this.getMaximumIndex() + ", gprecSize=" + this.getGprecSize() + ", tpiHashStream=" + this.getTpiHashStream() + ", tpiHashPadStream=" + this.getTpiHashPadStream() + ", hashKeySize=" + this.getHashKeySize() + ", hashBucketSize=" + this.getHashBucketSize() + ", hashValues=" + this.getHashValues() + ", tiOff=" + this.getTiOff() + ", hashAdj=" + this.getHashAdj() + ")";
    }
}

