/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol.constant;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public enum CPUType {
    Intel8080(0),
    Intel8086(1),
    Intel80286(2),
    Intel80386(3),
    Intel80486(4),
    Pentium(5),
    PentiumPro(6),
    Pentium3(7),
    MIPS(16),
    MIPS16(17),
    MIPS32(18),
    MIPS64(19),
    MIPSI(20),
    MIPSII(21),
    MIPSIII(22),
    MIPSIV(23),
    MIPSV(24),
    M68000(32),
    M68010(33),
    M68020(34),
    M68030(35),
    M68040(36),
    Alpha(48),
    Alpha21164(49),
    Alpha21164A(50),
    Alpha21264(51),
    Alpha21364(52),
    PPC601(64),
    PPC603(65),
    PPC604(66),
    PPC620(67),
    PPCFP(68),
    PPCBE(69),
    SH3(80),
    SH3E(81),
    SH3DSP(82),
    SH4(83),
    SHMedia(84),
    ARM3(96),
    ARM4(97),
    ARM4T(98),
    ARM5(99),
    ARM5T(100),
    ARM6(101),
    ARM_XMAC(102),
    ARM_WMMX(103),
    ARM7(104),
    ARM64(105),
    Omni(112),
    Ia64(128),
    Ia64_2(129),
    CEE(144),
    AM33(160),
    M32R(176),
    TriCore(192),
    X64(208),
    EBC(224),
    Thumb(240),
    ARMNT(244),
    D3D11_Shader(256);

    int value;

    private CPUType(int n2) {
        this.value = n2;
    }

    public static CPUType fromInt(int n) {
        switch (n) {
            case 0: {
                return Intel8080;
            }
            case 1: {
                return Intel8086;
            }
            case 2: {
                return Intel80286;
            }
            case 3: {
                return Intel80386;
            }
            case 4: {
                return Intel80486;
            }
            case 5: {
                return Pentium;
            }
            case 6: {
                return PentiumPro;
            }
            case 7: {
                return Pentium3;
            }
            case 16: {
                return MIPS;
            }
            case 17: {
                return MIPS16;
            }
            case 18: {
                return MIPS32;
            }
            case 19: {
                return MIPS64;
            }
            case 20: {
                return MIPSI;
            }
            case 21: {
                return MIPSII;
            }
            case 22: {
                return MIPSIII;
            }
            case 23: {
                return MIPSIV;
            }
            case 24: {
                return MIPSV;
            }
            case 32: {
                return M68000;
            }
            case 33: {
                return M68010;
            }
            case 34: {
                return M68020;
            }
            case 35: {
                return M68030;
            }
            case 36: {
                return M68040;
            }
            case 48: {
                return Alpha;
            }
            case 49: {
                return Alpha21164;
            }
            case 50: {
                return Alpha21164A;
            }
            case 51: {
                return Alpha21264;
            }
            case 52: {
                return Alpha21364;
            }
            case 64: {
                return PPC601;
            }
            case 65: {
                return PPC603;
            }
            case 66: {
                return PPC604;
            }
            case 67: {
                return PPC620;
            }
            case 68: {
                return PPCFP;
            }
            case 69: {
                return PPCBE;
            }
            case 80: {
                return SH3;
            }
            case 81: {
                return SH3E;
            }
            case 82: {
                return SH3DSP;
            }
            case 83: {
                return SH4;
            }
            case 84: {
                return SHMedia;
            }
            case 96: {
                return ARM3;
            }
            case 97: {
                return ARM4;
            }
            case 98: {
                return ARM4T;
            }
            case 99: {
                return ARM5;
            }
            case 100: {
                return ARM5T;
            }
            case 101: {
                return ARM6;
            }
            case 102: {
                return ARM_XMAC;
            }
            case 103: {
                return ARM_WMMX;
            }
            case 104: {
                return ARM7;
            }
            case 105: {
                return ARM64;
            }
            case 112: {
                return Omni;
            }
            case 128: {
                return Ia64;
            }
            case 129: {
                return Ia64_2;
            }
            case 144: {
                return CEE;
            }
            case 160: {
                return AM33;
            }
            case 176: {
                return M32R;
            }
            case 192: {
                return TriCore;
            }
            case 208: {
                return X64;
            }
            case 224: {
                return EBC;
            }
            case 240: {
                return Thumb;
            }
            case 244: {
                return ARMNT;
            }
            case 256: {
                return D3D11_Shader;
            }
        }
        return Intel8080;
    }

    public static CPUType parse(ParseBuffer parseBuffer) {
        int n = parseBuffer.readU16();
        return CPUType.fromInt(n);
    }
}

