/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.ThunkKind;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class ThunkSymbol {
    Long parent;
    long end;
    Long next;
    PdbInternalSectionOffset offset;
    int len;
    ThunkKind kind;
    String name;

    public ThunkSymbol(Long l, long l2, Long l3, PdbInternalSectionOffset pdbInternalSectionOffset, int n, ThunkKind thunkKind, String string) {
        this.parent = l;
        this.end = l2;
        this.next = l3;
        this.offset = pdbInternalSectionOffset;
        this.len = n;
        this.kind = thunkKind;
        this.name = string;
    }

    public static ThunkSymbol parse(ParseBuffer parseBuffer, int n) {
        try {
            Long l = Utils.parseOptionalIndex(parseBuffer);
            long l2 = parseBuffer.readU32();
            Long l3 = Utils.parseOptionalIndex(parseBuffer);
            PdbInternalSectionOffset pdbInternalSectionOffset = PdbInternalSectionOffset.parse(parseBuffer);
            int n2 = parseBuffer.readU16();
            short s2 = parseBuffer.readU8();
            String string = Utils.parseSymbolName(parseBuffer, n);
            ThunkKind thunkKind = new ThunkKind();
            switch (s2) {
                case 0: {
                    thunkKind.noType = new ThunkKind.NoType();
                    break;
                }
                case 1: {
                    thunkKind.adjustor = ThunkKind.Adjustor.parse(parseBuffer);
                    break;
                }
                case 2: {
                    thunkKind.vCall = parseBuffer.readU16();
                    break;
                }
                case 3: {
                    thunkKind.pCode = new ThunkKind.PCode();
                    break;
                }
                case 4: {
                    thunkKind.load = new ThunkKind.Load();
                    break;
                }
                default: {
                    thunkKind.unknown = s2;
                }
            }
            return new ThunkSymbol(l, l2, l3, pdbInternalSectionOffset, n2, thunkKind, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Long getParent() {
        return this.parent;
    }

    public long getEnd() {
        return this.end;
    }

    public Long getNext() {
        return this.next;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public int getLen() {
        return this.len;
    }

    public ThunkKind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(Long l) {
        this.parent = l;
    }

    public void setEnd(long l) {
        this.end = l;
    }

    public void setNext(Long l) {
        this.next = l;
    }

    public void setOffset(PdbInternalSectionOffset pdbInternalSectionOffset) {
        this.offset = pdbInternalSectionOffset;
    }

    public void setLen(int n) {
        this.len = n;
    }

    public void setKind(ThunkKind thunkKind) {
        this.kind = thunkKind;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ThunkSymbol)) {
            return false;
        }
        ThunkSymbol thunkSymbol = (ThunkSymbol)object;
        if (!thunkSymbol.canEqual(this)) {
            return false;
        }
        if (this.getEnd() != thunkSymbol.getEnd()) {
            return false;
        }
        if (this.getLen() != thunkSymbol.getLen()) {
            return false;
        }
        Long l = this.getParent();
        Long l2 = thunkSymbol.getParent();
        if (l == null ? l2 != null : !((Object)l).equals(l2)) {
            return false;
        }
        Long l3 = this.getNext();
        Long l4 = thunkSymbol.getNext();
        if (l3 == null ? l4 != null : !((Object)l3).equals(l4)) {
            return false;
        }
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        PdbInternalSectionOffset pdbInternalSectionOffset2 = thunkSymbol.getOffset();
        if (pdbInternalSectionOffset == null ? pdbInternalSectionOffset2 != null : !((Object)pdbInternalSectionOffset).equals(pdbInternalSectionOffset2)) {
            return false;
        }
        ThunkKind thunkKind = this.getKind();
        ThunkKind thunkKind2 = thunkSymbol.getKind();
        if (thunkKind == null ? thunkKind2 != null : !thunkKind.equals(thunkKind2)) {
            return false;
        }
        String string = this.getName();
        String string2 = thunkSymbol.getName();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof ThunkSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getEnd();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        n2 = n2 * 59 + this.getLen();
        Long l2 = this.getParent();
        n2 = n2 * 59 + (l2 == null ? 43 : ((Object)l2).hashCode());
        Long l3 = this.getNext();
        n2 = n2 * 59 + (l3 == null ? 43 : ((Object)l3).hashCode());
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        n2 = n2 * 59 + (pdbInternalSectionOffset == null ? 43 : ((Object)pdbInternalSectionOffset).hashCode());
        ThunkKind thunkKind = this.getKind();
        n2 = n2 * 59 + (thunkKind == null ? 43 : thunkKind.hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    public String toString() {
        return "ThunkSymbol(parent=" + this.getParent() + ", end=" + this.getEnd() + ", next=" + this.getNext() + ", offset=" + this.getOffset() + ", len=" + this.getLen() + ", kind=" + this.getKind() + ", name=" + this.getName() + ")";
    }
}

