/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class PublicSymbol {
    public static long CVPSF_CODE = 1L;
    public static long CVPSF_FUNCTION = 2L;
    public static long CVPSF_MANAGED = 4L;
    public static long CVPSF_MSIL = 8L;
    boolean code;
    boolean function;
    boolean managed;
    boolean misl;
    PdbInternalSectionOffset offset;
    String name;

    public PublicSymbol(boolean bl, boolean bl2, boolean bl3, boolean bl4, PdbInternalSectionOffset pdbInternalSectionOffset, String string) {
        this.code = bl;
        this.function = bl2;
        this.managed = bl3;
        this.misl = bl4;
        this.offset = pdbInternalSectionOffset;
        this.name = string;
    }

    public static PublicSymbol parse(ParseBuffer parseBuffer, int n) {
        try {
            long l = parseBuffer.readU32();
            return new PublicSymbol((l & CVPSF_CODE) != 0L, (l & CVPSF_FUNCTION) != 0L, (l & CVPSF_MANAGED) != 0L, (l & CVPSF_MSIL) != 0L, PdbInternalSectionOffset.parse(parseBuffer), Utils.parseSymbolName(parseBuffer, n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isCode() {
        return this.code;
    }

    public boolean isFunction() {
        return this.function;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public boolean isMisl() {
        return this.misl;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(boolean bl) {
        this.code = bl;
    }

    public void setFunction(boolean bl) {
        this.function = bl;
    }

    public void setManaged(boolean bl) {
        this.managed = bl;
    }

    public void setMisl(boolean bl) {
        this.misl = bl;
    }

    public void setOffset(PdbInternalSectionOffset pdbInternalSectionOffset) {
        this.offset = pdbInternalSectionOffset;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PublicSymbol)) {
            return false;
        }
        PublicSymbol publicSymbol = (PublicSymbol)object;
        if (!publicSymbol.canEqual(this)) {
            return false;
        }
        if (this.isCode() != publicSymbol.isCode()) {
            return false;
        }
        if (this.isFunction() != publicSymbol.isFunction()) {
            return false;
        }
        if (this.isManaged() != publicSymbol.isManaged()) {
            return false;
        }
        if (this.isMisl() != publicSymbol.isMisl()) {
            return false;
        }
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        PdbInternalSectionOffset pdbInternalSectionOffset2 = publicSymbol.getOffset();
        if (pdbInternalSectionOffset == null ? pdbInternalSectionOffset2 != null : !((Object)pdbInternalSectionOffset).equals(pdbInternalSectionOffset2)) {
            return false;
        }
        String string = this.getName();
        String string2 = publicSymbol.getName();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PublicSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + (this.isCode() ? 79 : 97);
        n2 = n2 * 59 + (this.isFunction() ? 79 : 97);
        n2 = n2 * 59 + (this.isManaged() ? 79 : 97);
        n2 = n2 * 59 + (this.isMisl() ? 79 : 97);
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        n2 = n2 * 59 + (pdbInternalSectionOffset == null ? 43 : ((Object)pdbInternalSectionOffset).hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    public String toString() {
        return "PublicSymbol(code=" + this.isCode() + ", function=" + this.isFunction() + ", managed=" + this.isManaged() + ", misl=" + this.isMisl() + ", offset=" + this.getOffset() + ", name=" + this.getName() + ")";
    }
}

