/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.SymbolData;
import java.util.Arrays;

public class PSymbol {
    private long symbolIndex;
    private byte[] data;
    ParseBuffer buffer;

    public PSymbol(long l, byte[] byArray) {
        this.symbolIndex = l;
        this.data = byArray;
        this.buffer = new ParseBuffer(byArray);
    }

    public int getRawKind() {
        if (this.data.length < 2) {
            Log.error("getRawKind: data length too short", new Object[0]);
            return 0;
        }
        return this.buffer.getU16();
    }

    public SymbolData parse() {
        return SymbolData.parse(this.buffer);
    }

    public long getSymbolIndex() {
        return this.symbolIndex;
    }

    public byte[] getData() {
        return this.data;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public void setSymbolIndex(long l) {
        this.symbolIndex = l;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void setBuffer(ParseBuffer parseBuffer) {
        this.buffer = parseBuffer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PSymbol)) {
            return false;
        }
        PSymbol pSymbol = (PSymbol)object;
        if (!pSymbol.canEqual(this)) {
            return false;
        }
        if (this.getSymbolIndex() != pSymbol.getSymbolIndex()) {
            return false;
        }
        if (!Arrays.equals(this.getData(), pSymbol.getData())) {
            return false;
        }
        ParseBuffer parseBuffer = this.getBuffer();
        ParseBuffer parseBuffer2 = pSymbol.getBuffer();
        return !(parseBuffer == null ? parseBuffer2 != null : !((Object)parseBuffer).equals(parseBuffer2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSymbolIndex();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        n2 = n2 * 59 + Arrays.hashCode(this.getData());
        ParseBuffer parseBuffer = this.getBuffer();
        n2 = n2 * 59 + (parseBuffer == null ? 43 : ((Object)parseBuffer).hashCode());
        return n2;
    }

    public String toString() {
        return "PSymbol(symbolIndex=" + this.getSymbolIndex() + ", data=" + Arrays.toString(this.getData()) + ", buffer=" + this.getBuffer() + ")";
    }
}

