/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;
import java.util.ArrayList;
import java.util.List;

public class MultiRegisterVariableSymbol {
    private long typeIndex;
    private List<RegisterVariable> registers;

    public MultiRegisterVariableSymbol(long l, List<RegisterVariable> list) {
        this.typeIndex = l;
        this.registers = list;
    }

    public static MultiRegisterVariableSymbol parse(ParseBuffer parseBuffer, int n) {
        try {
            long l = parseBuffer.readU32();
            int n2 = n == 4375 || n == 4116 ? parseBuffer.readU16() : (int)parseBuffer.readU8();
            ArrayList<RegisterVariable> arrayList = new ArrayList<RegisterVariable>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add(RegisterVariable.parse(parseBuffer, n));
            }
            return new MultiRegisterVariableSymbol(l, arrayList);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public List<RegisterVariable> getRegisters() {
        return this.registers;
    }

    public void setTypeIndex(long l) {
        this.typeIndex = l;
    }

    public void setRegisters(List<RegisterVariable> list) {
        this.registers = list;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultiRegisterVariableSymbol)) {
            return false;
        }
        MultiRegisterVariableSymbol multiRegisterVariableSymbol = (MultiRegisterVariableSymbol)object;
        if (!multiRegisterVariableSymbol.canEqual(this)) {
            return false;
        }
        if (this.getTypeIndex() != multiRegisterVariableSymbol.getTypeIndex()) {
            return false;
        }
        List<RegisterVariable> list = this.getRegisters();
        List<RegisterVariable> list2 = multiRegisterVariableSymbol.getRegisters();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof MultiRegisterVariableSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getTypeIndex();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        List<RegisterVariable> list = this.getRegisters();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    public String toString() {
        return "MultiRegisterVariableSymbol(typeIndex=" + this.getTypeIndex() + ", registers=" + this.getRegisters() + ")";
    }

    static class RegisterVariable {
        int register;
        String name;

        public RegisterVariable(int n, String string) {
            this.register = n;
            this.name = string;
        }

        public static RegisterVariable parse(ParseBuffer parseBuffer, int n) {
            return new RegisterVariable(parseBuffer.readU16(), Utils.parseSymbolName(parseBuffer, n));
        }
    }
}

