/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.CompileFlags;
import com.uqm.crashsight.symtabtool.pdb.symbol.CompilerVersion;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;
import com.uqm.crashsight.symtabtool.pdb.symbol.constant.CPUType;
import com.uqm.crashsight.symtabtool.pdb.symbol.constant.SourceLanguage;

public class CompileFlagsSymbol {
    SourceLanguage language;
    CompileFlags flags;
    CPUType cpuType;
    CompilerVersion frontendVersion;
    CompilerVersion backendVersion;
    String versionString;

    public CompileFlagsSymbol(SourceLanguage sourceLanguage, CompileFlags compileFlags, CPUType cPUType, CompilerVersion compilerVersion, CompilerVersion compilerVersion2, String string) {
        this.language = sourceLanguage;
        this.flags = compileFlags;
        this.cpuType = cPUType;
        this.frontendVersion = compilerVersion;
        this.backendVersion = compilerVersion2;
        this.versionString = string;
    }

    public static CompileFlagsSymbol parse(ParseBuffer parseBuffer, int n) {
        try {
            boolean bl = n == 4412;
            return new CompileFlagsSymbol(SourceLanguage.parse(parseBuffer), CompileFlags.parse(parseBuffer, n), CPUType.parse(parseBuffer), CompilerVersion.parse(parseBuffer, bl), CompilerVersion.parse(parseBuffer, bl), Utils.parseSymbolName(parseBuffer, n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SourceLanguage getLanguage() {
        return this.language;
    }

    public CompileFlags getFlags() {
        return this.flags;
    }

    public CPUType getCpuType() {
        return this.cpuType;
    }

    public CompilerVersion getFrontendVersion() {
        return this.frontendVersion;
    }

    public CompilerVersion getBackendVersion() {
        return this.backendVersion;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public void setLanguage(SourceLanguage sourceLanguage) {
        this.language = sourceLanguage;
    }

    public void setFlags(CompileFlags compileFlags) {
        this.flags = compileFlags;
    }

    public void setCpuType(CPUType cPUType) {
        this.cpuType = cPUType;
    }

    public void setFrontendVersion(CompilerVersion compilerVersion) {
        this.frontendVersion = compilerVersion;
    }

    public void setBackendVersion(CompilerVersion compilerVersion) {
        this.backendVersion = compilerVersion;
    }

    public void setVersionString(String string) {
        this.versionString = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CompileFlagsSymbol)) {
            return false;
        }
        CompileFlagsSymbol compileFlagsSymbol = (CompileFlagsSymbol)object;
        if (!compileFlagsSymbol.canEqual(this)) {
            return false;
        }
        SourceLanguage sourceLanguage = this.getLanguage();
        SourceLanguage sourceLanguage2 = compileFlagsSymbol.getLanguage();
        if (sourceLanguage == null ? sourceLanguage2 != null : !((Object)((Object)sourceLanguage)).equals((Object)sourceLanguage2)) {
            return false;
        }
        CompileFlags compileFlags = this.getFlags();
        CompileFlags compileFlags2 = compileFlagsSymbol.getFlags();
        if (compileFlags == null ? compileFlags2 != null : !((Object)compileFlags).equals(compileFlags2)) {
            return false;
        }
        CPUType cPUType = this.getCpuType();
        CPUType cPUType2 = compileFlagsSymbol.getCpuType();
        if (cPUType == null ? cPUType2 != null : !((Object)((Object)cPUType)).equals((Object)cPUType2)) {
            return false;
        }
        CompilerVersion compilerVersion = this.getFrontendVersion();
        CompilerVersion compilerVersion2 = compileFlagsSymbol.getFrontendVersion();
        if (compilerVersion == null ? compilerVersion2 != null : !((Object)compilerVersion).equals(compilerVersion2)) {
            return false;
        }
        CompilerVersion compilerVersion3 = this.getBackendVersion();
        CompilerVersion compilerVersion4 = compileFlagsSymbol.getBackendVersion();
        if (compilerVersion3 == null ? compilerVersion4 != null : !((Object)compilerVersion3).equals(compilerVersion4)) {
            return false;
        }
        String string = this.getVersionString();
        String string2 = compileFlagsSymbol.getVersionString();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof CompileFlagsSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        SourceLanguage sourceLanguage = this.getLanguage();
        n2 = n2 * 59 + (sourceLanguage == null ? 43 : ((Object)((Object)sourceLanguage)).hashCode());
        CompileFlags compileFlags = this.getFlags();
        n2 = n2 * 59 + (compileFlags == null ? 43 : ((Object)compileFlags).hashCode());
        CPUType cPUType = this.getCpuType();
        n2 = n2 * 59 + (cPUType == null ? 43 : ((Object)((Object)cPUType)).hashCode());
        CompilerVersion compilerVersion = this.getFrontendVersion();
        n2 = n2 * 59 + (compilerVersion == null ? 43 : ((Object)compilerVersion).hashCode());
        CompilerVersion compilerVersion2 = this.getBackendVersion();
        n2 = n2 * 59 + (compilerVersion2 == null ? 43 : ((Object)compilerVersion2).hashCode());
        String string = this.getVersionString();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    public String toString() {
        return "CompileFlagsSymbol(language=" + (Object)((Object)this.getLanguage()) + ", flags=" + this.getFlags() + ", cpuType=" + (Object)((Object)this.getCpuType()) + ", frontendVersion=" + this.getFrontendVersion() + ", backendVersion=" + this.getBackendVersion() + ", versionString=" + this.getVersionString() + ")";
    }
}

