/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.strings;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class StringTableHeader {
    public static final long SIZE = 12L;
    long magic;
    long hashVersion;
    long namesSize;

    public static StringTableHeader parse(ParseBuffer parseBuffer) {
        StringTableHeader stringTableHeader = new StringTableHeader();
        stringTableHeader.magic = parseBuffer.readU32();
        stringTableHeader.hashVersion = parseBuffer.readU32();
        stringTableHeader.namesSize = parseBuffer.readU32();
        return stringTableHeader;
    }

    public long nameStart() {
        return 12L;
    }

    public long namesEnd() {
        return this.nameStart() + this.namesSize;
    }

    public long getMagic() {
        return this.magic;
    }

    public long getHashVersion() {
        return this.hashVersion;
    }

    public long getNamesSize() {
        return this.namesSize;
    }

    public void setMagic(long l) {
        this.magic = l;
    }

    public void setHashVersion(long l) {
        this.hashVersion = l;
    }

    public void setNamesSize(long l) {
        this.namesSize = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StringTableHeader)) {
            return false;
        }
        StringTableHeader stringTableHeader = (StringTableHeader)object;
        if (!stringTableHeader.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != stringTableHeader.getMagic()) {
            return false;
        }
        if (this.getHashVersion() != stringTableHeader.getHashVersion()) {
            return false;
        }
        return this.getNamesSize() == stringTableHeader.getNamesSize();
    }

    protected boolean canEqual(Object object) {
        return object instanceof StringTableHeader;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getMagic();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getHashVersion();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getNamesSize();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        return n2;
    }

    public String toString() {
        return "StringTableHeader(magic=" + this.getMagic() + ", hashVersion=" + this.getHashVersion() + ", namesSize=" + this.getNamesSize() + ")";
    }
}

