/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.omap.Rva;

public class SectionOffset {
    long offset;
    int section;

    public SectionOffset(long l, int n) {
        this.offset = l;
        this.section = n;
    }

    public Rva toRva(AddressMap addressMap) {
        if (addressMap.transformedSections != null) {
            return new Rva(AddressMap.getVirtualAddress(addressMap.transformedSections, this.section, this.offset));
        }
        return new Rva(AddressMap.getVirtualAddress(addressMap.originalSections, this.section, this.offset));
    }

    public PdbInternalRva toInternalRva(AddressMap addressMap) {
        return this.toRva(addressMap).toInternalRva(addressMap);
    }

    public PdbInternalSectionOffset toInternalOffset(AddressMap addressMap) {
        if (addressMap.transformedSections == null) {
            return new PdbInternalSectionOffset(this.offset, this.section);
        }
        return this.toInternalRva(addressMap).toInternalOffset(addressMap);
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSection() {
        return this.section;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public void setSection(int n) {
        this.section = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SectionOffset)) {
            return false;
        }
        SectionOffset sectionOffset = (SectionOffset)object;
        if (!sectionOffset.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != sectionOffset.getOffset()) {
            return false;
        }
        return this.getSection() == sectionOffset.getSection();
    }

    protected boolean canEqual(Object object) {
        return object instanceof SectionOffset;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        n2 = n2 * 59 + this.getSection();
        return n2;
    }

    public String toString() {
        return "SectionOffset(offset=" + this.getOffset() + ", section=" + this.getSection() + ")";
    }
}

