/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.OMAPRecord;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.Range;

public class RangeIter {
    Iterator<OMAPRecord> records;
    OMAPRecord record;
    long addr;
    long end;

    public RangeIter(Iterator<OMAPRecord> iterator2, OMAPRecord oMAPRecord, long l, long l2) {
        this.records = iterator2;
        this.record = oMAPRecord;
        this.addr = l;
        this.end = l2;
    }

    public static RangeIter empty() {
        return new RangeIter(Collections.emptyIterator(), OMAPRecord.empty(), 0L, 0L);
    }

    public static RangeIter identity(Range<Long> range) {
        return new RangeIter(Collections.emptyIterator(), new OMAPRecord(range.getMinimum(), range.getMinimum()), range.getMinimum(), range.getMaximum());
    }

    public static RangeIter _default() {
        return RangeIter.empty();
    }

    public Range<Long> next() {
        while (this.addr < this.end) {
            OMAPRecord oMAPRecord = this.records.hasNext() ? this.records.next() : new OMAPRecord(this.end, 0L);
            long l = Math.min(oMAPRecord.getSourceAddress(), this.end);
            long l2 = this.addr;
            this.addr = l;
            OMAPRecord oMAPRecord2 = this.record;
            this.record = oMAPRecord;
            if (l2 >= l || oMAPRecord2.targetAddress == 0L) continue;
            long l3 = oMAPRecord2.translate(l2);
            long l4 = oMAPRecord2.translate(l);
            return Range.between(l3, l4);
        }
        return null;
    }
}

