/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.OMAPRecord;
import com.uqm.crashsight.symtabtool.pdb.omap.RangeIter;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Range;

public class OMAPTable {
    List<OMAPRecord> records;

    public static OMAPTable parse(ParseBuffer parseBuffer) {
        OMAPTable oMAPTable = new OMAPTable();
        parseBuffer.align(8L);
        assert (parseBuffer.remaining() % 8L == 0L);
        ArrayList<OMAPRecord> arrayList = new ArrayList<OMAPRecord>((int)(parseBuffer.remaining() / 8L));
        while (!parseBuffer.isEmpty()) {
            arrayList.add(OMAPRecord.parse(parseBuffer));
        }
        oMAPTable.records = arrayList;
        return oMAPTable;
    }

    public SearchResult binarySearchByKey(List<OMAPRecord> list, long l) {
        SearchResult searchResult = new SearchResult(-1, false);
        int n = 0;
        int n2 = list.size() - 1;
        int n3 = 0;
        while (n < n2) {
            n3 = (n + n2) / 2;
            OMAPRecord oMAPRecord = list.get(n3);
            if (oMAPRecord.sourceAddress == l) {
                searchResult.founded = true;
                break;
            }
            if (oMAPRecord.sourceAddress > l) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        searchResult.index = n3;
        return searchResult;
    }

    public Long lookup(long l) {
        int n;
        List<OMAPRecord> list = this.getRecords();
        OMAPRecord oMAPRecord = list.get(n = this.binarySearchByKey(list, (long)l).index);
        if (oMAPRecord.getTargetAddress() == 0L) {
            return null;
        }
        return oMAPRecord.translate(l);
    }

    public RangeIter lookupRange(Range<Long> range) {
        List<OMAPRecord> list;
        OMAPRecord oMAPRecord;
        long l = range.getMinimum();
        long l2 = range.getMaximum();
        if (l2 <= l) {
            return RangeIter.empty();
        }
        List<OMAPRecord> list2 = this.getRecords();
        SearchResult searchResult = this.binarySearchByKey(list2, l);
        if (searchResult.founded) {
            oMAPRecord = list2.get(searchResult.index);
            list = list2.subList(searchResult.index + 1, list2.size());
        } else if (searchResult.index == 0) {
            oMAPRecord = OMAPRecord.empty();
            list = list2;
        } else {
            oMAPRecord = list2.get(searchResult.index - 1);
            list = list2.subList(searchResult.index, list2.size());
        }
        return new RangeIter(list.iterator(), oMAPRecord, l, l2);
    }

    public List<OMAPRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<OMAPRecord> list) {
        this.records = list;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OMAPTable)) {
            return false;
        }
        OMAPTable oMAPTable = (OMAPTable)object;
        if (!oMAPTable.canEqual(this)) {
            return false;
        }
        List<OMAPRecord> list = this.getRecords();
        List<OMAPRecord> list2 = oMAPTable.getRecords();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof OMAPTable;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        List<OMAPRecord> list = this.getRecords();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    public String toString() {
        return "OMAPTable(records=" + this.getRecords() + ")";
    }

    public static class SearchResult {
        int index;
        boolean founded;

        public SearchResult(int n, boolean bl) {
            this.index = n;
            this.founded = bl;
        }
    }
}

