/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.source;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.module.source.Line;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import com.uqm.crashsight.symtabtool.pdb.omap.RvaRangeIter;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class Lines {
    List<Line> lines;
    boolean isSorted;
    long lastRva;

    public Lines() {
        this.lines = new ArrayList<Line>();
        this.isSorted = true;
        this.lastRva = 0L;
    }

    public Lines(List<Line> list, boolean bl, long l) {
        this.lines = list;
        this.isSorted = bl;
        this.lastRva = l;
    }

    public void addLine(long l, long l2, long l3) {
        this.lines.add(new Line(l, l2, 0L, l3));
        this.isSorted = this.isSorted && this.lastRva <= l;
        this.lastRva = l;
    }

    public void computeLen(long l, long l2) {
        if (this.lines.isEmpty()) {
            return;
        }
        if (!this.isSorted) {
            this.lines.sort(Comparator.comparingLong(line -> line.rva));
        }
        for (int i = 0; i < this.lines.size() - 1; ++i) {
            this.lines.get((int)i).len = this.lines.get((int)(i + 1)).rva - this.lines.get((int)i).rva;
        }
        Line line2 = this.lines.get(this.lines.size() - 1);
        line2.len = l2 - (line2.rva - l);
    }

    public void finalize(long l, long l2, AddressMap addressMap) {
        Object object;
        this.computeLen(l, l2);
        ArrayList arrayList = new ArrayList();
        boolean bl = true;
        long l3 = 0L;
        for (int i = 0; i < this.lines.size(); ++i) {
            Range<Long> range;
            Line line2 = this.lines.get(i);
            PdbInternalRva pdbInternalRva = new PdbInternalRva(line2.rva);
            PdbInternalRva pdbInternalRva2 = new PdbInternalRva(line2.rva + line2.len);
            ArrayList<Line> serializable = new ArrayList<Line>();
            object = addressMap.rvaRanges(Range.between(pdbInternalRva.getAddress(), pdbInternalRva2.getAddress()));
            int l5 = 0;
            while ((range = ((RvaRangeIter)object).next()) != null) {
                if (l5 == 0) {
                    line2.rva = range.getMinimum();
                    line2.len = range.getMaximum() - range.getMinimum();
                    bl = bl && l3 <= line2.rva;
                    l3 = line2.rva;
                } else {
                    serializable.add(new Line(range.getMinimum(), range.getMaximum() - range.getMinimum(), line2.num, line2.fileId));
                    bl = bl && l3 <= range.getMinimum();
                    l3 = range.getMinimum();
                }
                ++l5;
            }
            if (serializable.isEmpty()) continue;
            arrayList.add(new ImmutablePair((long)i + 1L, serializable));
        }
        if (!arrayList.isEmpty()) {
            ArrayList<Line> arrayList2 = new ArrayList<Line>();
            long l4 = 0L;
            for (Pair pair : arrayList) {
                long l5;
                object = (List)pair.getRight();
                for (l5 = l4; l5 < (Long)pair.getLeft(); ++l5) {
                    arrayList2.add(this.lines.get((int)l5));
                }
                arrayList2.addAll((Collection<Line>)object);
                l4 = l5;
            }
            if (l4 < (long)this.lines.size()) {
                for (int i = (int)l4; i < this.lines.size(); ++i) {
                    arrayList2.add(this.lines.get(i));
                }
            }
            this.lines = arrayList2;
        }
        if (!bl) {
            this.lines.sort(Comparator.comparingLong(line -> line.rva));
        }
    }

    public Lines findLinesForRange(long l, long l2) {
        List<Line> list = this.lines.stream().filter(line -> l <= line.rva && line.rva + line.len <= l + l2).collect(Collectors.toList());
        return new Lines(list, true, 0L);
    }

    public Lines retain(long l, long l2) {
        if (this.lines.isEmpty()) {
            return null;
        }
        if (l == this.lines.get((int)0).rva) {
            Line line = this.lines.get(this.lines.size() - 1);
            if (line.rva + line.len == l + l2) {
                return null;
            }
        }
        return this.findLinesForRange(l, l2);
    }

    public void display(BufferedWriter bufferedWriter) {
        try {
            for (Line line : this.lines) {
                bufferedWriter.write(String.format("%x %x %d %d\n", line.rva, line.len, line.num, line.fileId));
            }
        }
        catch (Exception exception) {
            Log.error(exception);
        }
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public long getLastRva() {
        return this.lastRva;
    }

    public void setLines(List<Line> list) {
        this.lines = list;
    }

    public void setSorted(boolean bl) {
        this.isSorted = bl;
    }

    public void setLastRva(long l) {
        this.lastRva = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Lines)) {
            return false;
        }
        Lines lines = (Lines)object;
        if (!lines.canEqual(this)) {
            return false;
        }
        if (this.isSorted() != lines.isSorted()) {
            return false;
        }
        if (this.getLastRva() != lines.getLastRva()) {
            return false;
        }
        List<Line> list = this.getLines();
        List<Line> list2 = lines.getLines();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof Lines;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + (this.isSorted() ? 79 : 97);
        long l = this.getLastRva();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        List<Line> list = this.getLines();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    public String toString() {
        return "Lines(lines=" + this.getLines() + ", isSorted=" + this.isSorted() + ", lastRva=" + this.getLastRva() + ")";
    }
}

