/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module.c13;

import com.uqm.crashsight.symtabtool.pdb.module.c13.DebugLinesHeader;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class DebugLinesBlockHeader {
    public static final int SIZE = 12;
    long fileIndex;
    long numLines;
    long blockSize;

    public static DebugLinesBlockHeader parse(ParseBuffer parseBuffer) {
        DebugLinesBlockHeader debugLinesBlockHeader = new DebugLinesBlockHeader();
        debugLinesBlockHeader.fileIndex = parseBuffer.readU32();
        debugLinesBlockHeader.numLines = parseBuffer.readU32();
        debugLinesBlockHeader.blockSize = parseBuffer.readU32();
        return debugLinesBlockHeader;
    }

    public static DebugLinesBlockHeader empty() {
        return new DebugLinesBlockHeader();
    }

    long getDataSize() {
        return this.blockSize - 12L;
    }

    long getLineSize() {
        return this.numLines * 8L;
    }

    long getColumnSize(DebugLinesHeader debugLinesHeader) {
        if (debugLinesHeader.hasColumns()) {
            return this.numLines * 4L;
        }
        return 0L;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public long getNumLines() {
        return this.numLines;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setFileIndex(long l) {
        this.fileIndex = l;
    }

    public void setNumLines(long l) {
        this.numLines = l;
    }

    public void setBlockSize(long l) {
        this.blockSize = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DebugLinesBlockHeader)) {
            return false;
        }
        DebugLinesBlockHeader debugLinesBlockHeader = (DebugLinesBlockHeader)object;
        if (!debugLinesBlockHeader.canEqual(this)) {
            return false;
        }
        if (this.getFileIndex() != debugLinesBlockHeader.getFileIndex()) {
            return false;
        }
        if (this.getNumLines() != debugLinesBlockHeader.getNumLines()) {
            return false;
        }
        return this.getBlockSize() == debugLinesBlockHeader.getBlockSize();
    }

    protected boolean canEqual(Object object) {
        return object instanceof DebugLinesBlockHeader;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getFileIndex();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getNumLines();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getBlockSize();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        return n2;
    }

    public String toString() {
        return "DebugLinesBlockHeader(fileIndex=" + this.getFileIndex() + ", numLines=" + this.getNumLines() + ", blockSize=" + this.getBlockSize() + ")";
    }
}

