/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.module;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.Module;
import com.uqm.crashsight.symtabtool.pdb.dbi.DBIModuleInfo;
import com.uqm.crashsight.symtabtool.pdb.module.c13.C13LineProgram;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineProgram;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.SymbolIter;

public class ModuleInfo {
    ParseBuffer buffer;
    long symbolsSize;
    long linesSize;

    public static ModuleInfo parse(ParseBuffer parseBuffer, Module module) {
        if (parseBuffer == null) {
            return null;
        }
        ModuleInfo moduleInfo = new ModuleInfo();
        DBIModuleInfo dBIModuleInfo = module.getInfo();
        assert (dBIModuleInfo.getLinesSize() == 0L);
        moduleInfo.linesSize = dBIModuleInfo.getC13LinesSize();
        moduleInfo.symbolsSize = dBIModuleInfo.getSymbolsSize();
        moduleInfo.buffer = parseBuffer;
        return moduleInfo;
    }

    public LineProgram getLineProgram() {
        ParseBuffer parseBuffer = this.getLinesData(this.linesSize);
        C13LineProgram c13LineProgram = C13LineProgram.parse(parseBuffer);
        return new LineProgram(c13LineProgram);
    }

    public ParseBuffer getLinesData(long l) {
        long l2 = this.symbolsSize;
        ParseBuffer parseBuffer = new ParseBuffer(this.buffer.getBuffer(), l2, l2 + l);
        return parseBuffer;
    }

    public SymbolIter getSymbols() {
        long l;
        ParseBuffer parseBuffer = this.buffer.truncate(this.symbolsSize);
        if (this.symbolsSize > 0L && this.symbolsSize % 4L == 0L && (l = parseBuffer.readU32()) != 4L) {
            Log.error("Unsupported symbol data format", new Object[0]);
            return SymbolIter.empty();
        }
        return new SymbolIter(parseBuffer);
    }

    public SymbolIter symbolsAt(long l) {
        SymbolIter symbolIter = this.getSymbols();
        symbolIter.seek(l);
        return symbolIter;
    }

    public ParseBuffer getBuffer() {
        return this.buffer;
    }

    public long getSymbolsSize() {
        return this.symbolsSize;
    }

    public long getLinesSize() {
        return this.linesSize;
    }

    public void setBuffer(ParseBuffer parseBuffer) {
        this.buffer = parseBuffer;
    }

    public void setSymbolsSize(long l) {
        this.symbolsSize = l;
    }

    public void setLinesSize(long l) {
        this.linesSize = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo moduleInfo = (ModuleInfo)object;
        if (!moduleInfo.canEqual(this)) {
            return false;
        }
        if (this.getSymbolsSize() != moduleInfo.getSymbolsSize()) {
            return false;
        }
        if (this.getLinesSize() != moduleInfo.getLinesSize()) {
            return false;
        }
        ParseBuffer parseBuffer = this.getBuffer();
        ParseBuffer parseBuffer2 = moduleInfo.getBuffer();
        return !(parseBuffer == null ? parseBuffer2 != null : !((Object)parseBuffer).equals(parseBuffer2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof ModuleInfo;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSymbolsSize();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getLinesSize();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        ParseBuffer parseBuffer = this.getBuffer();
        n2 = n2 * 59 + (parseBuffer == null ? 43 : ((Object)parseBuffer).hashCode());
        return n2;
    }

    public String toString() {
        return "ModuleInfo(buffer=" + this.getBuffer() + ", symbolsSize=" + this.getSymbolsSize() + ", linesSize=" + this.getLinesSize() + ")";
    }
}

