/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.dbi;

public enum MachineType {
    Unknown(0),
    Am33(19),
    Amd64(34404),
    Arm(448),
    Arm64(43620),
    ArmNT(452),
    Ebc(3772),
    X86(332),
    Ia64(512),
    M32R(36929),
    Mips16(614),
    MipsFpu(870),
    MipsFpu16(1126),
    PowerPC(496),
    PowerPCFP(497),
    R4000(358),
    RiscV32(20530),
    RiscV64(20580),
    RiscV128(20776),
    SH3(418),
    SH3DSP(419),
    SH4(422),
    SH5(424),
    Thumb(450),
    WceMipsV2(361),
    Invalid(65535);

    final int value;

    private MachineType(int n2) {
        this.value = n2;
    }

    public static MachineType fromInt(int n) {
        switch (n) {
            case 65535: {
                return Invalid;
            }
            case 19: {
                return Am33;
            }
            case 34404: {
                return Amd64;
            }
            case 448: {
                return Arm;
            }
            case 43620: {
                return Arm64;
            }
            case 452: {
                return ArmNT;
            }
            case 3772: {
                return Ebc;
            }
            case 332: {
                return X86;
            }
            case 512: {
                return Ia64;
            }
            case 36929: {
                return M32R;
            }
            case 614: {
                return Mips16;
            }
            case 870: {
                return MipsFpu;
            }
            case 1126: {
                return MipsFpu16;
            }
            case 496: {
                return PowerPC;
            }
            case 497: {
                return PowerPCFP;
            }
            case 358: {
                return R4000;
            }
            case 20530: {
                return RiscV32;
            }
            case 20580: {
                return RiscV64;
            }
            case 20776: {
                return RiscV128;
            }
            case 418: {
                return SH3;
            }
            case 419: {
                return SH3DSP;
            }
            case 422: {
                return SH4;
            }
            case 424: {
                return SH5;
            }
            case 450: {
                return Thumb;
            }
            case 361: {
                return WceMipsV2;
            }
        }
        return Unknown;
    }
}

