/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.dbi;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.GUID;
import com.uqm.crashsight.symtabtool.pdb.dbi.HeaderVersion;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class DBIHeader {
    long signature;
    HeaderVersion version;
    long age;
    int gsSymbolsStream;
    int internalVersion;
    int psSymbolsStream;
    int pdbDllBuildVersion;
    int symbolRecordsStream;
    int pdbDllRbldVersion;
    long moduleListSize;
    long sectionContributionSize;
    long sectionMapSize;
    long fileInfoSize;
    long typeServerMapSize;
    long mfcTypeServerIndex;
    long debugHeaderSize;
    long ecSubstreamSize;
    int flags;
    int machineType;
    long reserved;

    public static DBIHeader parse(ParseBuffer parseBuffer) {
        DBIHeader dBIHeader = new DBIHeader();
        dBIHeader.signature = parseBuffer.readU32() & 0xFFFFFFFFFFFFFFFFL;
        dBIHeader.version = HeaderVersion.fromInt((int)parseBuffer.readU32());
        dBIHeader.age = parseBuffer.readU32();
        dBIHeader.gsSymbolsStream = parseBuffer.readU16();
        dBIHeader.internalVersion = parseBuffer.readU16();
        dBIHeader.psSymbolsStream = parseBuffer.readU16();
        dBIHeader.pdbDllBuildVersion = parseBuffer.readU16();
        dBIHeader.symbolRecordsStream = parseBuffer.readU16();
        dBIHeader.pdbDllRbldVersion = parseBuffer.readU16();
        dBIHeader.moduleListSize = parseBuffer.readU32();
        dBIHeader.sectionContributionSize = parseBuffer.readU32();
        dBIHeader.sectionMapSize = parseBuffer.readU32();
        dBIHeader.fileInfoSize = parseBuffer.readU32();
        dBIHeader.typeServerMapSize = parseBuffer.readU32();
        dBIHeader.mfcTypeServerIndex = parseBuffer.readU32();
        dBIHeader.debugHeaderSize = parseBuffer.readU32();
        dBIHeader.ecSubstreamSize = parseBuffer.readU32();
        dBIHeader.flags = parseBuffer.readU16();
        dBIHeader.machineType = parseBuffer.readU16();
        dBIHeader.reserved = parseBuffer.readU32();
        return dBIHeader;
    }

    public void print(GUID gUID, String string) {
        Log.info("MODULE windows %s %08X%04X%04X%02X%02X%02X%02X%02X%02X%02X%02X%x %s\n", this.machineType, gUID.Data1, gUID.Data2, gUID.Data3, gUID.Data4[0], gUID.Data4[1], gUID.Data4[2], gUID.Data4[3], gUID.Data4[4], gUID.Data4[5], gUID.Data4[6], gUID.Data4[7], this.age, string);
    }

    public long getSignature() {
        return this.signature;
    }

    public HeaderVersion getVersion() {
        return this.version;
    }

    public long getAge() {
        return this.age;
    }

    public int getGsSymbolsStream() {
        return this.gsSymbolsStream;
    }

    public int getInternalVersion() {
        return this.internalVersion;
    }

    public int getPsSymbolsStream() {
        return this.psSymbolsStream;
    }

    public int getPdbDllBuildVersion() {
        return this.pdbDllBuildVersion;
    }

    public int getSymbolRecordsStream() {
        return this.symbolRecordsStream;
    }

    public int getPdbDllRbldVersion() {
        return this.pdbDllRbldVersion;
    }

    public long getModuleListSize() {
        return this.moduleListSize;
    }

    public long getSectionContributionSize() {
        return this.sectionContributionSize;
    }

    public long getSectionMapSize() {
        return this.sectionMapSize;
    }

    public long getFileInfoSize() {
        return this.fileInfoSize;
    }

    public long getTypeServerMapSize() {
        return this.typeServerMapSize;
    }

    public long getMfcTypeServerIndex() {
        return this.mfcTypeServerIndex;
    }

    public long getDebugHeaderSize() {
        return this.debugHeaderSize;
    }

    public long getEcSubstreamSize() {
        return this.ecSubstreamSize;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getMachineType() {
        return this.machineType;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void setSignature(long l) {
        this.signature = l;
    }

    public void setVersion(HeaderVersion headerVersion) {
        this.version = headerVersion;
    }

    public void setAge(long l) {
        this.age = l;
    }

    public void setGsSymbolsStream(int n) {
        this.gsSymbolsStream = n;
    }

    public void setInternalVersion(int n) {
        this.internalVersion = n;
    }

    public void setPsSymbolsStream(int n) {
        this.psSymbolsStream = n;
    }

    public void setPdbDllBuildVersion(int n) {
        this.pdbDllBuildVersion = n;
    }

    public void setSymbolRecordsStream(int n) {
        this.symbolRecordsStream = n;
    }

    public void setPdbDllRbldVersion(int n) {
        this.pdbDllRbldVersion = n;
    }

    public void setModuleListSize(long l) {
        this.moduleListSize = l;
    }

    public void setSectionContributionSize(long l) {
        this.sectionContributionSize = l;
    }

    public void setSectionMapSize(long l) {
        this.sectionMapSize = l;
    }

    public void setFileInfoSize(long l) {
        this.fileInfoSize = l;
    }

    public void setTypeServerMapSize(long l) {
        this.typeServerMapSize = l;
    }

    public void setMfcTypeServerIndex(long l) {
        this.mfcTypeServerIndex = l;
    }

    public void setDebugHeaderSize(long l) {
        this.debugHeaderSize = l;
    }

    public void setEcSubstreamSize(long l) {
        this.ecSubstreamSize = l;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public void setMachineType(int n) {
        this.machineType = n;
    }

    public void setReserved(long l) {
        this.reserved = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DBIHeader)) {
            return false;
        }
        DBIHeader dBIHeader = (DBIHeader)object;
        if (!dBIHeader.canEqual(this)) {
            return false;
        }
        if (this.getSignature() != dBIHeader.getSignature()) {
            return false;
        }
        if (this.getAge() != dBIHeader.getAge()) {
            return false;
        }
        if (this.getGsSymbolsStream() != dBIHeader.getGsSymbolsStream()) {
            return false;
        }
        if (this.getInternalVersion() != dBIHeader.getInternalVersion()) {
            return false;
        }
        if (this.getPsSymbolsStream() != dBIHeader.getPsSymbolsStream()) {
            return false;
        }
        if (this.getPdbDllBuildVersion() != dBIHeader.getPdbDllBuildVersion()) {
            return false;
        }
        if (this.getSymbolRecordsStream() != dBIHeader.getSymbolRecordsStream()) {
            return false;
        }
        if (this.getPdbDllRbldVersion() != dBIHeader.getPdbDllRbldVersion()) {
            return false;
        }
        if (this.getModuleListSize() != dBIHeader.getModuleListSize()) {
            return false;
        }
        if (this.getSectionContributionSize() != dBIHeader.getSectionContributionSize()) {
            return false;
        }
        if (this.getSectionMapSize() != dBIHeader.getSectionMapSize()) {
            return false;
        }
        if (this.getFileInfoSize() != dBIHeader.getFileInfoSize()) {
            return false;
        }
        if (this.getTypeServerMapSize() != dBIHeader.getTypeServerMapSize()) {
            return false;
        }
        if (this.getMfcTypeServerIndex() != dBIHeader.getMfcTypeServerIndex()) {
            return false;
        }
        if (this.getDebugHeaderSize() != dBIHeader.getDebugHeaderSize()) {
            return false;
        }
        if (this.getEcSubstreamSize() != dBIHeader.getEcSubstreamSize()) {
            return false;
        }
        if (this.getFlags() != dBIHeader.getFlags()) {
            return false;
        }
        if (this.getMachineType() != dBIHeader.getMachineType()) {
            return false;
        }
        if (this.getReserved() != dBIHeader.getReserved()) {
            return false;
        }
        HeaderVersion headerVersion = this.getVersion();
        HeaderVersion headerVersion2 = dBIHeader.getVersion();
        return !(headerVersion == null ? headerVersion2 != null : !((Object)((Object)headerVersion)).equals((Object)headerVersion2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DBIHeader;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSignature();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getAge();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        n2 = n2 * 59 + this.getGsSymbolsStream();
        n2 = n2 * 59 + this.getInternalVersion();
        n2 = n2 * 59 + this.getPsSymbolsStream();
        n2 = n2 * 59 + this.getPdbDllBuildVersion();
        n2 = n2 * 59 + this.getSymbolRecordsStream();
        n2 = n2 * 59 + this.getPdbDllRbldVersion();
        long l3 = this.getModuleListSize();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getSectionContributionSize();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = this.getSectionMapSize();
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        long l6 = this.getFileInfoSize();
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        long l7 = this.getTypeServerMapSize();
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        long l8 = this.getMfcTypeServerIndex();
        n2 = n2 * 59 + (int)(l8 >>> 32 ^ l8);
        long l9 = this.getDebugHeaderSize();
        n2 = n2 * 59 + (int)(l9 >>> 32 ^ l9);
        long l10 = this.getEcSubstreamSize();
        n2 = n2 * 59 + (int)(l10 >>> 32 ^ l10);
        n2 = n2 * 59 + this.getFlags();
        n2 = n2 * 59 + this.getMachineType();
        long l11 = this.getReserved();
        n2 = n2 * 59 + (int)(l11 >>> 32 ^ l11);
        HeaderVersion headerVersion = this.getVersion();
        n2 = n2 * 59 + (headerVersion == null ? 43 : ((Object)((Object)headerVersion)).hashCode());
        return n2;
    }

    public String toString() {
        return "DBIHeader(signature=" + this.getSignature() + ", version=" + (Object)((Object)this.getVersion()) + ", age=" + this.getAge() + ", gsSymbolsStream=" + this.getGsSymbolsStream() + ", internalVersion=" + this.getInternalVersion() + ", psSymbolsStream=" + this.getPsSymbolsStream() + ", pdbDllBuildVersion=" + this.getPdbDllBuildVersion() + ", symbolRecordsStream=" + this.getSymbolRecordsStream() + ", pdbDllRbldVersion=" + this.getPdbDllRbldVersion() + ", moduleListSize=" + this.getModuleListSize() + ", sectionContributionSize=" + this.getSectionContributionSize() + ", sectionMapSize=" + this.getSectionMapSize() + ", fileInfoSize=" + this.getFileInfoSize() + ", typeServerMapSize=" + this.getTypeServerMapSize() + ", mfcTypeServerIndex=" + this.getMfcTypeServerIndex() + ", debugHeaderSize=" + this.getDebugHeaderSize() + ", ecSubstreamSize=" + this.getEcSubstreamSize() + ", flags=" + this.getFlags() + ", machineType=" + this.getMachineType() + ", reserved=" + this.getReserved() + ")";
    }
}

