/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.common;

import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import com.uqm.crashsight.symtabtool.pdb.omap.Rva;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class PdbInternalSectionOffset {
    private long offset;
    private int section;

    public static PdbInternalSectionOffset parse(ParseBuffer parseBuffer) {
        return new PdbInternalSectionOffset(parseBuffer.readU32(), parseBuffer.readU16());
    }

    public static PdbInternalSectionOffset empty() {
        return new PdbInternalSectionOffset(0L, 0);
    }

    public PdbInternalSectionOffset(long l, int n) {
        this.offset = l;
        this.section = n;
    }

    public Rva toRva(AddressMap addressMap) {
        return this.toInternalRva(addressMap).toRva(addressMap);
    }

    public PdbInternalRva toInternalRva(AddressMap addressMap) {
        Long l = AddressMap.getVirtualAddress(addressMap.getOriginalSections(), this.section, this.offset);
        return new PdbInternalRva(l);
    }

    public PdbInternalSectionOffset add(long l) {
        return new PdbInternalSectionOffset(this.offset + l, this.section);
    }

    public boolean isEq(PdbInternalSectionOffset pdbInternalSectionOffset) {
        return this.section == pdbInternalSectionOffset.getSection() && this.offset == pdbInternalSectionOffset.getOffset();
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSection() {
        return this.section;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public void setSection(int n) {
        this.section = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PdbInternalSectionOffset)) {
            return false;
        }
        PdbInternalSectionOffset pdbInternalSectionOffset = (PdbInternalSectionOffset)object;
        if (!pdbInternalSectionOffset.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != pdbInternalSectionOffset.getOffset()) {
            return false;
        }
        return this.getSection() == pdbInternalSectionOffset.getSection();
    }

    protected boolean canEqual(Object object) {
        return object instanceof PdbInternalSectionOffset;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        n2 = n2 * 59 + this.getSection();
        return n2;
    }

    public String toString() {
        return "PdbInternalSectionOffset(offset=" + this.getOffset() + ", section=" + this.getSection() + ")";
    }
}

