/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.pdb.Collector;
import com.uqm.crashsight.symtabtool.pdb.Module;
import com.uqm.crashsight.symtabtool.pdb.PDBInfo;
import com.uqm.crashsight.symtabtool.pdb.dbi.DebugInformation;
import com.uqm.crashsight.symtabtool.pdb.dbi.ModuleIter;
import com.uqm.crashsight.symtabtool.pdb.module.ModuleInfo;
import com.uqm.crashsight.symtabtool.pdb.module.PSymbolTable;
import com.uqm.crashsight.symtabtool.pdb.module.source.LineProgram;
import com.uqm.crashsight.symtabtool.pdb.module.source.Lines;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceFiles;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceLineCollector;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.Rva;
import com.uqm.crashsight.symtabtool.pdb.symbol.BlockInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.BlockSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.ProcedureSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PublicSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.RegisterRelativeSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.SelectedSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.SeparatedCodeSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.SymbolData;
import com.uqm.crashsight.symtabtool.pdb.symbol.SymbolIter;

public class PDBData {
    AddressMap addressMap;

    public PDBData(AddressMap addressMap) {
        this.addressMap = addressMap;
    }

    public void handleSymbol(SymbolData symbolData, Collector collector, SourceLineCollector sourceLineCollector, ModuleInfo moduleInfo) {
        if (symbolData.getProcedure() != null) {
            ProcedureSymbol procedureSymbol = symbolData.getProcedure();
            Rva rva = procedureSymbol.getOffset().toRva(this.addressMap);
            if (rva == null || rva.isNone()) {
                return;
            }
            collector.addProcedureSymbol(procedureSymbol, new BlockInfo(rva.getAddress(), procedureSymbol.getOffset(), procedureSymbol.getLen()), sourceLineCollector);
        } else if (symbolData.getBlock() != null) {
            BlockSymbol blockSymbol = symbolData.getBlock();
            this.addBlock(moduleInfo, blockSymbol, collector, sourceLineCollector);
        } else if (symbolData.getSeparatedCode() != null) {
            SeparatedCodeSymbol separatedCodeSymbol = symbolData.getSeparatedCode();
            this.addSepcode(separatedCodeSymbol, collector, sourceLineCollector);
        } else if (symbolData.getRegisterRelative() != null) {
            RegisterRelativeSymbol registerRelativeSymbol = symbolData.getRegisterRelative();
            collector.addRegRel(registerRelativeSymbol);
        } else if (symbolData.getScopeEnd() != null) {
            collector.closeProcedure();
        }
    }

    public void collectPublicSymbols(PSymbolTable pSymbolTable, Collector collector) {
        PSymbol pSymbol;
        SymbolIter symbolIter = pSymbolTable.iter();
        while ((pSymbol = symbolIter.next()) != null) {
            PublicSymbol publicSymbol;
            SymbolData symbolData = pSymbol.parse();
            if (symbolData == null || symbolData.isNone() || symbolData.getPublic_() == null || (publicSymbol = symbolData.getPublic_()).getOffset().getSection() > 7) continue;
            collector.addPublicSymbol(publicSymbol, this.addressMap);
        }
    }

    public void collectFunctions(PDBInfo pDBInfo, DebugInformation debugInformation, Collector collector, SourceFiles sourceFiles) {
        Module module;
        ModuleIter moduleIter = debugInformation.getModules();
        while ((module = moduleIter.next()) != null) {
            PSymbol pSymbol;
            ModuleInfo moduleInfo = pDBInfo.getModuleInfo(module);
            if (moduleInfo == null) continue;
            if (moduleInfo.getLinesSize() + moduleInfo.getSymbolsSize() > (long)moduleInfo.getBuffer().getBuffer().limit()) break;
            LineProgram lineProgram = moduleInfo.getLineProgram();
            SourceLineCollector sourceLineCollector = new SourceLineCollector(this.addressMap, sourceFiles, lineProgram);
            SymbolIter symbolIter = moduleInfo.getSymbols();
            while ((pSymbol = symbolIter.next()) != null) {
                SymbolData symbolData = pSymbol.parse();
                if (symbolData == null) continue;
                this.handleSymbol(symbolData, collector, sourceLineCollector, moduleInfo);
            }
        }
    }

    public void addBlock(ModuleInfo moduleInfo, BlockSymbol blockSymbol, Collector collector, SourceLineCollector sourceLineCollector) {
        PSymbol pSymbol = moduleInfo.symbolsAt(blockSymbol.getParent()).next();
        if (pSymbol == null) {
            return;
        }
        SymbolData symbolData = pSymbol.parse();
        if (symbolData == null) {
            return;
        }
        ProcedureSymbol procedureSymbol = symbolData.getProcedure();
        if (procedureSymbol == null) {
            return;
        }
        Rva rva = blockSymbol.getOffset().toRva(this.addressMap);
        if (rva == null) {
            return;
        }
        Rva rva2 = procedureSymbol.getOffset().toRva(this.addressMap);
        if (rva2 == null) {
            return;
        }
        if (rva.getAddress() < rva2.getAddress() || rva.getAddress() > rva2.getAddress() + procedureSymbol.getLen()) {
            collector.addProcedureSymbol(procedureSymbol, new BlockInfo(rva.getAddress(), blockSymbol.getOffset(), blockSymbol.getLen()), sourceLineCollector);
        }
    }

    public void addSepcode(SeparatedCodeSymbol separatedCodeSymbol, Collector collector, SourceLineCollector sourceLineCollector) {
        Rva rva = separatedCodeSymbol.getOffset().toRva(this.addressMap);
        if (rva == null) {
            return;
        }
        Rva rva2 = separatedCodeSymbol.getParentOffset().toRva(this.addressMap);
        if (rva2 == null) {
            return;
        }
        SelectedSymbol selectedSymbol = collector.getSymbolAt(rva2.getAddress());
        if (selectedSymbol != null && (rva.getAddress() < rva2.getAddress() || rva.getAddress() > rva2.getAddress() + selectedSymbol.getLen())) {
            Lines lines = sourceLineCollector.collectSourceLines(separatedCodeSymbol.getOffset(), separatedCodeSymbol.getLen());
            SelectedSymbol selectedSymbol2 = new SelectedSymbol(selectedSymbol.getName(), selectedSymbol.getTypeIndex(), selectedSymbol.isPublic(), false, separatedCodeSymbol.getOffset(), selectedSymbol.getSymOffset(), separatedCodeSymbol.getLen(), selectedSymbol.getParameterSize(), lines, selectedSymbol.getEbp(), selectedSymbol.getId());
            collector.addSymbol(selectedSymbol2, new BlockInfo(rva.getAddress(), separatedCodeSymbol.getOffset(), separatedCodeSymbol.getLen()));
        }
    }
}

